/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 */
public class Operator extends Enum {
    static final private int _CLEAR = 0;

    static final public Operator CLEAR = new Operator(_CLEAR);

    static final private int _SOURCE = 1;

    static final public Operator SOURCE = new Operator(_SOURCE);

    static final private int _OVER = 2;

    static final public Operator OVER = new Operator(_OVER);

    static final private int _IN = 3;

    static final public Operator IN = new Operator(_IN);

    static final private int _OUT = 4;

    static final public Operator OUT = new Operator(_OUT);

    static final private int _ATOP = 5;

    static final public Operator ATOP = new Operator(_ATOP);

    static final private int _DEST = 6;

    static final public Operator DEST = new Operator(_DEST);

    static final private int _DEST_OVER = 7;

    static final public Operator DEST_OVER = new Operator(_DEST_OVER);

    static final private int _DEST_IN = 8;

    static final public Operator DEST_IN = new Operator(_DEST_IN);

    static final private int _DEST_OUT = 9;

    static final public Operator DEST_OUT = new Operator(_DEST_OUT);

    static final private int _DEST_ATOP = 10;

    static final public Operator DEST_ATOP = new Operator(_DEST_ATOP);

    static final private int _XOR = 11;

    static final public Operator XOR = new Operator(_XOR);

    static final private int _ADD = 12;

    static final public Operator ADD = new Operator(_ADD);

    static final private int _SATURATE = 13;

    static final public Operator SATURATE = new Operator(_SATURATE);

    static final private Operator[] theInterned = new Operator[] { CLEAR,
            SOURCE, OVER, IN, OUT, ATOP, DEST, DEST_OVER, DEST_IN, DEST_OUT,
            DEST_ATOP, XOR, ADD, SATURATE };

    static private java.util.Hashtable theInternedExtras;

    static final private Operator theSacrificialOne = new Operator(0);

    static public Operator intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        Operator already = (Operator) theInternedExtras.get(theSacrificialOne);
        if (already == null) {
            already = new Operator(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private Operator(int value) {
        value_ = value;
    }

    public boolean test(Operator other) {
        return (value_ & other.value_) == other.value_;
    }
}
