/*
   Firmware loader for 3Com Bluetooth PCCARD 
   Copyright (C) 2002  Marcel Holtmann <marcel@holtmann.org>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 * $Id: bt3c_pccard.c,v 1.2 2002/10/28 00:24:51 holtmann Exp $
 */

#ifdef BT3C_SUPPORT

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/io.h>
#include <sys/stat.h>
#include <sys/ioctl.h>

#include <pcmcia/cs_types.h>
#include <pcmcia/cs.h>
#include <pcmcia/cistpl.h>
#include <pcmcia/ds.h>

#include "bluefw.h"
#include "pccard.h"

#define DATA_L   0
#define DATA_H   1
#define ADDR_L   2
#define ADDR_H   3
#define CONTROL  4

static void bt3c_address(unsigned int iobase, unsigned short addr)
{
	outb(addr & 0xff, iobase + ADDR_L);
	outb((addr >> 8) & 0xff, iobase + ADDR_H);
}

static void bt3c_put(unsigned int iobase, unsigned short value)
{
	outb(value & 0xff, iobase + DATA_L);
	outb((value >> 8) & 0xff, iobase + DATA_H);
}

int bt3c_pccard_loader(devio_t io, devinfo_t *info)
{
	FILE *file;
	char filename[128];
	char buf[80];
	char b[9];
	unsigned int size, addr, fcs, tmp;
	int i;

	snprintf(filename, sizeof(filename), "%s/%s", FWDIR, info->firmware);

	if (!(file = fopen(filename, "r"))) {
		syslog(LOG_ERR, "Can't open firmware file %s", filename);
		return -EIO;
	}

	iopl(3);

	/* Reset */

	bt3c_address(io.iobase, 0x8040);
	bt3c_put(io.iobase, 0x0404);

	bt3c_address(io.iobase, 0x8040);
	bt3c_put(io.iobase, 0x0400);

	usleep(1);

	bt3c_address(io.iobase, 0x8040);
	bt3c_put(io.iobase, 0x0404);

	usleep(17);

	while (fgets(buf, 80, file)) {
		memset(b, 0, sizeof(b));
		memcpy(b, buf + 2, 2);
		size = strtol(b, NULL, 16);

		memset(b, 0, sizeof(b));
		memcpy(b, buf + 4, 8);
		addr = strtol(b, NULL, 16);

		memset(b, 0, sizeof(b));
		memcpy(b, buf + (size * 2) + 2, 2);
		fcs = strtol(b, NULL, 16);

		tmp = 0;
		memset(b, 0, sizeof(b));
		for (i = 0; i < size; i++) {
			memcpy(b, buf + (i * 2) + 2, 2);
			tmp += strtol(b, NULL, 16);
		}

		if (((tmp + fcs) & 0xff) != 0xff) {
			syslog(LOG_INFO, "Checksum error in firmware file %s", filename);
			fclose(file);
			return -1;
		}

		if (buf[1] == '3') {
			bt3c_address(io.iobase, addr);

			memset(b, 0, sizeof(b));
			for (i = 0; i < (size - 4) / 2; i++) {
			      memcpy(b, buf + (i * 4) + 12, 4);
			      tmp = strtol(b, NULL, 16);
			      bt3c_put(io.iobase, tmp);
			}
		}

	}

	usleep(17);

	/* Boot */

	bt3c_address(io.iobase, 0x3000);
	outb(inb(io.iobase + CONTROL) | 0x40, io.iobase + CONTROL);

	usleep(17);

	/* Clear */

	bt3c_address(io.iobase, 0x7006);
	bt3c_put(io.iobase, 0x0000);

	bt3c_address(io.iobase, 0x7005);
	bt3c_put(io.iobase, 0x0000);

	bt3c_address(io.iobase, 0x7001);
	bt3c_put(io.iobase, 0x0000);

	fclose(file);
	return 0;
}

#endif /* BT3C_SUPPORT */
