/*
  Copyright (C) 2008 Craciun Dan

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
  for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc., 51
  Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xchat/xchat-plugin.h"

#define PNAME "ANP"
#define PVERS "0.2.4"
#define PDESC "Amarok Now Playing Plugin"

static xchat_plugin *ph;

/* Function declarations */

void xchat_plugin_get_info (char **name, char **desc, char **version, void **reserved)
{
	*name = PNAME;
	*desc = PDESC;
	*version = PVERS;
}

/* Used for output of console commands, like 'dcop' */
int pop (char *cmd, char *out)
{
	FILE *pop;
	pop = popen (cmd, "r"); /* execute cmd and catch its output */
	fgets (out, 500, pop); /* out will hold the output of cmd */
	fclose (pop);
	return 0;
}

/* The /ANPHELP command */
static int cmd_anphelp (char *word[], char *word_eol[], void *userdata)
{
	xchat_command (ph, "ECHO ---");
	xchat_command (ph, "ECHO ANP: ANP Commands:");
	xchat_command (ph, "ECHO ANP: /ANP   /ANPMSG   /ANPMENU   /ANPHELP   /ANPABOUT");
	xchat_command (ph, "ECHO ANP: Control Amarok:");
	xchat_command (ph, "ECHO ANP: /PLAY   /PAUSE   /STOP");
	xchat_command (ph, "ECHO ANP: Type /HELP <COMMAND> to see a description for COMMAND");
	xchat_command (ph, "ECHO ---");
	return XCHAT_EAT_ALL;
}

/* The /PLAY command */
static int cmd_play (char *word[], char *word_eol[], void *userdata)
{
	char cmd[100];
	char isPlaying[5];
	strcpy (cmd, "dcop amarok default isPlaying");
	pop (cmd, isPlaying);
	isPlaying[strlen (isPlaying) - 1] = '\0';
	if (strcmp (isPlaying, "false") == 0)
	{
		system ("dcop amarok default play");
		xchat_command (ph, "ECHO ANP: Started playing a song in Amarok");
		return XCHAT_EAT_ALL;
	}
	if (strcmp (isPlaying, "true") == 0)
	{
		xchat_command (ph, "ECHO ANP: Amarok is already playing");
		return XCHAT_EAT_ALL;
	}
	xchat_command (ph, "ECHO ANP: Amarok is not running or DCOP error");
	return XCHAT_EAT_ALL;
}

/* The /PAUSE command */
static int cmd_pause (char *word[], char *word_eol[], void *userdata)
{
	char cmd[100];
	char isPlaying[5];
	strcpy (cmd, "dcop amarok default isPlaying");
	pop (cmd, isPlaying);
	isPlaying[strlen (isPlaying) - 1] = '\0';
	if (strcmp (isPlaying, "true") == 0)
	{
		system ("dcop amarok default pause");
		xchat_command (ph, "ECHO ANP: Paused playing in Amarok");
		return XCHAT_EAT_ALL;
	}
	if (strcmp (isPlaying, "false") == 0)
	{
		xchat_command (ph, "ECHO ANP: Amarok is already stopped or paused");
		return XCHAT_EAT_ALL;
	}
	xchat_command (ph, "ECHO ANP: Amarok is not running or DCOP error");
	return XCHAT_EAT_ALL;
}

/* The /STOP command */
static int cmd_stop (char *word[], char *word_eol[], void *userdata)
{
	char cmd[100];
	char isPlaying[5];
	strcpy (cmd, "dcop amarok default isPlaying");
	pop (cmd, isPlaying);
	isPlaying[strlen (isPlaying) - 1] = '\0';
	/* TODO: This function does not verify if Amarok is already stopped. Do it properly (if possible) */
	if (strcmp (isPlaying, "true") == 0 || strcmp (isPlaying, "false") == 0)
	{
		system ("dcop amarok default stop");
		xchat_command (ph, "ECHO ANP: Stopped playing in Amarok");
		return XCHAT_EAT_ALL;
	}
	xchat_command (ph, "ECHO ANP: Amarok is not running or DCOP error");
	return XCHAT_EAT_ALL;
}
	
/* The /ANPMSG command */
static int cmd_anpmsg (char *word[], char *word_eol[], void *userdata)
{
	FILE *file;
	char msg[32];
	/* default msg is 'Rocks: ' */
	if (strlen (word_eol[2]) <= 32 && strlen (word_eol[2]) >= 2)
	{
		system ("mkdir -p ~/.xchat2/anp/"); /* create the ~/.xchat2/anp/ directory */
		file = fopen (".xchat2/anp/msg", "w");
		if (!file) /* could not create file for writing */
		{
			xchat_command (ph, "ECHO ANP: Could not create ~/.xchat2/anp/msg file. Check disk space and file permissions.");
			return XCHAT_EAT_ALL;
		}
		fputs (word_eol[2], file);
		fclose (file);
		xchat_commandf (ph, "ECHO ANP: Message set to '%s'", word_eol[2]);
		return XCHAT_EAT_ALL;
	}
	else
	{
		if (strlen (word_eol[2]) != 0)
		{
			xchat_command (ph, "ECHO ANP: The message can have minimum 2 characters and maximum 32 characters");
			return XCHAT_EAT_ALL;
		}
		else
		{
			system ("mkdir -p ~/.xchat2/anp"); /* is there a better way to do this? */
			file = fopen (".xchat2/anp/msg", "r");
			if (!file) /* could not read file */
			{
				system ("mkdir -p ~/.xchat2/anp"); /* is there a better way to do this? */
				file = fopen (".xchat2/anp/msg", "w");
				if (!file) /* could not create file for writing */
				{
					xchat_command (ph, "ECHO ANP: Could not read/create ~/.xchat2/anp/msg file. Check disk space and file permissions.");
					return XCHAT_EAT_ALL;
				}
				fputs ("Rocks:", file); /* put default message in file */
				fclose (file);
				xchat_command (ph, "ECHO ANP: ANP file not found, replaced with default");
				xchat_command (ph, "ECHO ANP: Message is set to 'Rocks:'");
				return XCHAT_EAT_ALL;
			}
			else /* file found, get msg */
			{
				fgets (msg, 32, file);
				fclose (file);
				msg[strlen (msg)] = '\0';
			}
			xchat_commandf (ph, "ECHO ANP: Message is set to '%s'", msg);
			return XCHAT_EAT_ALL;
		}
	}
	return XCHAT_EAT_ALL;
}

/* The /ANP command */
static int cmd_anp (char *word[], char *word_eol[], void *userdata)
{
	char cmd[100];
	char nowPlaying[600], display[600];
	char isPlaying[5];
	strcpy (cmd, "dcop amarok default isPlaying");
	pop (cmd, isPlaying);
	isPlaying[strlen (isPlaying) - 1] = '\0';
	if (strcmp (isPlaying, "true") == 0)
	{
		FILE *file;
		char msg[32];
		file = fopen (".xchat2/anp/msg", "r");
		if (!file) /* if file not found or inaccesible, create the default one */
		{
			system ("mkdir -p ~/.xchat2/anp"); /* is there a better way to do this? */
			file = fopen (".xchat2/anp/msg", "w");
			if (!file) /* could not create file for writing */
			{
				xchat_command (ph, "ECHO ANP: Could not read/create ~/.xchat2/anp/msg file. Check disk space and file permissions.");
				return XCHAT_EAT_ALL;
			}
			fputs ("Rocks:", file); /* put default message in file */
			fclose (file);
			xchat_command (ph, "ECHO ANP: ANP file not found, replaced with default");
			strcpy (msg, "Rocks:");
		}
		else /* file found, get msg */
		{
			fgets (msg, 32, file);
			fclose (file);
			msg[strlen (msg)] = '\0';
		}
		strcpy (cmd, "dcop amarok default nowPlaying");
		pop (cmd, nowPlaying);
		nowPlaying[strlen (nowPlaying) - 1] = '\0';
		strcpy (display, msg);
		strcat (display, nowPlaying);
		xchat_commandf (ph, "ME %s %s", msg, nowPlaying);
		return XCHAT_EAT_ALL;
	}
	if (strcmp (isPlaying, "false") == 0)
	{
		xchat_command (ph, "ECHO ANP: Amarok is either stopped or paused");
		return XCHAT_EAT_ALL;
	}
	xchat_command (ph, "ECHO ANP: Amarok is not running or DCOP error");
	return XCHAT_EAT_ALL;
}

static int cmd_anpmenu (char *word[], char *word_eol[], void *userdata)
{
	FILE *file;
	char val[3];
	if (strcmp (word_eol[2], "") != 0)
	{
		if (strcmp (word_eol[2], "1") == 0)
		{
			file = fopen (".xchat2/anp/menu", "r");
			if (file)
			{
				fgets (val, 3, file);
				if (strcmp (val, "on") != 0)
				{
					fclose (file);
					file = fopen (".xchat2/anp/menu", "w");
					fputs ("on", file);
					fclose (file);
					xchat_command (ph, "MENU DEL ANP");
					
					/* Create the ANP menu and submenus */
					xchat_command (ph, "MENU -p6 ADD \"ANP\"");
	
					xchat_command (ph, "MENU ADD \"ANP/Amarok\"");
					xchat_command (ph, "MENU ADD \"ANP/Amarok/Play\" \"PLAY\"");
					xchat_command (ph, "MENU ADD \"ANP/Amarok/Pause\" \"PAUSE\"");
					xchat_command (ph, "MENU ADD \"ANP/Amarok/Stop\" \"STOP\"");
	
					xchat_command (ph, "MENU ADD \"ANP/-\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands/ANP\" \"anp\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands/ANPHELP\" \"anphelp\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands/-\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands/Show Message\" \"anpmsg\"");
					xchat_command (ph, "MENU ADD \"ANP/Commands/Show Menu Status\" \"anpmenu\"");
			
					xchat_command (ph, "MENU ADD \"ANP/-\"");
					xchat_command (ph, "MENU ADD \"ANP/Set\"");
					xchat_command (ph, "MENU ADD \"ANP/Set/Menu\"");
					xchat_command (ph, "MENU ADD \"ANP/Set/Menu/ON\" \"anpmenu 1\"");
					xchat_command (ph, "MENU ADD \"ANP/Set/Menu/OFF\" \"anpmenu 0\"");
	
					xchat_command (ph, "MENU ADD \"ANP/-\"");
					xchat_command (ph, "MENU ADD \"ANP/About\" \"anpabout\"");
					
					xchat_command (ph, "ECHO ANP: Menu is now ON");
				}
				else
				{
					xchat_command (ph, "ECHO ANP: Menu is already ON");
				}
			}
			else
			{
				xchat_command (ph, "ECHO ANP: Could not read file .xchat2/anp/menu");
				file = fopen (".xchat2/anp/menu", "w");
				if (file)
				{
					fputs ("on", file);
					xchat_command (ph, "ECHO ANP: File ~/.xchat2/anp/menu created");
					xchat_command (ph, "ECHO ANP: Menu is now ON");
					fclose (file);
				}
				else
				{
					xchat_command (ph, "ECHO ANP: Could not create file ~/.xchat2/anp/menu. Check disk space and file permissions.");
					return XCHAT_EAT_ALL;
				}
			}
		}
		if (strcmp (word_eol[2], "0") == 0)
		{
			file = fopen (".xchat2/anp/menu", "r");
			if (file)
			{
				fgets (val, 4, file);
				if (strcmp (val, "off") != 0)
				{
					fclose (file);
					file = fopen (".xchat2/anp/menu", "w");
					if (file)
					{
						fputs ("off", file);
						fclose (file);
						xchat_command (ph, "MENU DEL ANP");
						xchat_command (ph, "ECHO ANP: Menu is now OFF. To bring the menu back, type /ANPMENU 1.");
						return XCHAT_EAT_ALL;
					}
					else
					{
						xchat_command (ph, "ECHO ANP: Could not write to file ~/.xchat2/anp/menu. Check disk space and file permissions.");
						return XCHAT_EAT_ALL;
					}
				}
				else
				{
					xchat_command (ph, "ECHO ANP: Menu is already OFF");
					return XCHAT_EAT_ALL;
				}
			}
			else
			{
				xchat_command (ph, "ECHO ANP: Could not read file .xchat2/anp/menu");
				return XCHAT_EAT_ALL;
			}
		}
		if (strcmp (word_eol[2], "0") != 0 && strcmp (word_eol[2], "1") != 0)
		{
			xchat_command (ph, "ECHO Usage: ANPMENU [1|0], toggle displaying ANP menu");
			return XCHAT_EAT_ALL;
		}
	}
	else
	{
		file = fopen (".xchat2/anp/menu", "r");
		if (file)
		{
			fgets (val, 4, file);
			if (strcmp (val, "on") == 0)
			{
				xchat_command (ph, "ECHO ANP: Menu is ON");
				fclose (file);
				return XCHAT_EAT_ALL;
			}
			else
			{
				xchat_command (ph, "ECHO ANP: Menu is OFF");
				fclose (file);
				return XCHAT_EAT_ALL;
			}
			fclose (file);
		}
		else
		{
			xchat_command (ph, "ECHO ANP: Could not read file .xchat2/anp/menu.");
			return XCHAT_EAT_ALL;
		}
	}
	return XCHAT_EAT_ALL;
}

/* The /ANPABOUT command */
static int cmd_anpabout (char *word[], char *word_eol[], void *userdata)
{
	xchat_commandf (ph, "GUI MSGBOX \"ANP 0.2.4\n\nAmarok Now Playing Plugin\n\n(C) 2008 Craciun Dan\n\nhttp://project-lsp.sourceforge.net/scripts.html\"");
	return XCHAT_EAT_ALL;
}

int xchat_plugin_init (xchat_plugin *plugin_handle, char **plugin_name, char **plugin_desc, char **plugin_version, char *arg)
{
	ph = plugin_handle;
	*plugin_name = PNAME;
	*plugin_version = PVERS;
	*plugin_desc = PDESC;

	/* Messages to display when the plugin is loaded */
	xchat_command (ph, "ECHO ---");
	xchat_command (ph, "ECHO ANP: ANP 0.2.4 by Craciun Dan loaded");
	xchat_command (ph, "ECHO ANP: Amarok Now Playing Plugin for XChat");
	xchat_command (ph, "ECHO ANP: Type /ANP in any channel or query window to use it. Type /ANPHELP for a list of commands.");
	xchat_command (ph, "ECHO ANP: For updates visit the homepage at http://project-lsp.sourceforge.net/scripts.html");
	xchat_command (ph, "ECHO ---");
	
	/* Command declarations */
	xchat_hook_command (ph, "ANP", XCHAT_PRI_NORM, cmd_anp, "Usage: ANP, shows currently playing song in Amarok", 0);
	xchat_hook_command (ph, "ANPMSG", XCHAT_PRI_NORM, cmd_anpmsg, "Usage: ANPMSG [MESSAGE], change the message to display", 0);
	xchat_hook_command (ph, "ANPMENU", XCHAT_PRI_NORM, cmd_anpmenu, "Usage: ANPMENU [1|0], toggle displaying ANP menu", 0);
	xchat_hook_command (ph, "ANPHELP", XCHAT_PRI_NORM, cmd_anphelp, "Usage: ANPHELP, shows a list of commands", 0);
	
	xchat_hook_command (ph, "ANPABOUT", XCHAT_PRI_NORM, cmd_anpabout, "Usage: ANPABOUT, displays ANP About message box", 0);
	xchat_hook_command (ph, "PLAY", XCHAT_PRI_NORM, cmd_play, "Usage: PLAY, start playing a song in Amarok", 0);
	xchat_hook_command (ph, "PAUSE", XCHAT_PRI_NORM, cmd_pause, "Usage: PAUSE, pause playing in Amarok", 0);
	xchat_hook_command (ph, "STOP", XCHAT_PRI_NORM, cmd_stop, "Usage: STOP, stop playing in Amarok", 0);
	
	xchat_command (ph, "MENU DEL \"ANP\""); /* first delete menu 'ANP' */
	
	system ("mkdir -p ~/.xchat2/anp");
	FILE *file;
	char val[3];
	file = fopen (".xchat2/anp/menu", "r");
	if (file)
	{
		fgets (val, 4, file);
		if (strcmp (val, "on") == 0) /* if menu is set to ON */
		{
			/* Create the ANP menu and submenus */
			xchat_command (ph, "MENU -p6 ADD \"ANP\"");
	
			xchat_command (ph, "MENU ADD \"ANP/Amarok\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Play\" \"PLAY\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Pause\" \"PAUSE\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Stop\" \"STOP\"");
	
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/ANP\" \"anp\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/ANPHELP\" \"anphelp\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/Show Message\" \"anpmsg\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/Show Menu Status\" \"anpmenu\"");
			
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Set\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu/ON\" \"anpmenu 1\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu/OFF\" \"anpmenu 0\"");
	
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/About\" \"anpabout\"");
		}
		fclose (file);
	}
	else
	{
		file = fopen (".xchat2/anp/menu", "w");
		if (!file)
		{
			xchat_command (ph, "ECHO ANP: Could not create file ~/.xchat2/anp/menu. Check disk space and file permissions.");
		}
		else
		{
			fputs ("on", file);
			xchat_command (ph, "ECHO ANP: File ~/.xchat2/anp/menu created");
			
			/* Create the ANP menu and submenus */
			xchat_command (ph, "MENU -p6 ADD \"ANP\"");
	
			xchat_command (ph, "MENU ADD \"ANP/Amarok\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Play\" \"PLAY\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Pause\" \"PAUSE\"");
			xchat_command (ph, "MENU ADD \"ANP/Amarok/Stop\" \"STOP\"");
	
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/ANP\" \"anp\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/ANPHELP\" \"anphelp\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/Show Message\" \"anpmsg\"");
			xchat_command (ph, "MENU ADD \"ANP/Commands/Show Menu Status\" \"anpmenu\"");
			
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/Set\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu/ON\" \"anpmenu 1\"");
			xchat_command (ph, "MENU ADD \"ANP/Set/Menu/OFF\" \"anpmenu 0\"");
	
			xchat_command (ph, "MENU ADD \"ANP/-\"");
			xchat_command (ph, "MENU ADD \"ANP/About\" \"anpabout\"");
			
			fclose (file);
		}
	}

	return 1;
}
