/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef VIEW_DEVICES_H
#define VIEW_DEVICES_H

//KDE
#include <kdialog.h>

//Ui
#include "ui_viewdevices.h"

/**
 * @brief KDialog showing all known device info.
 *
 * Shows all device-related input collected, such as 
 * partition mountpoint, UUID, grub naming etc.
 */
class ViewDevices : public KDialog, private Ui::ViewDevices
{
Q_OBJECT
public:
	/**
	* Sets up the GUI and shows the device info.
	*
	* @param parent QWidget parent. Self explanatory.
	*/
	ViewDevices( QWidget *parent = 0 );
};

#endif
