/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "gruburlrequester.h"

//KDE
#include <klineedit.h>
#include <kfiledialog.h>

//KGRUBEditor
#include "../core/path.h"

//GRUBPathCompletion
QString GRUBPathCompletion::makeCompletion( const QString &text )
{
	return KUrlCompletion::makeCompletion( Core::Path::convertToGenericPath( text ) );
}

//GRUBUrlRequester
GRUBUrlRequester::GRUBUrlRequester( QWidget *parent ) : KUrlRequester( parent ), m_editor( 0 )
{
	lineEdit()->setClearButtonShown( true );
	lineEdit()->setCompletionObject( new GRUBPathCompletion() );
	connect( this, SIGNAL( openFileDialog( KUrlRequester * ) ), SLOT( openFileDialog( KUrlRequester * ) ) );
	connect( this, SIGNAL( returnPressed( const QString & ) ), SLOT( returnPressed( const QString & ) ) );
	connect( this, SIGNAL( urlSelected( const KUrl & ) ), SLOT( urlSelected( const KUrl & ) ) );

	connect( lineEdit(), SIGNAL( clearButtonClicked() ), SIGNAL( pathCleared() ) );
}

void GRUBUrlRequester::openFileDialog( KUrlRequester * )
{
	QString genericPath = url().path();
	if ( m_editor && !genericPath.startsWith( m_editor->text() ) )
		genericPath.prepend( m_editor->text() );

	genericPath = Core::Path::convertToGenericPath( genericPath );
	fileDialog()->setSelection( genericPath );
}
void GRUBUrlRequester::returnPressed( const QString &text )
{
	if ( text.isEmpty() )
		return;

	QString grubPath = Core::Path::convertToGRUBPath( text );
	if ( m_editor && grubPath.startsWith( m_editor->text() ) )
		grubPath.remove( m_editor->text() );

	setPath( grubPath );
	emit pathChanged( grubPath );
}
void GRUBUrlRequester::urlSelected( const KUrl &url )
{
	if ( url.isEmpty() )
		return;

	QString grubPath = Core::Path::convertToGRUBPath( url.path() );
	if ( m_editor && grubPath.startsWith( m_editor->text() ) )
		grubPath.remove( m_editor->text() );

	setPath( grubPath );
	emit pathChanged( grubPath );
}

#include "gruburlrequester.moc"
