/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef GRUB_ENTRY_PREVIEW_H
#define GRUB_ENTRY_PREVIEW_H

//KDE
#include <qtextedit.h>

//KGRUBEditor
#include "../core/datatypes.h"

/**
 * @short A preview of a GRUB Entry,
 *
 * Shows all the attributes of a GRUB entry using
 * HTML formation so as to provide an attractive output.
 */
class GRUBEntryPreview : public QTextEdit
{
Q_OBJECT
public:
	/**
	* Default constructor.
	*
	* Should be followed by previewEntry(), otherwise it is useless
	* (it does nothing).
	*
	* @param parent QWidget parent. Self explanatory.
	*/
	GRUBEntryPreview( QWidget *parent = 0 );
	/**
	* Secondary constructor where you can also specify the entry to preview.
	*
	* It's equal to calling the default constructor and previewing the entry
	* using previewEntry().
	*
	* @param entry The entry for which a preview will be created.
	* @param parent QWidget parent. Self explanatory.
	*/
	GRUBEntryPreview( const GRUB::ConfigFile::Entry entry, QWidget *parent = 0 );

	/**
	* Previews the entry specified. This is where the "job" is done.
	*
	* @param entry The entry for which a preview will be created.
	*/
	void previewEntry( const GRUB::ConfigFile::Entry entry );
};

#endif
