/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "splashpreviewjob.h"

//KDE
#include <kfilterdev.h>

SplashPreviewJob::SplashPreviewJob( const QString &splashImagePath, QObject *parent ) : ThreadWeaver::Job( parent ), m_splashImagePath( splashImagePath )
{
	connect( this, SIGNAL( done( ThreadWeaver::Job* ) ), SLOT( deleteLater() ) );
}

QImage SplashPreviewJob::splashImage() const
{
	return ( isFinished() ? m_splashImage : QImage() );
}
QImage SplashPreviewJob::splashImageThumb() const
{
	return ( isFinished() ? m_splashImage.scaled( 64, 48 ) : QImage() );
}
QString SplashPreviewJob::absoluteFilePath() const
{
	return m_splashImagePath;
}

void SplashPreviewJob::run()
{
	QIODevice *image = KFilterDev::deviceForFile( m_splashImagePath, "application/x-gzip", true );
	if ( image )
	{
		if ( image->open( QIODevice::ReadOnly ) )
		{
			m_splashImage = QImage::fromData( image->readAll(), "XPM" );
			delete image;
		}
	}
}

#include "splashpreviewjob.moc"
