/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

#ifndef BACKUP_ASSISTANT_H
#define BACKUP_ASSISTANT_H

//KDE
#include <kassistantdialog.h>

//Ui
#include "ui_backup_assistant_intro.h"
#include "ui_backup_assistant_choice.h"
#include "ui_backup_assistant_create.h"
#include "ui_backup_assistant_restore.h"
#include "ui_backup_assistant_delete.h"

/**
 * @short Backup Assistant.
 *
 * Creates/restores/deletes backup files.
 */
class BackupAssistant : public KAssistantDialog
{
Q_OBJECT
public:
	/**
	* Constructor. Populates the KAssistantDialog, shows the paths and
	* connects the signals to their slots.
	*/
	BackupAssistant( QWidget *parent = 0 );
	/**
	* Sets @param menuFile the currently edited configuration file.
	*/
	void setMenuFile( const KUrl &menuFile );
protected slots:
	/**
	* Next: Used to show the appropriate page after the user
	* selected a backup task.
	*
	* Finish: If the user hasn't entered valid information,
	* reject them and prompt the user to enter valid.
	* Of course it is also used to install GRUB.
	*/
	void slotButtonClicked( int button );
private:
	Ui::backup_assistant_intro ui_intro;
	Ui::backup_assistant_choice ui_choice;
	Ui::backup_assistant_create ui_create;
	Ui::backup_assistant_restore ui_restore;
	Ui::backup_assistant_delete ui_delete;

	KPageWidgetItem *choicePage;
	KPageWidgetItem *createPage;
	KPageWidgetItem *restorePage;
	KPageWidgetItem *deletePage;
};

#endif
