/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA  02111-1307, USA.                                          *
 ***************************************************************************/

//Own
#include "backup.h"

//KDE
#include <kio/netaccess.h>
#include <kmessagebox.h>

//KGRUBEditor
#include "core/backup.h"

BackupAssistant::BackupAssistant( QWidget *parent ) : KAssistantDialog( parent )
{
//SETUP UI
	setWindowIcon( KIcon( "document-save-all" ) );
	setCaption( i18nc( "@title:window", "Backup Assistant" ) );
	setAttribute( Qt::WA_DeleteOnClose );
	showButton( KDialog::Help, false );
	setInitialSize( QSize( 500, 400 ) );

	QWidget *intro = new QWidget( this );
	ui_intro.setupUi( intro );
	addPage( intro, i18nc( "@title", "Introduction" ) );
	QWidget *choice = new QWidget( this );
	ui_choice.setupUi( choice );
	choicePage = addPage( choice, i18nc( "@title", "Select Backup Task" ) );
	QWidget *create = new QWidget( this );
	ui_create.setupUi( create );
	createPage = addPage( create, i18nc( "@title", "Create Backup" ) );
	QWidget *restore = new QWidget( this );
	ui_restore.setupUi( restore );
	restorePage = addPage( restore, i18nc( "@title", "Restore Backup" ) );
	QWidget *_delete = new QWidget( this );
	ui_delete.setupUi( _delete );
	deletePage = addPage( _delete, i18nc( "@title", "Delete Backup" ) );
//MISC UI SETUP
	ui_choice.label_iconCreate->setPixmap( KIcon( "document-save-all" ).pixmap( 48, 48 ) );
	ui_choice.label_iconRestore->setPixmap( KIcon( "document-revert" ).pixmap( 48, 48 ) );
	ui_choice.label_iconDelete->setPixmap( KIcon( "edit-delete" ).pixmap( 48, 48 ) );
}
void BackupAssistant::setMenuFile( const KUrl &menuFile )
{
	if ( KIO::NetAccess::exists( menuFile, true, this ) )
	{
		ui_create.kurlrequester_source->setUrl( menuFile );
		ui_restore.kurlrequester_target->setUrl( menuFile );
	}
	if ( KIO::NetAccess::exists( menuFile.path() + "_backup", true, this ) )
	{
		ui_create.kurlrequester_target->setUrl( menuFile.path() + "_backup" );
		ui_restore.kurlrequester_source->setUrl( menuFile.path() + "_backup" );
		ui_delete.kurlrequester->setUrl( menuFile.path() + "_backup" );
	}
}

void BackupAssistant::slotButtonClicked( int button )
{
	//Next
	if ( button == KDialog::User2 )
	{
		if ( currentPage() == choicePage )
		{
			setAppropriate( createPage, ui_choice.radioButton_create->isChecked() );
			setAppropriate( restorePage, ui_choice.radioButton_restore->isChecked() );
			setAppropriate( deletePage, ui_choice.radioButton_delete->isChecked() );
		}
		KDialog::slotButtonClicked( button );
	}
	//Finish
	else if ( button == KDialog::User1 )
	{
		//create
		if ( currentPage() == createPage )
		{
			if ( ui_create.kurlrequester_source->url().isEmpty() || ui_create.kurlrequester_target->url().isEmpty() )
			{
				KMessageBox::sorry( this, i18nc( "@info", "Please fill in all fields." ) );
				return;
			}

			Core::Backup::backup( ui_create.kurlrequester_source->url(), ui_create.kurlrequester_target->url(), this );
			KDialog::slotButtonClicked( button );
		}
		//restore
		if ( currentPage() == restorePage )
		{
			if ( ui_restore.kurlrequester_source->url().isEmpty() || ui_restore.kurlrequester_target->url().isEmpty() )
			{
				KMessageBox::sorry( this, i18nc( "@info", "Please fill in all fields." ) );
				return;
			}

			Core::Backup::backup( ui_restore.kurlrequester_source->url(), ui_restore.kurlrequester_target->url(), this );
			KDialog::slotButtonClicked( button );
		}
		//delete
		if ( currentPage() == deletePage )
		{
			if ( ui_delete.kurlrequester->url().isEmpty() )
			{
				KMessageBox::sorry( this, i18nc( "@info", "Please specify a backup to delete." ) );
				return;
			}

			Core::Backup::deleteBackup( ui_delete.kurlrequester->url(), this );
			KDialog::slotButtonClicked( button );
		}
	}
	else
		KDialog::slotButtonClicked( button );
}

#include "backup.moc"
