/////////////////////////////////////////////////////////////////////////////
// Name:        MenuPropDlg.cpp
// Purpose:     DVD menu properties dialog
// Author:      Alex Thuering
// Created:     25.04.2004
// RCS-ID:      $Id: MenuPropDlg.cpp,v 1.11 2006/10/29 15:42:23 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#include "MenuPropDlg.h"
#include "TitlesetManager.h"
#include "AVPropDlg.h"

enum
{
  AV_BT_ID = 7850
};

BEGIN_EVENT_TABLE(MenuPropDlg, wxPropDlg)
  EVT_BUTTON(AV_BT_ID, MenuPropDlg::OnAV)
END_EVENT_TABLE()

MenuPropDlg::MenuPropDlg(wxWindow *parent, DVD* dvd, int tsi, int pgci):
 wxPropDlg(parent), m_dvd(dvd), m_tsi(tsi), m_pgci(pgci)
{
  PgcArray& pgcs = m_dvd->GetPgcArray(tsi, true);
  m_audio = &pgcs.GetAudio();
  m_video = &pgcs.GetVideo();
  m_pgc = pgcs[pgci];
  m_vob = m_dvd->GetMenuVob(tsi, pgci);
  m_menu = m_vob->GetMenu();
  Create();
  SetSize(400,-1);
}

void MenuPropDlg::CreatePropPanel(wxSizer* sizer)
{
  wxFlexGridSizer* grid = new wxFlexGridSizer(1, 2, 4, 16);
  grid->AddGrowableCol(1);
  wxArrayString formats = DVD::GetVideoFormatStrings();
  AddComboProp(grid, _("Format:"), formats[m_menu->GetVideoFormat()],
   formats, wxCB_READONLY);
  sizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  
  wxSizer* grpSizer = BeginGroup(sizer, _("Background"));
  grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  AddFileProp(grid, _("Image:"), m_menu->GetBackground());
  AddColourProp(grid, _("Colour:"), m_menu->GetBackgroundColour());
  grpSizer->Add(grid, 0, wxEXPAND|wxTOP|wxLEFT|wxRIGHT, 6);
  
  sizer->Add(6,6);
  
  grpSizer = BeginGroup(sizer, _("Subtitles (buttons)"));
  grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  AddTextProp(grid, _("Start time:"), m_menu->GetStartTime());
  AddTextProp(grid, _("End time:"), m_menu->GetEndTime());
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  
  grpSizer = BeginGroup(sizer, _("Video object"));
  grid = new wxFlexGridSizer(2, 4, 16);
  grid->AddGrowableCol(1);
  AddSpinProp(grid, _("Pause:"), m_vob->GetPause(), -1, 254);
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
  
  sizer->Add(6,6);
  
  grpSizer = BeginGroup(sizer, _("Menu"));
  grid = new wxFlexGridSizer(2, 2, 4, 16);
  grid->AddGrowableCol(1);
  
  wxString entry = _T(",") + m_pgc->GetEntry() + _T(",");
  if (m_tsi>=0)
  {
	AddCheckProp(grid, _("Root"), entry.Find(_T(",root,"))>=0);
	AddCheckProp(grid, _("Subtitle"), entry.Find(_T(",subtitle,"))>=0);
    AddCheckProp(grid, _("Chapter"), entry.Find(_T(",ptt,"))>=0);
    AddCheckProp(grid, _("Angle"), entry.Find(_T(",angle,"))>=0);
	AddCheckProp(grid, _("Audio"), entry.Find(_T(",audio,"))>=0);
  }
  else
    AddCheckProp(grid, _("Title"), entry.Find(_T(",title,"))>=0);
  AddText(grid, wxEmptyString);
  
  wxArrayString commands;
  for (int pgci=0; pgci<(int)m_dvd->GetVmgm().Count(); pgci++)
	commands.Add(wxString::Format(_T("jump vmgm menu %d;"),pgci+1));
  for (int tsi=0; tsi<(int)m_dvd->GetTitlesets().Count(); tsi++)
  {
	Titleset* ts = m_dvd->GetTitlesets()[tsi];
	for (int pgci=0; pgci<(int)ts->GetMenus().Count(); pgci++)
	  commands.Add(wxString::Format(_T("jump menu %d;"),pgci+1));
	for (int pgci=0; pgci<(int)ts->GetTitles().Count(); pgci++)
	  commands.Add(wxString::Format(_T("jump title %d;"),pgci+1));
  }
  AddComboProp(grid, _("Pre commands:"), m_pgc->GetPreCommands(), commands);
  AddComboProp(grid, _("Post commands:"), m_pgc->GetPostCommands(), commands);
  grpSizer->Add(grid, 0, wxEXPAND|wxALL, 6);
}

bool MenuPropDlg::SetValues()
{
  int n = 0;
  m_menu->SetVideoFormat((VideoFormat) GetInt(n++));
  m_menu->SetBackground(GetString(n++));
  if (!GetString(n-1).length())
    m_menu->SetBackgroundColour(GetColour(n));
  n++;
  m_menu->SetStartTime(GetString(n++));
  m_menu->SetEndTime(GetString(n++));
  m_vob->SetPause(GetInt(n++));
  wxString entry;
  if (m_tsi>=0)
  {
	if (GetBool(n++))
	  entry += _T("root,");
	if (GetBool(n++))
	  entry += _T("subtitle,");
    if (GetBool(n++))
	  entry += _T("ptt,");
    if (GetBool(n++))
	  entry += _T("angle,");
	if (GetBool(n++))
	  entry += _T("audio,");
  }
  else if (GetBool(n++))
	entry += _T("title,");
  m_pgc->SetEntry(entry.RemoveLast());
  m_pgc->SetPreCommands(GetString(n++));
  m_pgc->SetPostCommands(GetString(n++));
  return true;
}

void MenuPropDlg::CreateButtonPane(wxSizer* sizer, bool resetButton)
{
  wxBoxSizer* buttonPane = new wxBoxSizer(wxHORIZONTAL);
  wxButton* avBt = new wxButton(this, AV_BT_ID, _("Audio/Video..."));
  buttonPane->Add(avBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  buttonPane->Add(10, 10, 1, wxEXPAND);
  wxButton* okBt = new wxButton(this, wxID_OK, _("OK"));
  okBt->SetDefault();
#if defined(__WXGTK__) && wxCHECK_VERSION(2,5,2) && !wxCHECK_VERSION(2,5,4)
  okBt->SetSizeHints(-1, okBt->GetSize().GetY()+8);
#endif
  buttonPane->Add(okBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  buttonPane->Add(8, 0);
  wxButton* cancelBt = new wxButton(this, wxID_CANCEL, _("Cancel"));
  buttonPane->Add(cancelBt, 0, wxALIGN_RIGHT|wxALIGN_CENTER_VERTICAL);
  sizer->Add(buttonPane, 0, wxEXPAND|wxLEFT|wxRIGHT|wxBOTTOM, 10);
}

void MenuPropDlg::OnAV(wxCommandEvent& event)
{
  AVPropDlg propDlg(this, m_audio, m_video, true);
  if (propDlg.ShowModal() == wxID_OK)
  {
	wxCommandEvent evt(EVT_COMMAND_DVD_CHANGED, this->GetId());
	GetEventHandler()->ProcessEvent(evt);
  }
}
