/////////////////////////////////////////////////////////////////////////////
// Name:        Config.h
// Purpose:     Configuration
// Author:      Alex Thuering
// Created:     27.03.2003
// RCS-ID:      $Id: Config.h,v 1.28 2006/10/29 15:42:23 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef DS_CONFIG_H
#define DS_CONFIG_H

#include <wx/wx.h>
#include <wx/config.h>

const wxString DEF_VERSION      = _T("");
const int DEF_LANGUAGE          = -1;
const wxString DEF_VOLUME_NAME  = wxT("DVD");
const long DEF_VIDEO_FORMAT      = 0;
const long DEF_AUDIO_FORMAT      = 0;
const wxString DEF_FILE_BROWSER_DIR = _T("");
const wxString DEF_GEN_TEMP_DIR = wxGetHomeDir() + wxFILE_SEP_PATH + _T("dvd");
const bool DEF_REMOVE_TEMP		= true;
const wxString DEF_DEMPLEX_CMD  = _T("mpgtx -f -d \"$FILE_IN\" -b \"$FILES_OUT\"");
const int DEF_MENU_FRAME_COUNT = 1;
const int DEF_MENU_VIDEO_BITRATE = 9000;
const int DEF_SLIDESHOW_VIDEO_BITRATE = 9000;
const wxString DEF_JPEG2MPEG_CMD = _T("jpeg2yuv -n $FRAMES -I t -L 1 -f $FRAME_RATE -j '$FILE_IN' | mpeg2enc -f 8 -b $BITRATE -o '$FILE_OUT' $VIDEO_NORM");
#ifdef __WXMSW__
  const wxString DEF_MPLEX_CMD     = _T("mplex -f 8 -S 0 -M -V -o \"$FILE_OUT\" \"$FILE_VIDEO\" \"$FILE_AUDIO\"");
  const wxString DEF_SPUMUX_CMD    = _T("spumux '$FILE_CONF'");
  const wxString DEF_SILENCE_CMD   = _T("sox -t nul -s -w -c 2 -r 48000 \"$FILE_IN\" -t wav - trim 0 $DURATION | mp2enc -b 128 -o $FILE_OUT");
  const wxString DEF_DVDAUTHOR_CMD = _T("dvdauthor -o '$DIR' -x '$FILE_CONF'");
  const bool DEF_PREVIEW_DO        = false;
  const wxString DEF_PREVIEW_CMD   = _T("");
  const bool DEF_GENERATE_DO       = false;
  const bool DEF_ISO_DO            = true;
  const wxString DEF_ISO_CMD       = _T("mkisofs  -V '$VOL_ID' -o '$FILE' -dvd-video '$DIR'");
  const wxString DEF_ISO_SIZE_CMD  = _T("mkisofs -q -print-size '$DIR'");
  const bool DEF_BURN_DO           = false;
  const wxString DEF_BURN_CMD      = _T(""); // _T("mkisofs -dvd-video '$DIR' | cdrecord dev=$DEV -v driveropts=burnfree fs=64m -dao tsize=$SIZEs -");
  const wxString DEF_BURN_DEVICE   = _T(""); // _T("1,0,0");
  const wxString DEF_BURN_SCAN_CMD = _T(""); // _T("cdrecord -scanbus");
  const wxString DEF_BURN_SPEED_OPT= _T(""); // _T("speed=$SPEED");
  const bool DEF_FORMAT_DO         = false;
  const wxString DEF_FORMAT_CMD    = _T(""); // _T("cdrecord dev=$DEV blank=fast");
#else
  const wxString DEF_MPLEX_CMD     = _T("mplex -f 8 -S 0 -M -V -o \"$FILE_OUT\" \"$FILE_VIDEO\" \"$FILE_AUDIO\"");
  const wxString DEF_SPUMUX_CMD    = _T("spumux \"$FILE_CONF\"");
  const wxString DEF_SILENCE_CMD   = _T("sox -t nul -s -w -c 2 -r 48000 /dev/zero -t wav - trim 0 $DURATION | mp2enc -b 128 -r 48000 -s -o $FILE_OUT");
  const wxString DEF_DVDAUTHOR_CMD = _T("dvdauthor -o \"$DIR\" -x \"$FILE_CONF\"");
  const bool DEF_PREVIEW_DO        = true;
  const wxString DEF_PREVIEW_CMD   = _T("xine \"dvd:/$DIR\"");
  const bool DEF_GENERATE_DO       = false;
  const bool DEF_ISO_DO            = false;
  const wxString DEF_ISO_CMD       = _T("mkisofs  -V \"$VOL_ID\" -o \"$FILE\" -dvd-video \"$DIR\"");
  const wxString DEF_ISO_SIZE_CMD  = _T("mkisofs -q -print-size \"$DIR\"");
  const bool DEF_BURN_DO           = true;
  const wxString DEF_BURN_CMD      = _T("growisofs  -V \"$VOL_ID\" -dvd-compat -Z $DEV -dvd-video \"$DIR\" $SPEEDSTR");
  const wxString DEF_BURN_DEVICE   = _T("/dev/dvd");
  const wxString DEF_BURN_SCAN_CMD = _T("");
  const wxString DEF_BURN_SPEED_OPT= _T("-speed=$SPEED");
  const bool DEF_FORMAT_DO         = false;
  const wxString DEF_FORMAT_CMD    = _T("dvd+rw-format -force $DEV");
#endif
const wxString DEF_ISO_SAVETO = wxGetHomeDir() + wxFILE_SEP_PATH + _T("dvd.iso");
const int DEF_BURN_SPEED      = 0;

#define CONFIG_PROP(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, wxString, wxString)

#define CONFIG_PROP_BOOL(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, bool, long)

#define CONFIG_PROP_INT(name, cfgName, defName)\
  CONFIG_PROP_T(name, cfgName, defName, int, long)

#define CONFIG_PROP_T(name, cfgName, defName, cfgType, cfgType2)\
  cfgType Get##name(bool def = false)\
  { return def ? (cfgType2) defName : cfg->Read(cfgName, (cfgType2) defName); }\
  void Set##name(cfgType value)\
  {\
    wxLogNull log;\
    if (value == defName) cfg->DeleteEntry(cfgName);\
    else cfg->Write(cfgName, value);\
  }

class Config
{
  public:
    void Init() { cfg = wxConfig::Get(); }
    bool Flush() { return cfg->Flush(); }
    bool DeleteAll() { return cfg->DeleteAll(); }
    bool DeleteGroup(wxString group) { return cfg->DeleteGroup(group); }
    
    wxRect GetMainWinLocation();
    void SetMainWinLocation(wxRect rect);
	
	CONFIG_PROP(Version,  _T("Version"), DEF_VERSION)
	CONFIG_PROP_INT(Language, _T("Interface/Language"), DEF_LANGUAGE)
    CONFIG_PROP(DefVolumeName, _T("Interface/DefVolumeName"), DEF_VOLUME_NAME)
	CONFIG_PROP_INT(DefVideoFormat, _T("Interface/DefVideoFormat"), DEF_VIDEO_FORMAT)
	CONFIG_PROP_INT(DefAudioFormat, _T("Interface/DefAudioFormat"), DEF_AUDIO_FORMAT)
	CONFIG_PROP(FileBrowserDir,  _T("Interface/FileBrowserDir"), DEF_FILE_BROWSER_DIR)
	CONFIG_PROP(TempDir, _T("Generate/TempDir"), DEF_GEN_TEMP_DIR)
	CONFIG_PROP_BOOL(RemoveTempFiles, _T("Generate/RemoveTempFiles"), DEF_REMOVE_TEMP)
	CONFIG_PROP(Jpeg2MpegCmd, _T("Generate/Jpeg2MpegCmd"), DEF_JPEG2MPEG_CMD)
    CONFIG_PROP_INT(MenuFrameCount,_T("Generate/MenuFrameCount"), DEF_MENU_FRAME_COUNT)
	CONFIG_PROP_INT(MenuVideoBitrate, _T("Generate/MenuVideoBitrate"), DEF_MENU_VIDEO_BITRATE)
    CONFIG_PROP_INT(SlideshowVideoBitrate, _T("Generate/SlideshowVideoBitrate"), DEF_SLIDESHOW_VIDEO_BITRATE)
	CONFIG_PROP(MplexCmd,   _T("Generate/MplexCmd"), DEF_MPLEX_CMD)
	CONFIG_PROP(DemplexCmd, _T("Generate/DemplexCmd"), DEF_DEMPLEX_CMD)
	CONFIG_PROP(SpumuxCmd,  _T("Generate/SpumuxCmd"), DEF_SPUMUX_CMD)
	CONFIG_PROP(SilenceCmd,  _T("Generate/SilenceCmd"), DEF_SILENCE_CMD)
	CONFIG_PROP(DvdauthorCmd, _T("Generate/DvdauthorCmd"), DEF_DVDAUTHOR_CMD)
	
	CONFIG_PROP_BOOL(PreviewDo, _T("Preview/Do"), DEF_PREVIEW_DO)
	CONFIG_PROP(PreviewCmd, _T("Preview/Cmd"), DEF_PREVIEW_CMD)
	
	CONFIG_PROP_BOOL(GenerateDo, _T("Generate/Do"), DEF_GENERATE_DO)
	
	CONFIG_PROP_BOOL(IsoDo, _T("Iso/Do"), DEF_ISO_DO)
	CONFIG_PROP(IsoCmd, _T("Iso/Cmd"), DEF_ISO_CMD)
	CONFIG_PROP(IsoSizeCmd, _T("Iso/SizeCmd"), DEF_ISO_SIZE_CMD)
	CONFIG_PROP(IsoSaveTo,  _T("Iso/SaveTo"), DEF_ISO_SAVETO)
	
	CONFIG_PROP_BOOL(BurnDo, _T("Burn/Do"), DEF_BURN_DO)
	CONFIG_PROP(BurnCmd, _T("Burn/Cmd"), DEF_BURN_CMD)
	CONFIG_PROP(BurnDevice, _T("Burn/Device"), DEF_BURN_DEVICE)
	CONFIG_PROP(BurnScanCmd, _T("Burn/ScanSmd"), DEF_BURN_SCAN_CMD)
	CONFIG_PROP(BurnSpeedOpt, _T("Burn/SpeedOpt"), DEF_BURN_SPEED_OPT)
	CONFIG_PROP_INT(BurnSpeed, _T("Burn/Speed"), DEF_BURN_SPEED)
	
	CONFIG_PROP_BOOL(FormatDo, _T("Burn/FormatDo"), DEF_FORMAT_DO)
	CONFIG_PROP(FormatCmd, _T("Burn/FormatCmd"), DEF_FORMAT_CMD)
    
  protected:
    wxConfigBase* cfg;
};

extern Config s_config;

#endif //DS_CONFIG_H
