#include <KApplication>
#include <KAboutData>
#include <KCmdLineArgs>
#include <KUrl>
#include <kross/core/action.h>
#include <kross/core/manager.h>
#include <KConfig>
#include <KConfigGroup>
#include <KService>
#include <KServiceTypeTrader>
#include <KTabWidget>
#include <QVariant>

#include "mainwindow.h"
int main(int argc, char *argv[])
{
    // About Eureka
    KAboutData aboutData( "eureka", 0,
                          ki18n( "Eureka" ), "0.5",
                          ki18n( "Web Browser" ),
                          KAboutData::License_GPL,
                          ki18n( "Copyright (c) 2008 Michael H." ) );
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineOptions options;
    options.add( "+[url]", ki18n( "Document to open" ) );
    KCmdLineArgs::addCmdLineOptions( options );

    // Setup window and KApplication.
    KApplication app;
    EurekaWindow* window = new EurekaWindow();
    window->show();
    KConfig config;
    KConfigGroup plugins( &config, "plugins" );
    KConfigGroup general( &config, "eureka" );
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    // Open the page.
    if ( args->count() ) {
        for ( int i = 0; i < args->count(); i++ )
            window->open( KUrl( args->url( i ).url() ) );
    } else {
        window->open( KUrl( general.readEntry( "homepage", "about:blank" ) ) );
    }

    // Set some configurable options.
    window->findChild<KTabWidget*>()->setTabReorderingEnabled( general.readEntry( "tabreorder", true ) );

    // Load Kross Plugins
    KService::List offers = KServiceTypeTrader::self()->
                            query( "Eureka/KrossPlugin" );
    for ( int i = 0; i < offers.size(); i++ ) {
        KService* service = offers.value( i ).data();
        QString script = service->library();
        Kross::Action action( window, script );
        action.setInterpreter( service->property( "X-KDE-Language", QVariant::String ).toString() );
        action.setFile( script );
        action.addObject( window, "eureka" );
        action.trigger();
    }

    // Start main program loop.
    return app.exec();
}

