#!/bin/sh
#
# Copyright (c) 2003 by 
# Roland Mainz <roland.mainz@informatik.med.uni-giessen.de>
# All rights reserved.
#
#ident  "@(#)startxprint.sh   0.1    2003/02/08 gisburn"
#
# (Hack-like) wrapper script to use /etc/init.d/xprint directly from a
# tarball without the need to be "root" nor to do any special installation
# steps
#
############################################################################

# Force use of a POSIX conformant sh 
# (Solaris /sbin/sh is plain Bourne shell)
[ "$1" != "posix_sh_forced" -a -x /usr/dt/bin/dtksh  ]   && exec /usr/dt/bin/dtksh  "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /bin/ksh93  ]          && exec /bin/ksh93  "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /bin/ksh  ]            && exec /bin/ksh  "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /bin/bash ]            && exec /bin/bash "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /usr/local/bin/ksh93 ] && exec /usr/local/bin/ksh93 "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /usr/local/bin/ksh ]   && exec /usr/local/bin/ksh "$0" posix_sh_forced "$@"
[ "$1" != "posix_sh_forced" -a -x /usr/local/bin/bash ]  && exec /usr/local/bin/bash "$0" posix_sh_forced "$@"
if [ "$1" != "posix_sh_forced" ] ; then
    echo "${0}: ## FATAL ERROR: No POSIX-shell found."  1>&2
    exit 1
fi


shift # Drop "posix_sh_forced"

PATH=/usr/sbin:/usr/bin:/sbin:/bin
export PATH

fatal_error()
{
    echo "${this_script}: ## FATAL ERROR: ${1}" 1>&2
    exit 1
}

relpath2abspath()
{
    (
      dirpart="`dirname "${1}"`"
      basepart="`basename "${1}"`"
    
      echo "`cd "${dirpart}" ; pwd`/${basepart}"
    )
    return 0
}

##### main
this_script="$(relpath2abspath "${0}")"
unpackdir="$(dirname "${this_script}")/install"
if [ -d ${unpackdir}/usr/X11R6/etc/rc.d ]; then
xinitdir="usr/X11R6/etc/rc.d"
else
xinitdir="etc/init.d"
fi

## prechecks
[ ! -d "${unpackdir}/usr"               ] && fatal_error "${unpackdir}/usr not found"
[ ! -r "${unpackdir}/${xinitdir}/xprint" ] && fatal_error "${unpackdir}/${xinitdir}/xprint not found"

xprt_path="$(find "${unpackdir}" -name Xprt -print)"
xplsprinters_path="$(find "${unpackdir}" -name xplsprinters -print)"
psdefault_path="$(find "${unpackdir}" -name PSdefault -print)"
xf86encodingsdir_path="$(find "${unpackdir}" -name encodings.dir -print)"

[ "${psdefault_path}"         = "" ] && fatal_error "no PSdefault model found in ${unpackdir}"
[ "${xprt_path}"              = "" ] && fatal_error "no Xprt binary found in ${unpackdir}"
[ "${xplsprinters_path}"      = "" ] && fatal_error "no xplsprinters binary found in ${unpackdir}"
[ ! -r "${psdefault_path}"         ] && fatal_error "PSdefault model \"${psdefault_path}\" found in ${unpackdir} not accessible"
[ ! -x "${xprt_path}"              ] && fatal_error "Xprt binary \"${xprt_path}\" found in ${unpackdir} not accessible/executable"

xpconfig_dir="${psdefault_path%*/C/print/models/PSdefault}"

# run the "/etc/init.d/xprint start" using the binaries/config files/scripts in the tarball
ETC_INITD_XPRINT_XPRT_PATH="${xprt_path}"
ETC_INITD_XPRINT_XPLSPRINTERS_PATH="${xplsprinters_path}"
ETC_INITD_XPRINT_XPCONFIGDIR="${xpconfig_dir}"
ETC_INITD_XPRINT_XF86ENCODINGSDIR="${xf86encodingsdir_path}"
export ETC_INITD_XPRINT_XPRT_PATH ETC_INITD_XPRINT_XPCONFIGDIR ETC_INITD_XPRINT_XPLSPRINTERS_PATH ETC_INITD_XPRINT_XF86ENCODINGSDIR
/bin/sh "${unpackdir}/${xinitdir}/xprint" "$@"

# EOF.
