# webminlog-lib.pl

do '../web-lib.pl';
&init_config();

sub parse_logline
{
if ($_[0] =~ /^(\d+)\.(\S+)\s+\[.*\]\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+"([^"]+)"\s+"([^"]+)"\s+"([^"]+)"(.*)/ ||
    $_[0] =~ /^(\d+)\.(\S+)\s+\[.*\]\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)(.*)/) {
	local $rv = { 'time' => $1, 'id' => "$1.$2",
		      'user' => $3, 'sid' => $4,
		      'ip' => $5, 'module' => $6,
		      'script' => $7, 'action' => $8,
		      'type' => $9, 'object' => $10 };
	local %param;
	local $p = $11;
	while($p =~ /^\s*([^=\s]+)='([^']*)'(.*)$/) {
		if (defined($param{$1})) {
			$param{$1} .= "\0".$2;
			}
		else {
			$param{$1} = $2;
			}
		$p = $3;
		}
	foreach $k (keys %param) {
		$param{$k} =~ s/%(..)/pack("c",hex($1))/ge;
		}
	$rv->{'param'} = \%param;
	return $rv;
	}
else {
	return undef;
	}
}

# list_diffs(&action)
sub list_diffs
{
local $i = 0;
local @rv;
while(open(DIFF, "$ENV{'WEBMIN_VAR'}/diffs/$act->{'id'}.$i")) {
        local ($type, $object, $diff);
        local $line = <DIFF>;
        while(<DIFF>) { $diff .= $_; }
        close(DIFF);
	if ($line =~ /^(\/.*)/) {
                $type = 'modify'; $object = $1;
                }
        elsif ($line =~ /^(\S+)\s+(.*)/) {
                $type = $1; $object = $2;
                }
	push(@rv, { 'type' => $type,
		    'object' => $object,
		    'diff' => $diff } );
	$i++;
	}
return @rv;
}

1;

