#!/usr/local/bin/perl

do "../web-lib.pl";

&init_config();
%access = &get_module_acl();
$| = 1;
$cron_cmd = "$module_config_directory/sync.pl";

sub p_link
{
    my ( $dest, $text ) = @_;
    return "<a href=\"". $dest. "\">". $text. "</a>";
}

sub p_radio
{
    my ( $name, $checked, @list ) = @_;
    local ($out, $size, $i);
    $size = @list; $i = 0;

    do
    {
	$out .= " <input type=radio name=".$name." value=".$list[$i];
	$out .= " checked" if( $checked eq $list[$i++] );
	$out .="> ".$list[$i++];
    } while( $i < $size );

    return $out;
}

sub p_entry
{
    my ( $name, $value, $size ) = @_;

    $size ? return "<input name=". $name. " size=". $size." value=\"". $value."\">" : return "<input name=". $name. " value=\"". $value."\">";
}

sub p_select_wdl
{
  my ( $name, $selected, @list ) = @_;
  local $out = "<select name=$name>";
  local $i = 0;
  local $size = @list;

  do
  {
	$out .= "<option value=$list[$i++]";
	$out .= " selected" if( $selected eq $list[$i] );
	$out .= ">$list[$i++]";
  } while( $i < $size );
  $out .= "</select>";

}

sub p_select
{
  my ( $name, $selected, @list ) = @_;
  local (@newlist, $item);

  foreach $item ( @list )
  {
	push( @newlist, $item, $item );
  }

  p_select_wdl( $name, $selected, @newlist );
}

sub find_cron_job
{
&foreign_require("cron", "cron-lib.pl");
local @jobs = &cron::list_cron_jobs();
local ($job) = grep { $_->{'command'} eq $cron_cmd &&
		      $_->{'user'} eq 'root' } @jobs;
return $job;
}

# sync_time(server, hardware-too)
# Syncs the system and maybe hardware time with some server. Returns undef
# on success, or an error message on failure.
sub sync_time
{
local $ex = &system_logged("ntpdate -u ".quotemeta($_[0])." >/dev/null 2>&1");
if ($ex) {
	# error using ntp. use timeservice
	local $err;
  	&open_socket( $_[0], 37, SOCK, \$err);
	return $err if ($err);
  	read(SOCK, $rawtime, 4);
  	close(SOCK);
  	$rawtime = unpack("N", $rawtime);
  	$rawtime -= (17 * 366 + 53 * 365) * 24 * 60 * 60;
  	@tm = localtime($rawtime);
	if ($config{'seconds'} == 2) {
		$format = sprintf "%4.4d%2.2d%2.2d%2.2d%2.2d.%2.2d",
			$tm[5]+1900, $tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[0];
		}
	elsif ($config{'seconds'} == 1) {
		$format = sprintf "%2.2d%2.2d%2.2d%2.2d%4.4d.%2.2d",
			$tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[5]+1900, $tm[0];
		}
	else {
		$format = sprintf "%2.2d%2.2d%2.2d%2.2d%2.2d",
			$tm[4]+1, $tm[3], $tm[2], $tm[1], $tm[5]%100;
		}
	&system_logged("echo yes | date $format >/dev/null 2>&1");
	}
else {
	$rawtime = time();
	}

if ($_[1]) {
	# Set hardware clock time
	local @tm = localtime($rawtime);
	local $format = sprintf "%d/%d/%d %d:%d:%d",
			$tm[4]+1, $tm[3], $tm[5]+1900, $tm[2], $tm[1], $tm[0];
	local $out = &backquote_logged("hwclock --set \"--date=$format\" 2>&1");
	return $out if ($?);
	}

return undef;
}

