#!/usr/local/bin/perl
# list_trusts.cgi
# List users trusted by sendmail

require './sendmail-lib.pl';
$access{'trusts'} || &error($text{'trusts_ecannot'});
&header($text{'trusts_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
foreach $f (&find_type("F", $conf)) {
	if ($f->{'value'} =~ /^t[^\/]*(\/\S+)/
	   || $f->{'value'} =~ /^\{t\}[^\/]*(\/\S+)/) { $ctfile = $1; }
	}
if ($ctfile) {
	# get users listed in a separate file
	open(CT, $ctfile);
	while(<CT>) {
		s/\r|\n//g;
		s/#.*$//g;
		if (/\S/) { push(@tlist, $_); }
		}
	close(CT);
	}

# Add users from sendmail.cf
foreach $f (&find_type("T", $conf)) {
	push(@tlist, $f->{'value'});
	}
foreach $f (&find_type("C", $conf)) {
	if ($f->{'value'} =~ /^t\s*(.*)$/) {
		push(@tlist, split(/\s+/, $1));
		}
	}

print "<form method=post action=save_trusts.cgi enctype=multipart/form-data>\n";
print "<input type=hidden name=ctfile value=\"$ctfile\">\n";
print "<table cellpadding=5 width=100%><tr><td valign=top nowrap>\n";
print "<b>$text{'trusts_users'}</b><br>\n";
print "<textarea name=tlist rows=15 cols=30>",
	join("\n", @tlist),"</textarea><br>\n";
print "<input type=submit value=\"$text{'save'}\">\n";

print "</td><td valign=top>\n";
print $text{'trusts_desc'},"<p>\n";
print "</td></tr></table>\n";
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});


