#!/usr/local/bin/perl
# list_mailq.cgi
# Display the current mail queue

require './sendmail-lib.pl';
require './boxes-lib.pl';
&ReadParse();
$access{'mailq'} || &error($text{'mailq_ecannot'});
print "Refresh: $config{'mailq_refresh'}\r\n"
	if ($config{'mailq_refresh'});
&header($text{'mailq_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
foreach $mqueue (&mailq_dir($conf)) {
	opendir(QDIR, $mqueue);
	push(@qfiles, map { "$mqueue/$_" } grep { /^qf/ } readdir(QDIR));
	closedir(QDIR);
	}

if ($access{'qdoms'}) {
	# Filter out blocked mails
	@qfiles = grep { &can_view_qfile($qmails{$_} = &mail_from_queue($_)) }
		       @qfiles;
	}

if ($config{'mailq_sort'} == 0) {
	# Just sort by ID
	@qfiles = sort { $a =~ /\/([^\/]+)$/; local $af = $1;
			 $b =~ /\/([^\/]+)$/; local $bf = $1;
			 $af cmp $bf } @qfiles;
	}
else {
	# We need the actual mails for sorting
	local $q;
	foreach $q (@qfiles) {
		$qmails{$q} ||= &mail_from_queue($q);
		}
	if ($config{'mailq_sort'} == 1) {
		@qfiles = sort { lc(&address_parts($qmails{$a}->{'header'}->{'from'})) cmp
				 lc(&address_parts($qmails{$b}->{'header'}->{'from'})) } @qfiles;
		}
	elsif ($config{'mailq_sort'} == 2) {
		@qfiles = sort { lc(&address_parts($qmails{$a}->{'header'}->{'to'})) cmp
				 lc(&address_parts($qmails{$b}->{'header'}->{'to'})) } @qfiles;
		}
	elsif ($config{'mailq_sort'} == 3) {
		@qfiles = sort { lc($qmails{$a}->{'header'}->{'subject'}) cmp
				 lc($qmails{$b}->{'header'}->{'subject'}) } @qfiles;
		}
	elsif ($config{'mailq_sort'} == 4) {
		@qfiles = sort { lc($qmails{$a}->{'status'}) cmp
				 lc($qmails{$b}->{'status'}) } @qfiles;
		}
	elsif ($config{'mailq_sort'} == 5) {
		@qfiles = sort { $qmails{$b}->{'size'} <=>
				 $qmails{$a}->{'size'} } @qfiles;
		}
	}


if (@qfiles) {
	if (@qfiles > $config{'perpage'}) {
		# Need to show arrows
		print "<center>\n";
		$s = int($in{'start'});
		$e = $in{'start'} + $config{'perpage'} - 1;
		$e = @qfiles-1 if ($e >= @qfiles);
		if ($s) {
			printf "<a href='list_mailq.cgi?start=%d'>%s</a>\n",
			    $s - $config{'perpage'},
			    "<img src=/images/left.gif border=0 align=middle>";
			}
		print "<font size=+1>",&text('mail_pos', $s+1, $e+1,
					     scalar(@qfiles)),"</font>\n";
		if ($e < @qfiles-1) {
			printf "<a href='list_mailq.cgi?start=%d'>%s</a>\n",
			    $s + $config{'perpage'},
			    "<img src=/images/right.gif border=0 align=middle>";
			}
		print "</center>\n";
		}
	else {
		# Can show them all
		$s = 0;
		$e = @qfiles - 1;
		}
	print "<form action=del_mailqs.cgi method=post>\n";
	if ($config{'top_buttons'}) {
		if ($access{'mailq'} == 2) {
			print "<input type=submit value='$text{'mailq_delete'}'>\n";
			print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
			}
		print "<a href='' onClick='document.forms[0].file.checked = true; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
		print "<a href='' onClick='document.forms[0].file.checked = !document.forms[0].file.checked; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = !document.forms[0].file[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;<br>\n";
		}
	print "<table border width=100%>\n";
	print "<tr $tb> ";
	if ($access{'mailq'} == 2) {
		print "<td><br></td> ";
		}
	foreach $s (split(/,/, $config{'mailq_show'})) {
		$show{$s}++;
		}
	print "<td><b>$text{'mailq_id'}</b></td>\n";
	print "<td><b>$text{'mailq_sent'}</b></td>\n" if ($show{'Date'});
	print "<td><b>$text{'mailq_from'}</b></td>\n" if ($show{'From'});
        print "<td><b>$text{'mailq_to'}</b></td>\n" if ($show{'To'});
        print "<td><b>$text{'mailq_cc'}</b></td>\n" if ($show{'Cc'});
        print "<td><b>$text{'mailq_subject'}</b></td>\n" if ($show{'Subject'});
        print "<td><b>$text{'mailq_size'}</b></td>\n" if ($show{'Size'});
	print "<td><b>$text{'mailq_status'}</b></td>\n" if ($show{'Status'});
	print "</tr>\n";
	for($i=$s; $i<=$e; $i++) {
		$f = $qfiles[$i];
		($n = $f) =~ s/^.*\///;
		$mail = $qmails{$f} || &mail_from_queue($f);
		next if (!$mail);

		$mail->{'header'}->{'from'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'to'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'date'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'subject'} ||= $text{'mailq_unknown'};
		$mail->{'header'}->{'cc'} ||= "&nbsp;";
		$mail->{'status'} ||= $text{'mailq_sending'};

		$mail->{'header'}->{'from'} =
			&html_escape($mail->{'header'}->{'from'});
		$mail->{'header'}->{'to'} =
			&html_escape($mail->{'header'}->{'to'});
		$mail->{'header'}->{'date'} =~ s/\+.*//g;

		($d = $f) =~ s/\/qf/\/df/;
		if ($mail->{'size'} > 1000000) {
			$size = int($mail->{'size'} / 1000000)." MB";
			}
		elsif ($mail->{'size'} > 1000) {
			$size = int($mail->{'size'} / 1000)." kB";
			}
		else {
			$size = "$mail->{'size'} b";
			}
		print "<tr $cb>\n";
		if ($access{'mailq'} == 2) {
			print "<td><input type=checkbox name=file ",
			      "value=$f></td>\n";
			print "<td><a href=\"view_mailq.cgi?",
			      "file=$f\">$n</a></td>\n";
			}
		else {
			print "<td><font size=1>$n</font></td>\n";
			}
		print "<td><font size=1>$mail->{'header'}->{'date'}</font></td>\n" if ($show{'Date'});
		print "<td><font size=1>$mail->{'header'}->{'from'}</font></td>\n" if ($show{'From'});
		print "<td><font size=1>$mail->{'header'}->{'to'}</font></td>\n" if ($show{'To'});
		print "<td><font size=1>$mail->{'header'}->{'cc'}</font></td>\n" if ($show{'Cc'});
		print "<td><font size=1>$mail->{'header'}->{'subject'}</font></td>\n" if ($show{'Subject'});
		print "<td><font size=1>$size</font></td>\n" if ($show{'Size'});
		print "<td><font size=1>$mail->{'status'}</font></td>\n" if ($show{'Status'});
		print "</tr>\n";
		}
	print "</table>\n";
	print "<a href='' onClick='document.forms[0].file.checked = true; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].file.checked = !document.forms[0].file.checked; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = !document.forms[0].file[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;<p>\n";
	if ($access{'mailq'} == 2) {
		print "<input type=submit value='$text{'mailq_delete'}'>\n";
		print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
		}
	print "</form>\n";

	# Show queue search form
	print "<form action=mailq_search.cgi>\n";
	print "<b>$text{'mailq_search'}</b>\n";
	print "<select name=field>\n";
	foreach $f ('from', 'subject', 'to', 'cc', 'date', 'body', 'headers', 'size', '',
	    '!from', '!subject', '!to', '!cc', '!date', '!body', '!headers', '!size') {
		printf "<option value='%s'>%s\n", $f, $text{"match_$f"};
		}
	print "</select>\n";
	print "<input name=match size=20>\n";
	print "&nbsp;<input type=submit value='$text{'mail_ok'}'>\n";
	print "</form><p>\n";

	print "<hr>\n";
	print "<table width=100%><tr><form action=flushq.cgi>\n";
	print "<td><input type=submit value='$text{'mailq_flush'}'></td>\n";
	print "<td>$text{'mailq_flushdesc'}</td>\n";
	print "</form></tr></table>\n";
	}
else {
	print "<b>$text{'mailq_none'}</b> <p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

