#!/usr/local/bin/perl
# edit_dir.cgi
# Display information about a protected directory

require './htaccess-lib.pl';
&foreign_require($apachemod, "apache-lib.pl");
&ReadParse();
if ($in{'new'}) {
	&header($text{'dir_title1'}, "");
	}
else {
	&header($text{'dir_title2'}, "");
	@dirs = &list_directories();
	($dir) = grep { $_->[0] eq $in{'dir'} } @dirs;
	&can_access_dir($dir->[0]) || &error($text{'dir_ecannot'});
	}
print "<hr>\n";

print "<form action=save_dir.cgi>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'dir_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'dir_dir'}</b></td> <td>\n";
if ($in{'new'}) {
	printf "<input name=dir size=50 value='%s'> %s\n",
		$dir->[0], &file_chooser_button("dir", 1);
	}
else {
	print "<input type=hidden name=dir value='$in{'dir'}'>\n";
	print "<tt>$dir->[0]</tt>\n";
	}
print "</td> </tr>\n";

print "<tr> <td valign=top><b>$text{'dir_file'}</b></td> <td>\n";
if ($can_htpasswd) {
	# Allow choice of users file
	if ($in{'new'}) {
		print "<input type=radio name=auto value=1 checked> ",
		      "$text{'dir_auto'}<br>\n";
		print "<input type=radio name=auto value=0> $text{'dir_sel'}\n";
		}
	printf "<input name=file size=50 value='%s'> %s</td> </tr>\n",
		$dir->[1], &file_chooser_button("file", 0);
	}
else {
	# Always automatic
	if ($in{'new'}) {
		print "$text{'dir_auto'}</td> </tr>\n";
		}
	else {
		print "<tt>$dir->[1]</tt></td> </tr>\n";
		}
	}

if ($config{'md5'}) {
	print "<tr> <td><b>$text{'dir_crypt'}</b></td>\n";
	printf "<td><input type=radio name=crypt value=0 %s> %s\n",
		$dir->[2] ? "" : "checked", $text{'dir_crypt0'};
	printf "<input type=radio name=crypt value=1 %s> %s</td> </tr>\n",
		$dir->[2] ? "checked" : "", $text{'dir_crypt1'};
	}
else {
	print "<input type=hidden name=crypt value=0>\n";
	}

print "<tr> <td><b>$text{'dir_realm'}</b></td>\n";
if (!$in{'new'}) {
	$conf = &foreign_call($apachemod, "get_htaccess_config",
			      "$dir->[0]/$config{'htaccess'}");
	$realm = &foreign_call($apachemod, "find_directive",
			       "AuthName", $conf, 1);
	}
printf "<td><input name=realm size=40 value='%s'></td> </tr>\n",
	$realm;

print "</table></td></tr></table>\n";
if ($in{'new'}) {
	print "<input type=submit value='$text{'create'}'>\n";
	}
else {
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=submit name=delete value='$text{'delete'}'>\n";
	print "<input type=checkbox name=remove value=1> ",
	       &text('dir_remove', "<tt>$config{'htaccess'}</tt>",
				   "<tt>$config{'htpasswd'}</tt>"),"\n";
	}
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

