/* $USAGI: net.c,v 1.4 2003/10/22 06:10:48 nakam Exp $ */
/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Noriaki TAKAMIYA @USAGI
 *	Masahide NAKAMURA @USAGI
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/ip6.h>

#include <mip6.h>
#include <mip6nl.h>
#include "miping6.h"

#ifndef IPV6_TLV_HAO
#define IPV6_TLV_HAO 201
#endif

extern struct opt_parms opt_parms;

static void padN(unsigned char *buf, unsigned char *len)
{
	unsigned char padlen = *len % 8;
	*buf = 1;
	*(buf+1) = padlen - 2;
	memset(buf+2, 0, padlen - 2);
	*len = *len + padlen;
}

static int make_dsto(char *buf, int *offset, struct in6_addr *hoa)
{
	void *extbuf;
	socklen_t extlen;
	int currentlen;
	void *databuf;
	int currentoffset;

	/* Estimate the length */
	currentlen = inet6_opt_init(NULL, 0);
	if (currentlen == -1) {
		perror("inet6_opt_init");
		goto fin;
	}
	currentlen = inet6_opt_append(NULL, 0, currentlen, IPV6_TLV_HAO,
				      16, 8, NULL);
	if (currentlen == -1) {
		perror("inet6_opt_append");
		goto fin;
	}
	currentlen = inet6_opt_finish(NULL, 0, currentlen);
	if (currentlen == -1) {
		perror("inet6_opt_finish");
		goto fin;
	}
	extlen = currentlen;

	extbuf = buf + *offset;
	*offset += extlen;

	currentlen = inet6_opt_init(extbuf, extlen);
	if (currentlen == -1) {
		perror("inet6_opt_init");
		goto fin;
	}

	currentlen = inet6_opt_append(extbuf, extlen, currentlen,
				      IPV6_TLV_HAO, 16, 8, &databuf);
	if (currentlen == -1) {
		perror("inet6_opt_append");
		goto fin;
	}
	/* Insert home address */
	currentoffset = 0;
	currentoffset = inet6_opt_set_val(databuf, currentoffset, hoa, sizeof(*hoa));

	currentlen = inet6_opt_finish(extbuf, extlen, currentlen);
	if (currentlen == -1) {
		perror("inet6_opt_finish");
		goto fin;
	}
	/* extbuf and extlen are now completely formatted */

 fin:
	return currentlen;
}

static int make_mh(char *buf, int *offset, const struct in6_addr *hoa)
{
	struct mip6_mh_hdr *mh;

	mh = (struct mip6_mh_hdr *)(buf + *offset);
	mh->nexthdr = 59; /* NEXTHDR_NONE */
	mh->type = opt_parms.mh_type;

	*offset += sizeof(struct mip6_mh_hdr);

	switch(mh->type) {
	case MIP6_MH_BRR:
		goto not_supported;

	case MIP6_MH_HOTI:
	case MIP6_MH_COTI:
	{
		struct mip6_mh_test_init *ti;

		ti = (struct mip6_mh_test_init *)(buf + *offset);
		memset(ti, 0, sizeof(*ti));

		memcpy(ti->cookie + 4, &opt_parms.cookie, sizeof(opt_parms.cookie));

		mh->hdrlen = sizeof(*mh) + sizeof(*ti);
		mh->hdrlen = (mh->hdrlen >> 3) - 1;

		*offset += sizeof(*ti);

		return 1;
	}
	case MIP6_MH_HOT:
	case MIP6_MH_COT:
		goto not_supported;

	case MIP6_MH_BU:
	{
		struct mip6_mh_bu *bu;

		bu = (struct mip6_mh_bu *)(buf + *offset);
		memset(bu, 0, sizeof(*bu));
		bu->flags = opt_parms.bu_flags;
		bu->seq = htons(opt_parms.seq);
		bu->lifetime = htons(opt_parms.lifetime);
		mh->hdrlen = sizeof(*mh) + sizeof(*bu);
		if (mh->hdrlen % 8) {
			/* padding */
			padN(buf+mh->hdrlen, &(mh->hdrlen));
		}

		*offset = mh->hdrlen;

		mh->hdrlen = (mh->hdrlen >> 3) - 1;

		return 1;
	}

	case MIP6_MH_BA:
	{
		struct mip6_mh_ba *ba;
		ba = (struct mip6_mh_ba *)(buf + *offset);

		memset(ba, 0, sizeof(*ba));
		ba->status = opt_parms.status;
		ba->flags = opt_parms.ba_flags;
		ba->seq = htons(opt_parms.seq);
		ba->lifetime = htons(opt_parms.lifetime);
		mh->hdrlen = sizeof(*mh) + sizeof(*ba);

		if (mh->hdrlen % 8) {
			/* padding */
			padN(buf+mh->hdrlen, &(mh->hdrlen));
		}
		*offset = mh->hdrlen;

		mh->hdrlen = (mh->hdrlen >> 3) - 1;

		return 1;
	}
		
	case MIP6_MH_BE:
	{
		struct mip6_mh_be *be;
		be = (struct mip6_mh_be *)(buf + *offset);
		memset(be, 0, sizeof(*be));
		be->status = opt_parms.status;
		if (hoa)
			memcpy(&be->hoa, hoa, sizeof(be->hoa));

		mh->hdrlen = sizeof(*mh) + sizeof(*be);
		mh->hdrlen = (mh->hdrlen >> 3) - 1;

		*offset += sizeof(*be);

		return 1;
	}
	default:
		__eprintf("unrecognized type: %s\n", opt_parms.mh_type_name);
		goto error;
	}

	return 0; /* maybe no case reaches here */

 error:
	return -1;

 not_supported:
	__eprintf("not supported type: %s. sorry...\n", opt_parms.mh_type_name);
	return -2;
}

int miping6_send(void)
{
	int sock = -1;
	int proto;
	int use_dsto = !(ipv6_addr_any(&opt_parms.dsto_addr));
	int cksum_offset;
	int buf_offset = 0;
	int buf_len = 0;
	unsigned char	buf[1024];
	struct msghdr	msg;
	struct iovec	iov;
	struct sockaddr_in6	daddr_sa;
	struct sockaddr_in6	saddr_sa;
	int err_code;
	int ret;

	/* Socket */
	proto = IPPROTO_MOBILITY;

	sock = socket(PF_INET6, SOCK_RAW, proto);
	if (sock < 0) {
		perror("socket");
		err_code = errno;
		goto fin;
	}

	/* Bind */
	memset(&saddr_sa, 0, sizeof(saddr_sa));
	saddr_sa.sin6_family = AF_INET6;
	saddr_sa.sin6_addr = opt_parms.saddr;

	ret = bind(sock, (struct sockaddr *)&saddr_sa, sizeof(saddr_sa));
	if (ret < 0) {
		perror("bind");
		err_code = errno;
		goto fin;
	}

	memset(buf, 0, sizeof(buf));
	memset(&msg, 0, sizeof(msg));

	memset(&daddr_sa, 0, sizeof(daddr_sa));
	daddr_sa.sin6_family = AF_INET6;
	daddr_sa.sin6_addr = opt_parms.daddr;

	msg.msg_name = (void *)&daddr_sa;
	msg.msg_namelen = sizeof(daddr_sa);
	msg.msg_iov = &iov;
	msg.msg_iovlen = 1;
	msg.msg_control = NULL;
	msg.msg_controllen = 0;

	iov.iov_base = buf;
	iov.iov_len = sizeof(buf); /* specified later */

	err_code = -1;

	/* Destination Options Header */
	if (use_dsto) {
		unsigned char	cbuf[1024];
		memset(cbuf, 0, sizeof(cbuf));

		msg.msg_control = cbuf;
		msg.msg_controllen = sizeof(cbuf); /* specified later */

		/*
		int dsto_buflen = 0;
		int dsto_offset = 0;
		struct ip6_dest *dsto = (struct ip6_dest *)cbuf;
		dsto->ip6d_nxt = IPPROTO_MOBILITY;
		dsto->ip6d_len = 2;
		dsto_offset = sizeof(*dsto);

		ret = make_dsto(cbuf, &dsto_offset, &opt_parms.dsto_addr);
		if (ret < 0)
			goto fin;
		dsto_buflen = dsto_offset;
		ret = setsockopt(sock, IPPROTO_IPV6, IPV6_DSTOPTS, dsto_buf, dsto_buflen);
		if (ret < 0) {
			perror("setsockopt");
			goto fin;
		}
		__eprintf("appended dstopt-hao:size=%d\n", dsto_buflen);
		*/
		struct cmsghdr *cmsg = (struct cmsghdr *)CMSG_FIRSTHDR(&msg);
		struct dstopt_hdr {
			struct ip6_dest	hdr;
			/* HAO */
			__u8			type;
			__u8			length;
			struct in6_addr		addr;	/* Home Address */
		} *dsto = (struct dstopt_hdr *)CMSG_DATA(cmsg);

		cmsg->cmsg_len = CMSG_LEN(sizeof(*dsto));
		cmsg->cmsg_level = IPPROTO_IPV6;
		cmsg->cmsg_type = IPV6_DSTOPTS;

		dsto->hdr.ip6d_nxt = IPPROTO_MOBILITY;
		dsto->hdr.ip6d_len = 2;
		/*dsto->type = IPV6_TLV_HAO;*/
		dsto->type = 5;
		dsto->length = 16;
		memcpy(&dsto->addr, &opt_parms.dsto_addr, sizeof(dsto->addr));

		__eprintf("appended dstopt-hao:size=%d\n", cmsg->cmsg_len);

		msg.msg_controllen = cmsg->cmsg_len;
	}

	/* Mobility Header */
	ret = make_mh(buf, &buf_offset, NULL);
	if (ret < 0)
		goto fin;

	/* Mobility Header checksum */
	/* XXX: Fix me! */
#if 0
	cksum_offset = 4;
	ret = setsockopt(sock, IPPROTO_IPV6, IPV6_CHECKSUM, &cksum_offset, 2);
	if (ret != 0) {
		perror("setsockopt");
		err_code = errno;
		goto fin;
	}
#endif

	/* Send */
	buf_len = buf_offset;
#if 0
	memset(&daddr_sa, 0, sizeof(daddr_sa));
	daddr_sa.sin6_addr = opt_parms.daddr;
	ret = sendto(sock, buf, buf_len, 0, (struct sockaddr *)&daddr_sa, sizeof(daddr_sa));
	perror("sendto");
	if (ret < 0) {
		err_code = errno;
		goto fin;
	}
	__eprintf("lengh (sent/buf) = %d/%d\n", ret, buf_len);
#endif

	iov.iov_len = buf_len;

	ret = sendmsg(sock, &msg, 0);
	perror("sendmsg");
	if (ret < 0) {
		err_code = errno;
		goto fin;
	}

	err_code = 0;

 fin:
	if (sock >= 0) {
		if (close(sock) < 0) {
			__eprintf("close");
		}
	}

	return err_code;
}
