/* $USAGI: mip6d.h,v 1.14 2003/11/13 16:17:03 nakam Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Masahide NAKAMURA @USAGI
 */
#ifndef _MIP6D_H
#define _MIP6D_H

#include <errno.h>
#include <net/if.h>
#include <netinet/icmp6.h>

#include <mip6.h>
#include <mip6log.h>

#define IPPROTO_ANY		(0)
#define DHAAD_REQ_SIZE          8

struct dhaad_req {
        unsigned char   type;
        unsigned char   code;
        unsigned short  cksum;
        unsigned short  identifier;
        unsigned short  reserved;
};
   
struct dhaad_rep {
        unsigned char   type;
        unsigned char   code;
        unsigned short  cksum;
        unsigned short  identifier;
        unsigned short  reserved;
        struct in6_addr halist[0];
};

struct mip6_msg_info {
	struct sockaddr_in6 from_addr;
	struct in6_pktinfo *pktinfo;

	int msg_type; /* flag */
	struct in6_addr dstopt_hoa;
	struct in6_addr rthdr_hoa;
};

typedef enum {
	NODE_CN,
	NODE_HA,
	NODE_MN,
} mip6_node_type_t;

struct mip6d_conf {
	mip6_node_type_t node_type;

	/* HA/MN specific */
	struct in6_addr ha_addr;

	/* HA specific */
	char home_link_dev[IFNAMSIZ + 1];
	int home_link_ifindex;
	struct in6_addr home_link_lladdr;

	/* MN specific */
	struct in6_addr hoa;
	struct in6_addr coa;
	int hoa_ifindex;
	unsigned int coa_preferred_time;
};

struct mip6d_handle {
	/* sockets */
	int	nlroute_sock;
	int	nlxfrm_sock;
	int	mh_sock;
	int	icmp_sock;

	struct mip6d_conf *conf;

	/* functions */
	int (*init)(struct mip6d_handle *handle);
	void (*fini)(struct mip6d_handle *handle);
	int (*observe)(struct mip6d_handle *handle);

#if 0
	int (*nlroute_input)(struct mip6d_handle *handle,
			     void *buf, ssize_t len);
	int (*nlxfrm_input)(struct mip6d_handle *handle,
			    void *buf, ssize_t len);
	int (*mh_input)(struct mip6d_handle *handle,
			struct mip6_msg_info *msg_info,
			struct mip6_mh_hdr *mh, ssize_t len);
#endif
	int (*icmp_input)(struct mip6d_handle *handle,
			  struct mip6_msg_info *msg_info,
			  struct icmp6_hdr *icmp, ssize_t len);
};


#if 0
extern int mip6_tunnel_update(struct mip6d_parms *mp,
			      struct in6_addr *sel_addr1, struct in6_addr *sel_addr2,
			      struct in6_addr *id_addr1, struct in6_addr *id_addr2,
			      int add);

extern int mip6_rthdr_set(struct mip6d_parms *mp, int dir,
			  struct in6_addr *daddr, struct in6_addr *saddr,
			  struct in6_addr *rtaddr,
			  __u8 proto, int add);

extern int set_anycast(struct mip6d_parms *mp, char *ifname);
#endif

#endif /* _MIP6D_H */
