/* $USAGI: mip6d.c,v 1.9 2003/11/18 07:06:25 takamiya Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Noriaki TAKAMIYA @USAGI
 *	Masahide NAKAMURA @USAGI
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#define _GNU_SOURCE
#include <getopt.h>

#include "mip6d.h"

#define CMD_NAME	"mip6d"
#define CMD_VERSION	"0.0.1"

extern int cn_register(struct mip6d_handle *handle);
extern int ha_register(struct mip6d_handle *handle);
extern int mn_register(struct mip6d_handle *handle);
extern int net_main(struct mip6d_handle *handle);

static const char opt_str[] = "t:H:A:l:";

static const struct option opt_table[] = {
	{"node-type", 1, 0, 't'},

	{"home-address", 1, 0, 'H'},
	{"home-agent-address", 1, 0, 'A'},
	{"home-link", 1, 0, 'l'},

	{"version", 0, 0, 0},
	{"help", 0, 0, 0},

	{0, 0, 0, 0}
};

static const char *opt_arg_name[] = {
	"cn,mn,ha",

	"addr",
	"addr",
	"dev",

	NULL,
	NULL,

	NULL
};

static const char *opt_desc[] = {
	"node type(default=cn)",

	"home address[mn]",
	"home agent address[mn,ha]",
	"home link interface[ha]",

	"show version",
	"show this help",

	NULL
};

struct mip6d_handle *handle;

static struct mip6d_handle handle_instance;
static struct mip6d_conf conf_instance;

static void version()
{
	printf("%s %s\n", CMD_NAME, CMD_VERSION);
}

static void help()
{
	char opt_buf[1024];
	char lopt_buf[1024];
	int i;

	version();
	printf("%s [options]\n", CMD_NAME);

	for (i = 0; ; i ++) {
		if (opt_table[i].name == 0)
			break;

		if (opt_table[i].val != 0)
			sprintf(opt_buf, "-%c,", (char)opt_table[i].val);
		else
			sprintf(opt_buf, "   ");

		if (opt_table[i].has_arg == 1)
			sprintf(lopt_buf, "--%s=<%s>",
				opt_table[i].name, opt_arg_name[i]);
		else
			sprintf(lopt_buf, "--%s", opt_table[i].name);

		printf("  %s %-*s %s\n",
			opt_buf,
			21, /* format-length for long option name */
			lopt_buf,
			opt_desc[i]);
	}
}

static void usage()
{
	printf("Try `%s --help` for more information.\n", CMD_NAME);
}

int main(int argc, char **argv)
{
	int opt;

	memset(&handle_instance, 0, sizeof(handle_instance));
	memset(&conf_instance, 0, sizeof(conf_instance));
	handle_instance.conf = &conf_instance;
	handle = &handle_instance;

	/* default values */
	handle->conf->node_type = NODE_CN;

	/* parse options */
	while (1) {
		/*int this_option_optind = optind ? optind : 1;*/
		int option_index = 0;

		opt = getopt_long(argc, argv, opt_str,
				  opt_table, &option_index);
		if (opt == -1)
			break;

		switch (opt) {
		case 0: /* option has no short one */
			if (strcmp(opt_table[option_index].name, "verion") == 0) {
				version();
				exit(0);
			} else if (strcmp(opt_table[option_index].name, "help") == 0) {
				help();
				exit(0);
			} else
				goto invalid_arg;
			break;
		case 't':
		{
			char *t = optarg;
			if (strcmp(t, "cn") == 0) {
				handle->conf->node_type = NODE_CN;
			} else if (strcmp(t, "mn") == 0) {
				handle->conf->node_type = NODE_MN;
			} else if (strcmp(t, "ha") == 0) {
				handle->conf->node_type = NODE_HA;
			} else
				goto invalid_arg;
			break;
		}
		case 'H':
			if (in6_addr_get(&handle->conf->hoa, optarg) < 0)
				goto invalid_arg;
			break;
		case 'A':
			if (in6_addr_get(&handle->conf->ha_addr, optarg) < 0)
				goto invalid_arg;
			break;
		case 'l':
			strcpy(&handle->conf->home_link_dev, optarg);
			break;
		case '?':
			break;
		default:
			goto invalid_arg;
		}
	}

	if (argc > optind) {
		printf ("invalid argments\n");
		goto invalid_arg;
	}

	{
		int ret;

		switch (handle->conf->node_type) {
		case NODE_CN:
			ret = cn_register(handle);
			break;
		case NODE_HA:
			ret = ha_register(handle);
			break;
		case NODE_MN:
			ret = mn_register(handle);
			break;
		}

		if (ret)
			exit(-ret);

		/*
		 * Initialize Binding Cache List
		 */
		mip6_bc_init();

		ret = net_main(handle);
		__dprintf("exit: %d\n", -ret);
		exit(-ret);
	}

 invalid_arg:
	usage();
	exit(EINVAL);
/*
 not_supported:
	__eprintf("currently not suppored yet.\n");
	exit(0);
*/
}
