/* $USAGI: mip6.h,v 1.7 2003/10/16 09:57:27 yoshfuji Exp $ */

/*
 * Copyright (C)2003 USAGI/WIDE Project
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*
 * Authors:
 *	Noriaki TAKAMIYA @USAGI
 *	Masahide NAKAMURA @USAGI
 *	YOSHIFUJI Hideaki @USAGI
 */
#ifndef _MIP6_H
#define _MIP6_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#include "glue.h"

/*
 * Mobility Header
 */
struct mip6_mh_hdr {
	unsigned char	nexthdr;
	unsigned char	hdrlen;
	unsigned char	type;
	unsigned char	reserved;
	unsigned short	cksum;
	unsigned char	data[0];
} __attribute__ ((__packed__));

struct mip6_mh_brr {
	unsigned short	reserved;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_test_init {
	unsigned short	reserved;
	unsigned char	cookie[8];
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_test {
	unsigned short	nonce_index;
	unsigned char	cookie[8];
	unsigned char	keygen[8];
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_bu {
	unsigned short	seq;
	unsigned char	flags;
	unsigned char	reserved;
	unsigned short	lifetime;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_ba {
	unsigned char	status;
	unsigned char	flags;
	unsigned short	seq;
	unsigned short	lifetime;
	unsigned char	opt[0];
} __attribute__ ((__packed__));

struct mip6_mh_be {
	unsigned char	status;
	unsigned char	reserved;
	struct in6_addr hoa;
} __attribute__ ((__packed__));


/*
 * Mobility Header Type
 */
#define	MIP6_MH_BRR	0
#define	MIP6_MH_HOTI	1
#define	MIP6_MH_COTI	2
#define	MIP6_MH_HOT	3
#define	MIP6_MH_COT	4
#define	MIP6_MH_BU	5
#define	MIP6_MH_BA	6
#define	MIP6_MH_BE	7

struct mip6_mh_opt {
	unsigned char	type;
	unsigned char	len;
	unsigned char	data[0];
} __attribute__ ((__packed__));

struct mip6_mh_opt_pad_1 {
	unsigned char	type;
} __attribute__ ((__packed__));

struct mip6_mh_opt_pad_n {
	unsigned char	type;
	unsigned char	len;
	unsigned char	padding[0];	/* variable length */
} __attribute__ ((__packed__));

struct mip6_mh_opt_bra {
	unsigned char	type;
	unsigned char	len;
	unsigned short	refresh_interval;
} __attribute__ ((__packed__));

struct mip6_mh_opt_alt_coa {
	unsigned char	type;
	unsigned char	len;
	struct in6_addr	alt_coa;
} __attribute__ ((__packed__));

struct mip6_mh_opt_nonce_index {
	unsigned char	type;
	unsigned char	len;
	unsigned short	home_nonce_index;
	unsigned short	careof_nonce_index;
} __attribute__ ((__packed__));

struct mip6_mh_opt_binding_auth {
	unsigned char	type;
	unsigned char	len;
	unsigned char	authdata[12];	/* XXX: variable length? */
} __attribute__ ((__packed__));


/*
 * Mobility Option Type
 */
#define	MIP6_OPT_PAD_1		0
#define	MIP6_OPT_PAD_N		1
#define	MIP6_OPT_BRA		2
#define	MIP6_OPT_ALT_COA	3
#define	MIP6_OPT_NONCE_INDEX	4
#define	MIP6_OPT_BINDING_AUTH	5


/*
 * Status in BA
           0 Binding Update accepted
           1 Accepted but prefix discovery necessary
         128 Reason unspecified
         129 Administratively prohibited
         130 Insufficient resources
         131 Home registration not supported
         132 Not home subnet
         133 Not home agent for this mobile node
         134 Duplicate Address Detection failed
         135 Sequence number out of window
         136 Expired home nonce index
         137 Expired care-of nonce index
         138 Expired nonces
         139 Registration type change disallowed
*/
#define MIP6_BA_ACCEPTED			0
#define MIP6_BA_NEED_PREFIX_DISC		1
#define MIP6_BA_UNSPEC				128
#define MIP6_BA_ADMIN				129
#define MIP6_BA_INSUFFICIENT_RESOURCE		130
#define MIP6_BA_HOME_REG_NOT_SUPPORTED		131
#define MIP6_BA_NOT_HOME_SUBNET			132
#define MIP6_BA_NOT_HOME_AGENT			133
#define MIP6_BA_DAD_FAILED			134
#define MIP6_BA_SEQ_OUT_OF_WINDOW		135
#define	MIP6_BA_EXPIRED_HOME_NONCE_INDEX	136
#define	MIP6_BA_EXPIRED_CAREOF_NONCE_INDEX	137
#define	MIP6_BA_EXPIRED_NONCE			138
#define MIP6_BA_REG_TYPE_CHANGE_DISALLOWED	139

/*
 * Status in BE
 */
#define MIP6_BE_UNKNOWN_BINDING	1
#define MIP6_BE_UNRECOGNIZED_MH	2

/*
 * Flags in BU
 */
#define	MIP6_BU_F_ACK	0x80
#define	MIP6_BU_F_HR	0x40
#define	MIP6_BU_F_LL	0x20
#define	MIP6_BU_F_KM	0x10

/*
 * Flags in BA
 */
#define MIP6_BA_F_KM	0x80

/*
 * Protocol Configuration Variables
 */
#define	DEFAULT_MAXMOBPFXADVINTERVAL		86400
#define	DEFAULT_MINDELAYBETWEENRAS		3
#define	MIN_MINDELAYBETWEENRAS			0.03
#define	DEFAULT_MINMOBPFXADVINTERVAL		600
#define	DEFAULT_INITIALBINDACKTIMEOUTFIRSTREG	1.5

/*
 * This constants are original for this implement 
 */
#define	DEFAULT_HOME_REGISTRATION		60

/*
 * Protocol Constants
 */
#define	DHAAD_RETRIES			4
#define	INITIAL_BINDACK_TIMEOUT		1
#define	INITIAL_DHAAD_TIMEOUT		3
#define	INITIAL_SOLICIT_TIMER		3
#define	MAX_BINDACK_TIMEOUT		32
#define	MAX_NONCE_LIFETIME		240
#define	MAX_TOKEN_LIFETIME		210
#define	MAX_RR_BINDING_LIFETIME		420
#define	MAX_UPDATE_RATE			3
#define	PREFIX_ADV_RETRIES		3
#define	PREFIX_ADV_TIMEOUT		3



/*
 * Binding Cache
 */
#define MIP6_BC_ENTRY_MAX 10240
/*#define MIP6_BC_HASH_SIZE 32*/
#define	MIP6_BC_HASH_SIZE	4
#define	MIP6_BUL_HASH_SIZE      32

#define	MIP6_BUL_LOOKUP	0
#define	MIP6_BUL_CREATE	1



struct mip6_bc {
	struct list_head	entry_table[MIP6_BC_HASH_SIZE];
	unsigned int entry_count;
	rwlock_t lock;
};

/*
 * Binding Cache Entry
 */
struct mip6_bc_entry {
	struct	list_head	list;

	struct in6_addr		hoa;
	struct in6_addr		coa;
	unsigned short		lifetime;
	unsigned char		flags;
	unsigned short		seq;

	/* If any, add usage information for this Binding Cache entry.
	 * This is needed to implement the cache replacement
	 * policy in use in the Binding Cache.
	 */
};

/*
 * structure of keygen information included in Home/Care-of Test
 */
struct keygen_info {
	unsigned char			keygen[8];
	unsigned short			nonce_index;
	unsigned long			recv_time;
};


#define MIP6_BUL_HASH_SIZE 32

/*
 * structure of Binding Update List
 */
struct mip6_bul {
	struct list_head	entry_table[MIP6_BUL_HASH_SIZE];
	rwlock_t lock;
};

/*
 * Binding Update List Entry
 */
struct mip6_bul_entry {
	struct	list_head		list;
	struct in6_addr			cn_addr;
	struct in6_addr			coa;
	unsigned short			init_lifetime;
	unsigned short			lifetime;
	double				retrans_timer;
	unsigned short			seq;
	unsigned long			sent_bu_time;
	unsigned char			bu_flags;
	unsigned char			state;
	unsigned char			need_bu;
	/* for Return Routability */
	unsigned long			sent_time_hoti;
	unsigned long			sent_time_coti;
	unsigned char			rr_state;	/* XXX: same as state? */
	unsigned char			home_cookie[8];
	unsigned char			careof_cookie[8];
	struct keygen_info	home_keygen_info;
	struct keygen_info	careof_keygen_info;
};


/*
 * Home Agents List
 */
#define MIP6_HAL_HASH_SIZE 32

/* XXX: home agents list must be maintained for each link */
struct mip6_hal {
	struct list_head	entry_table[MIP6_HAL_HASH_SIZE];
				/* XXX: hash is interface oriented? */
	rwlock_t lock;
};


/*
 * Prefix Information for Home Agent List
 */
struct home_link_prefix {
	struct list_head	list;
	struct in6_addr		prefix;
	unsigned char		prefixlen;
};

/*
 * Home Agents List Entry
 */
struct mip6_hal_entry {
	struct	list_head	list;

	struct in6_addr		laddr;
	struct list_head	gaddr_list;
	unsigned short		lifetime;
/*
 * The preference value is taken from the Home Agent Preference field
 * in the received Router Advertisement, if the Router Advertisement
 * contains a Home Agent Information Option, and is otherwise set to
 * the default value of 0
 */
/* XXX: I'm not sure the type below. I must check later. */
	unsigned short		preference;
};

/* RR Status */
#define	MIP6_RR_HOTI_SENT	0x01
#define	MIP6_RR_HOT_RECV	0x02
#define	MIP6_RR_COTI_SENT	0x04
#define	MIP6_RR_COT_RECV	0x08
#define	MIP6_BU_SENT		0x10
#define	MIP6_BA_RECV		0x20
#define	MIP6_DONT_BU		0x40
#define	MIP6_DONT_RR		0x80

/*
 * Sequence Number
 */
static inline int mip6_seq_chk(__u16 x, __u16 y)
{
        return (__s16)(x - y) > 0;
}

#endif
