/*
 * Headers for Dynamic Host Configuration Protocol IPv6
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright (c) International Business Machines Corp., 2002
 *
 * Author: Suresh Kodati <skodati@in.ibm.com>
 */

/* Error values....*/

/* Generic Error values 7.4.1 */
#define DHC6_SUCCESS		0
#define DHC6_UNSPECFAIL		16	/* Reason Unspecified */
#define DHC6_AUTHFAIL		17	/* Authentication failure */
#define DHC6_POORLYFORMED	18	/* Poorly formed message */
#define DHC6_UNAVAIL		19	/* Addresses Unavailable */
#define DHC6_OPTIONUNAVAIL	20	/* Requested option unavailable */


/* Server Specific Error values 7.4.2 */

#define DHC6_NOBINDING		32	/* Client record unavailable */
#define DHC6_CONFNOMATCH	33	/* Client record confirm no match IA */
#define DHC6_RENWNOMATCH	34	/* Client record renew not match IA */
#define DHC6_REBDNOMATCH	35	/* Client rebinding not matching IA */
#define DHC6_INVALIDSOURCE	36	/* Invalid Client IP address */
#define DHC6_NOPREFIXMATCH	37	/* No prefix match */

/* Configuration Variables 7.5 */

#define MIN_SOL_DELAY		1	/* sec's Min delay of first Solicit */
#define MAX_SOL_DELAY		5	/* Sec's Max delay of first Solicit*/

#define SOL_TIMEOUT		500	/* ms Seconds Initial Solicit timeout*/
#define SOL_MAX_RT		30 	/* Sec's Max Solicit timeout value*/

#define REQ_TIMEOUT 		250 	/* ms Initial Request timeout */
#define REQ_MAX_RT		30	/* sec's  Max Request timeout value */
#define REQ_MAX_RC		10	/* Max Request retry attempts */

#define CNF_TIMEOUT		250 	/* ms Initial Confirm timeout */
#define CNF_MAX_RT		1	/* sec Max Confirm timeout */
#define	CNF_MAX_RD		10 	/* sec's Max Confirm duration */

#define	REN_TIMEOUT		10 	/* sec's Initial Renew timeout */
#define REN_MAX_RT		600	/* seconds Max Renew timeout value */

#define REB_TIMEOUT		10	/* sec's Max Rebind timeout value */
#define	REB_MAX_RT		600 	/* secs  Max Rebind timeout value */

#define	INF_TIMEOUT		500 	/* ms    Initial Information-request timeout */
#define	INF_MAX_RT		30 	/* secs  Max Information-request timeout value */

#define REL_TIMEOUT		250 	/* msecs Initial Release timeout */
#define	REL_MAX_RT		1 	/* sec   Max Release timeout */
#define REL_MAX_RC		5       /* MAX Release attempts */

#define	DEC_TIMEOUT		250 	/* msecs Initial Decline timeout */
#define	DEC_MAX_RT	        1 	/* sec   Max Decline timeout */
#define DEC_MAX_RC		5	/* Max Decline attempts */


/* predefined addresses 7.1 */

#define	DHC6_ALLAGENT_ADDR	"FF02::1:2" 
#define DHC6_ALLSERVER_ADDR	"FF05::1:3"

/* UDP ports 7.2 */

#define DHC6_CLIENT_PORT	"546" 
#define	DHC6_AGENT_PORT		"547"


/* DHCPv6 Message Types 7.3 */

#define DHC6_SOLICIT		1
#define DHC6_ADVERTISE		2
#define DHC6_REQUEST		3
#define DHC6_CONFIRM		4
#define DHC6_RENEW		5
#define DHC6_REBIND		6
#define DHC6_REPLY		7
#define DHC6_RELEASE		8
#define DHC6_DECLINE		9
#define DHC6_RECONFIGINIT	10
#define DHC6_INFORMATIONREQEST	11
#define DHC6_RELAYFORW		12
#define DHC6_RELAYREPL		13 /* as is in draft  23*/



/*	Extension values not as part of draft just picked as a sequence */
#define OPTION_CLIENTID		1
#define OPTION_SERVERID		2
#define OPTION_IA		3
#define OPTION_IAADDR		4
#define OPTION_PREF		5
#define OPTION_STATUSCODE	6 /* not in draft */



/* DHCPv6 Message and formats */


struct duid_type_1{
	uint16_t identifier;
	uint16_t hw_type;
	uint32_t time_since_2000;
	struct in6_addr link_local_addr;
} __attribute__ ((packed));

struct dhc6_duid_opt {
	uint16_t option_code;
	uint16_t option_len;
	struct duid_type_1 duid;
} __attribute__ ((packed));

/* Since only type1 is implemented, only type1 	*
 * duid's are considered here 			*/
struct dhc6client_client_id {
	uint16_t option_code;
	uint16_t option_len;
	struct duid_type_1 duid;
} __attribute__ ((packed));

struct dhc6client_server_id {
	uint16_t option_code;
	uint16_t option_len;
	struct duid_type_1 duid;
} __attribute__ ((packed));

/* Draft 23 specifies doesmt say message size as 32 */
struct dhc6_status_code_option{
	uint16_t option_code;
	uint16_t option_len;
	uint16_t status;
	char message[32];
} __attribute__ ((packed));


struct dhc6_iaaddr_option {
	uint16_t option_code;
	uint16_t option_len;
	
	unsigned int T:1;
	unsigned int status_ia:7;
	uint8_t prefix_len;
	struct in6_addr addr;
	uint32_t pref_time;
	uint32_t valid_time;
} __attribute__ ((packed));
/* draft 23 standard */

struct dhc6_ia_option{
	uint16_t option_code;
	uint16_t option_len;
	uint32_t iaid;
	uint32_t T1;
	uint32_t T2;
	uint8_t status;
} __attribute__ ((packed));


struct dhc6_auth_option{
	uint16_t option_code;
	uint16_t option_len;
	uint8_t protocol;
	uint8_t algorithm;
	uint8_t rdm;
	uint64_t replay_detect;
	char *authInfo;
} __attribute__ ((packed));

struct dhc6ServerUnicastOpt{
	uint16_t option_code;
	uint16_t option_len;
	struct in6_addr address;
} __attribute__ ((packed));

struct dhc6_pref_option{
	uint16_t option_code;
	uint16_t option_len;
	uint8_t pref;
} __attribute__ ((packed));

/* Size of the extension is defined maximum possible  */
struct dhc6_msg {
	uint8_t msg_type;
	uint16_t trans_id;
	char dhc6_ext[BUFSIZ-24]; 
} __attribute__ ((packed));


/* These are not used in code */
struct dhc6_client_message_option{
	uint16_t option_code;
	uint16_t option_len;
	struct dhc6_msg;
} __attribute__ ((packed));


struct dhc6ServeMessageOpt{
	uint16_t option_code;
	uint16_t option_len;
	struct dhc6_msg;
} __attribute__ ((packed));
