#ifndef __PFKEYLIB_H
#define __PFKEYLIB_H

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <getopt.h>
#include <string.h>
#include <errno.h>
#include <stdint.h>


#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#include "freeswan.h"
#include <linux/pfkeyv2.h>
#include <linux/pfkey.h>
#include "pfkey_internal.h"


int pfkey_send_getspi(int socket, struct query_handle *query, uint32_t spimin, uint32_t spimax);

int pfkey_send_update(int socket, struct query_handle *query, uint8_t state);

int pfkey_send_dd(int socket, struct query_handle *query, uint8_t state);

int pfkey_send_delete(int socket, struct query_handle *query);

int pfkey_send_flush(int socket, struct query_handle *query);

int pfkey_send_flush_sp(int socket, struct query_handle *query);

int pfkey_send_addfow(int socket, struct query_handle *query);

int pfkey_send_delflow(int socket, struct query_handle *query);

#endif /* __PFKEYLIB_H */
