/*
 * for internal use structures
 * 
 */
#ifndef __PFKEY_INTERNAL_H
#define __PFKEY_INTERNAL_H

/* MUST_PARAMS */
#define PARAM_COMMAND   0x0001U
#define PARAM_IPSEC     0x0002U
#define PARAM_SPI       0x0004U
#define PARAM_SRC       0x0010U
#define PARAM_DST       0x0020U
#define PARAM_ALGO      0x0040U
#define PARAM_KEY       0x0080U

#define MUST_PARAMS_APPEND 0x00FFU
#define MUST_PARAMS_DELETE 0x003FU

#define MAX_AUTH_KEY_LEN 1024
#define MAX_ESP_KEY_LEN 1024


struct lifetime
{
        uint32_t allocation;
        uint64_t byte;
        uint64_t add;
        uint64_t use;
};

struct query_handle
{
        int msgtype;
        uint8_t satype;
	uint32_t seq;
        uint32_t spi;
        uint8_t replay, aalg, ealg;
        uint32_t flags;
        struct lifetime lifetime_h, lifetime_s;
        uint8_t protocol;
        struct sockaddr_storage address_s;
        uint8_t prefixlen_s;
        uint32_t port_s;
        struct sockaddr_storage address_d;
        uint8_t prefixlen_d;
        uint32_t port_d;
        uint16_t key_bits_a;
        char key_a[MAX_AUTH_KEY_LEN];
        uint16_t key_bits_e;
        char key_e[MAX_ESP_KEY_LEN];
	struct sockaddr_storage address_sad;
	uint8_t prefixlen_sad;
	uint8_t tunnel;
};

#endif /* __PFKEY_INTERNAL_H */
