/* Copyright (c) 1997, 1998 Thorsten Kukuk
   Author: Thorsten Kukuk <kukuk@vt.uni-paderborn.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#define _GNU_SOURCE

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#else
#include "lib/compat/getopt.h"
#endif
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <libintl.h>
#include <sys/stat.h>
#include <rpcsvc/nis.h>

#ifndef _
#define _(String) gettext (String)
#endif

static void
Usage (void)
{
  fputs ("Usage: nisshowcache [ -v ] [ -f file ]\n", stderr);
  fputs ("       nisshowcache --version\n", stderr);
}

int
main (int argc, char *argv[])
{
  int verbose = 0;
  const char *file = "/var/nis/NIS_SHARED_DIRCACHE";

  while (1)
    {
      int c;
      int option_index = 0;
      static struct option long_options[] =
      {
	{"version", no_argument, NULL, '\255'},
	{"verbose", no_argument, NULL, 'v'},
	{"file", required_argument, NULL, 'f'},
	{"usage", no_argument, NULL, 'u'},
	{"help", no_argument, NULL, 'h'},
	{NULL, 0, NULL, '\0'}
      };

      c = getopt_long (argc, argv, "f:vuh", long_options, &option_index);
      if (c == (-1))
	break;
      switch (c)
	{
	case 'v':
	  verbose = 1;
	  break;
	case '\255':
	  fprintf (stdout, _("nisshowcache (%s) %s\n"),
		   PACKAGE, VERSION);
	  return 0;
	case 'f':
	  file = optarg;
	  break;
	case 'u':
	case 'h':
	  Usage ();
	  return 0;
	default:
	  Usage ();
	  return 1;
	}
    }

  argc -= optind;
  argv += optind;

  if (argc > 0)
    {
      Usage ();
      return 1;
    }

  fputs ("/var/nis/NIS_SHARED_DIRCACHE support is not implemented\n", stdout);

  return 0;
}
