/* Copyright (C) 2002 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * Author:       
 *        Mitsuru KANDA  <mk@linux-ipv6.org>
 */
/* from my pop3 client code */
#include <stdio.h>
#include <unistd.h>
#include <sys/select.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "util.h"

void
trim(char *str, int strlen)
{
	int i;
	char *p = str;

	for (i=0;i<strlen;i++) {
		if ( (*p == '\r') && (*(p+1)  == '\n') ) {
			*p = '\0';
		}
		p++;
	}
}

int
tgetline(int fd, char *buf, int len , long timeout)
{
	fd_set rfds;
	struct timeval tv;
	int retval;

	tv.tv_sec = timeout;
	tv.tv_usec = 0;

	FD_ZERO(&rfds);
	FD_SET(fd, &rfds);

	retval = select(fd+1,&rfds, NULL, NULL, &tv);
	if (retval > 0) {
		return (getline(fd, buf,len));
	} else {
		if (debug) printf("select():time out [%ldsec]\n", timeout);
		return -1; /* time out */
	}
}

int 
getline(int fd, char *buf, int len)
{
	char c;    /* read char */
	int n = 0; /* read bytes */
	
	while ( (read(fd, &c, 1)) == 1 ) {
#ifdef DEBUG
		putchar(c);
#endif /* DEBUG */
		*buf++ = c;
		n++;
		/* verbosely ? */
		/*    if ( *(buf - 1) == '\n' && *(buf - 2) == '\n' ) { */
		if ( c == '\n' ) {
			buf = '\0';
			return n;
		}
		
		if (n == len -1) {
			buf = '\0';
			return n;
		}
	}
	/* error */
	buf = '\0';
	return -1;
}

int
write_pid(char *pidfile, pid_t pid)
{
	int fd;

	while (1) {
		fd = open(pidfile, O_RDWR|O_CREAT|O_EXCL, 644);
		if (fd >= 0) {
			pid = getpid();
			write(fd, &pid, sizeof(pid));
			close(fd);
			return 0;
		}
		if (errno == EEXIST) { /* file exist */
			fd = open(pidfile, O_RDONLY, 0);
			if (fd < 0) {
				if (errno == ENOENT) { /* just a timing problem. */
					continue;
				}
				break;
			}
			close(fd);
		}
		break;
	}
	return -1;
}

pid_t 
read_pid(char *pidfile)
{
	int fd;
	pid_t pid = -1;

	fd = open(pidfile, O_RDONLY, 644);
	if (fd >= 0) {
		read(fd, &pid, sizeof(pid));
	}
	close(fd);
	return pid;
}

