/* Copyright (C) 2001 SOUM Corporation. All rights reserved.
 * Modifyied by masa@soum.co.jp
 */

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip6.h>
#include <netinet/icmp6.h>
#include <unistd.h>
#include <stdio.h>
#include <err.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/sysctl.h>
#include <netdb.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <syslog.h>

#include "util.h"
#include "rtsol.h"

int
do_rtsol()
{
	int s,rtn;
	struct addrinfo hints, *res;
	int err;
	struct sockaddr_in6 in6;
	unsigned int hlim = 255;
	struct icmp6_hdr *icp;
	unsigned char outpack[sizeof(struct icmp6_hdr)];
	int clen = sizeof(struct icmp6_hdr);
	fd_set rfds;
	struct timeval tv;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_INET6;
	err = getaddrinfo("ff02::2", NULL, &hints, &res);
	if (err) {
		return -1;
	}

	memcpy(&in6, res->ai_addr, res->ai_addrlen);
	
	s = socket(AF_INET6, SOCK_RAW, IPPROTO_ICMPV6);
	if (s < 0) {
		return -1;
	}

	if ( setsockopt(s, IPPROTO_IPV6, IPV6_MULTICAST_HOPS, &hlim, sizeof(hlim)) < 0) {
		goto err;
	}
	     
	icp = (struct icmp6_hdr *)outpack;
	icp->icmp6_type = ND_ROUTER_SOLICIT;
	icp->icmp6_code = 0;
	icp->icmp6_cksum = 0 ;
	icp->icmp6_data32[0] = 0;

	rtn = sendto(s, (char *)outpack, clen, 0, (struct sockaddr *)&in6, sizeof(in6));
	if (rtn < 0) {
		goto err;
	} else if (rtn != clen) {
		goto err;
	}

	FD_ZERO(&rfds);
	FD_SET(s, &rfds);
	tv.tv_sec = 10;
	tv.tv_usec = 0;
	if (select(s+1, &rfds, NULL, NULL, &tv) > 0) {
		return 0;
	} else {
		goto err;
	}

err:
	close(s);
	return -1;
}


			
