/* Copyright (C) 2002 USAGI/WIDE Project.
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/*
 * Author: 
 *        Mitsuru KANDA  <mk@linux-ipv6.org>
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include "md5.h"
#include "chap.h"
#include "dtcp.h"
#include "util.h"


/* caller must free() challenge */
char *
chap_gen_challenge(int len)
{
	long val;
        int i;
	char p[3];
	char *cp, *challenge;

	challenge = (char *)malloc(len);
	if (!challenge)
		return NULL;

	memset(challenge, 0, len);
	cp = challenge;

        srandom(time(NULL));

        for (i=0;i<len;i++) {
                val = random();
		sprintf(p, "%02X", (unsigned char)val);
		strncpy(cp, p, strlen(p));
		cp += strlen(p);
        }

	return challenge;
}

int
chap_response(struct chap_id *pci)
{
	MD5_CTX ctx;
	unsigned char hashb[CHAP_HASH_LEN];
	unsigned char str[3];
	int i,j;

	memset(str, 0, sizeof(str));
	memset(pci->hash, 0, sizeof(pci->hash));

	MD5Init(&ctx);
	MD5Update(&ctx, pci->username, strlen(pci->username));
	MD5Update(&ctx, pci->challenge, strlen(pci->challenge));
	MD5Update(&ctx, pci->password, strlen(pci->password));
	MD5Final(hashb, &ctx);

	for (i=0,j=0; j< CHAP_HASH_LEN;i=i+2, j++) {
		snprintf(str, 3, "%02X", hashb[j]);
		memcpy(&pci->hash[i], str, 2);
	}

	return 0;
}

/* XXX strtok() */
char *
get_chap_challenge(int sockfd)
{
	char recvbuf[BUFSIZ];
	char *p;
	char *challenge;
	
	if (getline(sockfd, recvbuf, sizeof(recvbuf)) < 0)
		return NULL;
	
	p = strtok(recvbuf, " \t");
	if (p) {
		if (do_rcvchk(p) != DTCP_OK) {
			syslog(LOG_ERR, "can't get challenge, server returns ERR");
			return NULL;
		}
	} else {
		return NULL;
	}
	
	p = strtok(NULL, " \t");
	if (p) {
		challenge = p;
	} else {
		return NULL;
	}
	
	p = strtok(NULL, "\r\n"); /* server info */
	if (p) {
		syslog(LOG_INFO, "server info: %s\n", p);
	}
	
	return strdup(challenge);
}
