dnl ==========================================================================
dnl Copyright (C) 2000 USAGI/WIDE Project.
dnl All rights reserved.
dnl 
dnl Redistribution and use in source and binary forms, with or without
dnl modification, are permitted provided that the following conditions
dnl are met:
dnl 1. Redistributions of source code must retain the above copyright
dnl    notice, this list of conditions and the following disclaimer.
dnl 2. Redistributions in binary form must reproduce the above copyright
dnl    notice, this list of conditions and the following disclaimer in the
dnl    documentation and/or other materials provided with the distribution.
dnl 3. Neither the name of the project nor the names of its contributors
dnl    may be used to endorse or promote products derived from this software
dnl    without specific prior written permission.
dnl 
dnl THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
dnl ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
dnl IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
dnl ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
dnl FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
dnl DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
dnl OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
dnl HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
dnl LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
dnl OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
dnl SUCH DAMAGE.
dnl ==========================================================================
dnl ***********************************************
dnl IN6_* - Basic check for IPv6 / Basic Socket API
dnl ***********************************************
dnl ====================================================
dnl IN6_GUESS_STACK(ipv6,ipv6libdir,ipv6lib,CFLAGS,LIBS)
dnl ====================================================
AC_DEFUN(IN6_GUESS_STACK,[
	inet6_ipv6libdir=
	inet6_ipv6lib="none"
	inet6_ipv6type="unknown"
	AC_MSG_CHECKING([IPv6 stack type])
	for inet6_i in inria kame usagi linux linux_inet6 toshiba v6d zeta solaris7; do
		case ${inet6_i} in
		inria)	
			dnl http://www.kame.net/
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_cflags_${inet6_i}=
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <netinet/in.h>
#ifdef IPV6_INRIA_VERSION
%%%yes%%%
#endif],
				[if test "$inet6_ipv6type" = "unknown"; then
					inet6_ipv6type=${inet6_i}
				fi])
			;;
		kame)	
			dnl http://www.kame.net/
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_ipv6lib_${inet6_i}=inet6
			eval inet6_ipv6libdir_${inet6_i}=/usr/local/v6/lib
			eval inet6_cflags_${inet6_i}=
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <netinet/in.h>
#ifdef __KAME__
%%%yes%%%
#endif],
			[if test "$inet6_ipv6type" = "unknown"; then
				inet6_ipv6type=${inet6_i}
			fi])
			;;
		usagi)
			dnl http://www.linux-ipv6.org/
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_cflags_${inet6_i}=
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <netinet/in.h>
#ifdef __USAGI__
%%%yes%%%
#endif],
			[if test -f /usr/local/v6/lib/libinet6.a; then
				eval inet6_ipv6lib_${inet6_i}=inet6
				eval inet6_ipv6libdir_${inet6_i}=/usr/local/v6/lib
			fi
			if test "$inet6_ipv6type" = "unknown"; then
				inet6_ipv6type=${inet6_i}
			fi])
			;;
		linux)	
			dnl http://www.v6.linux.or.jp/
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_cflags_${inet6_i}=
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <features.h>
#if defined(__GLIBC__) && ((__GLIBC__ == 2 && __GLIBC_MINOR__ >= 1) || (__GLIBC__ > 2))
%%%yes%%%
#endif],
			[if test "$inet6_ipv6type" = "unknown"; then
				inet6_ipv6type=${inet6_i}
			fi])
			;;
		linux_inet6)
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_ipv6lib_${inet6_i}=inet6
			eval inet6_ipv6libdir_${inet6_i}=/usr/inet6/lib
			eval inet6_cflags_${inet6_i}=-I/usr/inet6/include
			dnl http://www.v6.linux.or.jp/
			if test -d /usr/inet6; then
				if test "$inet6_ipv6type" = "unknown"; then
					inet6_ipv6type=${inet6_i}
				fi
			fi
			;;
		toshiba)
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_ipv6lib_${inet6_i}=inet6
			eval inet6_ipv6libdir_${inet6_i}=/usr/local/v6/lib
			eval inet6_cflags_${inet6_i}=
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <sys/param.h>
#ifdef _TOSHIBA_INET6
%%%yes%%%
#endif],
				[if test "$inet6_ipv6type" = "unknown"; then
					inet6_ipv6type=${inet6_i}
				fi])
			;;
		v6d)
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_ipv6lib_${inet6_i}=v6
			eval inet6_cflags_${inet6_i}=-I/usr/local/v6/include
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include </usr/local/v6/include/sys/v6config.h>
#ifdef __V6D__
%%%yes%%%
#endif],
				[if test "$inet6_ipv6type" = "unknown"; then
					inet6_ipv6type=${inet6_i}
				fi])
			;;
		zeta)	
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_ipv6lib_${inet6_i}=${inet6_i}
			eval inet6_ipv6libdir_${inet6_i}=/usr/local/v6/lib
			eval inet6_cflags_${inet6_i}=-I/usr/local/v6/include
			AC_EGREP_CPP(%%%yes%%%, [dnl
#include <sys/param.h>
#ifdef _ZETA_MINAMI_INET6
yes
#endif],
				[if test "$inet6_ipv6type" = "unknown"; then
					inet6_ipv6type=${inet6_i}
				fi])
			;;
		solaris7)
			eval inet6_ipv6_${inet6_i}=${inet6_i}
			eval inet6_cflags_${inet6_i}=
			case "$host" in
			*-*-solaris*)
				if test -c /devices/pseudo/ip6@0:ip6; then
					if test "$inet6_ipv6type" = "unknown"; then
						inet6_ipv6type=${inet6_i}
					fi
				fi
			esac
			;;
		*)
			echo "$inet6_ipv6 is unknown"
			;;
		esac
	done
	eval inet6_ipv6=\$$1
	if test "$inet6_ipv6" = "yes"; then
		AC_MSG_RESULT([$inet6_ipv6type (guessed)])
	elif test "$inet6_ipv6" = "$inet6_ipv6type"; then
		AC_MSG_RESULT([$inet6_ipv6])
	else
		AC_MSG_RESULT([$inet6_ipv6, while $inet6_ipv6type is guessed])
		inet6_ipv6type=$inet6_ipv6
	fi
	if test "$inet6_ipv6type" != "unknown"; then
		eval inet6_ipv6lib=\$inet6_ipv6lib_${inet6_ipv6type}
		eval inet6_ipv6libdir=\$inet6_ipv6libdir_${inet6_ipv6type}
		eval inet6_ipv6cflags=\$inet6_cflags_${inet6_ipv6type}
		if test "X$inet6_ipv6cflags" != "X" -o "X$inet6_ipv6cflags" = "Xnone"; then
			INET6_CFLAGS="-DINET6 $inet6_ipv6cflags"
		fi
	fi
	if test "X$inet6_ipv6lib" != "X" -a "X$inet6_ipv6lib" != "Xnone"; then
		if test "X$inet6_ipv6libdir" != "X" && test -d $inet6_ipv6libdir -a -f $inet6_ipv6libdir/lib${inet6_ipv6lib}.a; then
			INET6_LIBS="-L$inet6_ipv6libdir -l$inet6_ipv6lib"
		elif test "X$inet6_ipv6libdir" = "X" -a "X$inet6_ipv6lib" != "X"; then
			INET6_LIBS="-l$inet6_ipv6lib"
		else
			echo $ac_n "Fatal: no $inet6_ipv6lib library found""$ac_c"
			if test "X$inet6_ipv6libdir" != "X"; then
				echo $ac_n " in $inet6_ipv6libdir$ac_c"
			fi
			echo '; cannot continue.'
			echo "You need to fetch lib${inet6_ipv6lib}.a from appropriate"
			echo 'ipv6 kit and compile beforehand.'
			exit 1
		fi
	fi
	$2=$inet6_ipv6libdir
	$3=$inet6_ipv6lib
])

dnl ============================================================
dnl IN6_STRUCT_SOCKADDR_IN6_SIN6_SCOPE_ID(action-ok[,action-ng])
dnl ============================================================
AC_DEFUN(IN6_STRUCT_SOCKADDR_IN6_SIN6_SCOPE_ID,[
AC_MSG_CHECKING([whether struct sockaddr_in6 has sin6_scope_id])
AC_CACHE_VAL(in6_cv_struct_sockaddr_in6_sin6_scope_id, [
AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
],[	struct sockaddr_in6 sin6;
	int i = sin6.sin6_scope_id;
],[	in6_cv_struct_sockaddr_in6_sin6_scope_id=yes
],[	in6_cv_struct_sockaddr_in6_sin6_scope_id=no
])])
if test "$in6_cv_struct_sockaddr_in6" = "yes"; then
	AC_MSG_RESULT([yes])
	$1
else
	AC_MSG_RESULT([no])
	$2
fi
])

(
