/* $USAGI: utils.c,v 1.2 2001/05/26 12:18:53 yoshfuji Exp $ */

/*
 * Copyright (C) 2000 USAGI/WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <linux/config.h>
#include <asm/byteorder.h>
#include <linux/kernel.h>
#include <linux/in6.h>

#ifdef CONFIG_IPV6
char* in6_ntop(const struct in6_addr *in6, char *buf){
	if (!buf)
		return NULL;
	sprintf(buf,
		"%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x",
		ntohs(in6->s6_addr16[0]), ntohs(in6->s6_addr16[1]),
		ntohs(in6->s6_addr16[2]), ntohs(in6->s6_addr16[3]),
		ntohs(in6->s6_addr16[4]), ntohs(in6->s6_addr16[5]),
		ntohs(in6->s6_addr16[6]), ntohs(in6->s6_addr16[7]));
	return buf;
}
#endif

