
//****************************************************************************
//
// FILE: dbgioctl.h
//
// COPYRIGHT: 
//    This program is an unpublished work fully protected by the United
//    States copyright laws and is considered a trade secret belonging to
//    Level One Communications, Inc.  To the extent that this work may be
//    considered "published," the following notice applies " 1997 - 1999, Level
//    One Communications, Inc."  Any unauthorized use, reproduction, distribution,
//    display, modification, or disclosure of this program is strictly
//    prohibited.
//
// DESCRIPTION:
//    Debug/Diagnostic IOCTL types and definitions.  This file is shared
//    with the diagnostic applications that generate the IOCTLs.
//
//****************************************************************************

#if !defined(DBGIOCTL_H)
#define DBGIOCTL_H

//
// DAC IOCTL opcodes 
//

#define DAC_IOCTL_IO          					0x00000001
#define DAC_IOCTL_MEMORY         				0x00000002
#define DAC_IOCTL_PCI            				0x00000003
#define DAC_IOCTL_ENABLE_DIAGNOSTICS_MODE		0x00000004
#define DAC_IOCTL_DISABLE_DIAGNOSTICS_MODE	0x00000005
#define DAC_IOCTL_INFO								0x00000006
#define DAC_IOCTL_RESET_DIAGNOSTICS_MODE		0x00000007
#define DAC_IOCTL_GET_TRACE         			0x00000008

#define DAC_IOCTL_RESET_CAPTURE		 			0x00000009
#define DAC_IOCTL_ENABLE_TX						0x00000010
#define DAC_IOCTL_DISABLE_TX						0x00000011
#define DAC_IOCTL_ENABLE_RX						0x00000012
#define DAC_IOCTL_DISABLE_RX						0x00000013
#define DAC_IOCTL_ENABLE_INTERRUPTS				0x00000015
#define DAC_IOCTL_DISABLE_INTERRUPTS			0x00000016

#define DAC_IOCTL_SEND_PACKET   					0x00000019
#define DAC_IOCTL_RECEIVE_PACKET					0x00000020
#define DAC_IOCTL_GET_DIAGNOSTIC_STATISTICS  0x00000021
#define DAC_IOCTL_EXPROM                     0x00000022
#define DAC_IOCTL_POLL_DEVICE                0x00000023
#define DAC_IOCTL_SET_INFO							0x00000024
#define DAC_IOCTL_FIND_ADAPTERS					0x00000025
#define DAC_IOCTL_GET_INTERNAL_STATISTICS    0x00000026
#define DAC_IOCTL_FIND_BOARDS					0x00000027


//
// Common IOCTL header.  This header prefixes all DAC IOCTLs.
//

typedef struct DAC_IOCTL_HEADER_STR
{
   UINT32 Signature[2];      		// Diagnostics IOCTL signature
   UINT32 Opcode;          
   DAL_STATUS Status;            // return code
   UINT32 Next;            		// for use by application 
   UINT32 DeviceNext;      		// for use by the device driver
} DAC_IOCTL_HEADER, *PDAC_IOCTL_HEADER;

#define DAC_DIAGNOSTIC_SIGNATURE_0 0x4F54414A  // "JATO"
#define DAC_DIAGNOSTIC_SIGNATURE_1 0x47414944  // "DIAG" 

//
// DAC IOCTL for read/write operations.
//

typedef struct DAC_FIND_BOARDS_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   UINT16 BoardNumber;     
} DAC_FIND_BOARDS_IOCTL, *PDAC_FIND_BOARDS_IOCTL;

typedef struct DAC_READ_WRITE_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   UINT32 Offset;
   UINT32 AccessType;
   UINT32 AccessWidth;
   UINT32 Count;
   BOOLEAN IncrementOffset;
   UINT32 Value[1];     
} DAC_READ_WRITE_IOCTL, *PDAC_READ_WRITE_IOCTL;

// Read/write access types

#define DAC_READ           1
#define DAC_WRITE          2
#define DAC_READ_MULTIPLE  3
#define DAC_WRITE_MULTIPLE 4
#define DAC_ERASE		   5

// Access Widths
#define DAC_BYTE_ACCESS    1
#define DAC_WORD_ACCESS    2
#define DAC_DWORD_ACCESS   4

//
//	DAC IOCTL for sending packets.
//

#define DAC_MAXIMUM_FRAGMENTS  32

typedef struct DAC_TX_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   ELEMENT QueueElement;
   UINT32 PacketSize;
   UINT32 Iterations;
   UINT16 Flags;
   UINT16 FragmentCount;
   UINT16 FragmentLength[DAC_MAXIMUM_FRAGMENTS];
   UINT8 Data[1];
} DAC_TX_IOCTL, *PDAC_TX_IOCTL, DAC_RX_IOCTL, *PDAC_RX_IOCTL;


//
// DAC IOCTL for retrieving a block of data from the driver.  This is used
//	for retrieving trace buffers and dumping driver data structures.
//

typedef struct DAC_BUFFER_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   UINT32 BufferSize;
   UINT8 TraceBuffer[1];
} DAC_BUFFER_IOCTL, *PDAC_BUFFER_IOCTL;

//
// DAC IOCTL for retrieving driver version information.
//

#define DAC_INFO_FLAGS_CONNECTED		0x00000001
#define DAC_INFO_FLAGS_FULL_DUPLEX		0x00000002
#define DAC_INFO_FLAGS_BOOT_ROM			0x00000004
#define DAC_INFO_FLAGS_EEPROM_ROM		0x00000008
#define DAC_INFO_FLAGS_PHY_CAP_PCS		0x00000010
#define DAC_INFO_FLAGS_PHY_CAP_MII		0x00000020
#define DAC_INFO_FLAGS_PHY_CAP_GMII		0x00000040
#define DAC_INFO_FLAGS_PHY_CAP_10		0x00000080
#define DAC_INFO_FLAGS_PHY_CAP_100		0x00000100
#define DAC_INFO_FLAGS_PHY_CAP_1000		0x00000200
#define DAC_INFO_FLAGS_AUTO_NEGOTIATE	0x00000800
#define DAC_INFO_FLAGS_VLAN_MASK		0x0000f000
#define DAC_INFO_FLAGS_VLAN_ENABLED 	0x00001000
#define DAC_INFO_FLAGS_VLAN_FILTER  	0x00002000
#define DAC_INFO_FLAGS_VLAN_STRIP	  	0x00004000
#define DAC_INFO_FLAGS_VLAN_INSERT	  	0x00008000
#define DAC_INFO_FLAGS_IP_MASK			0x000f0000
#define DAC_INFO_FLAGS_IP_ENABLED	 	0x00010000
#define DAC_INFO_FLAGS_DIAG_ENABLED		0x80000000
#define DAC_INFO_FLAGS_RX_IP_CHECKSUM   0x00020000
#define DAC_INFO_FLAGS_RX_TCP_CHECKSUM  0x00040000
#define DAC_INFO_FLAGS_RX_UDP_CHECKSUM  0x00080000

#define MAX_VLAN_TAGS	16

typedef struct DBG_ADAPTER_INFO_STR
{
   UINT32   IOBase;  
   UINT32   MemoryBaseLow;
   UINT32 	MemoryBaseHigh;
   UINT16	IORange;
   UINT16   MemoryRange;
   UINT32	Flags;
   UINT32	DriverRevision;
   UINT32	SiliconRevision;
   UINT16	LinkSpeed;
   DAL_NETWORK_ADDRESS CurrentNetworkAddress;
   DAL_NETWORK_ADDRESS PermanentNetworkAddress;
   UINT8	Interrupt;
   UINT8	CurrentPhyAddress;
   UINT32	DMAThreshold;
   UINT32 	VlanRxStrip;
   UINT32 	VlanTxInsert;
   UINT32 	ValidVlanTags;
   UINT32 	ValidVlanTagValues[MAX_VLAN_TAGS];

} DBG_ADAPTER_INFO, *PDBG_ADAPTER_INFO;


typedef struct DAC_INFO_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   DBG_ADAPTER_INFO DbgAdapterInfo;
} DAC_INFO_IOCTL, *PDAC_INFO_IOCTL;


//
// IOCTL for retrieving diagnostic statistics
//
typedef struct DAC_DIAGNOSTIC_STATISTICS_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   UINT32 InterruptCount;
	UINT32 InternalStatCount;
} DAC_DIAGNOSTIC_STATISTICS_IOCTL, *PDAC_DIAGNOSTIC_STATISTICS_IOCTL;


//
// IOCTL for retrieving driver specific internal statistics
//

#define DAC_INTERNAL_STATISTIC_SIZE 29

typedef struct DAC_DIAGNOSTIC_INTERNAL_STATISTICS_IOCTL_STR
{
   DAC_IOCTL_HEADER Hdr;
   UINT32 StatisticIndex;
	UINT32 StatisticValue;
	UINT8 StatisticName[ DAC_INTERNAL_STATISTIC_SIZE ];
} DAC_DIAGNOSTIC_INTERNAL_STATISTICS_IOCTL, *PDAC_DIAGNOSTIC_INTERNAL_STATISTICS_IOCTL;

#endif // DBGIOCTL_H
