//***************************************************************************
//
//  FILE: daltypes.h
//
//  COPYRIGHT:
//      This program is an unpublished work fully protected by the United
//      States copyright laws and is considered a trade secret belonging to
//      Level One Communications, Inc.  To the extent that this work may be
//      considered "published," the following notice applies " 1997-1999, Level
//      One Communications, Inc."  Any unauthorized use, reproduction, distribution,
//      display, modification, or disclosure of this program is strictly
//      prohibited.
//
//  DESCRIPTION:
//      Common Types file for the Device Abstraction Layer
//
//****************************************************************************

#ifndef DAL_TYPES_H
#define DAL_TYPES_H

// This is needed to resolve type conflicts with the Miniport wrapper
#if defined(NOS_NDIS)
#include "ndis.h"
#define PORT UINT32
#define DATA_RATE UINT32
#if !defined(NDIS50_MINIPORT)
typedef signed long int INT32;
typedef unsigned long int UINT32;
typedef unsigned long int* PUINT32;
typedef UINT32 PORT;
typedef UINT32 DATA_RATE;
#endif

#elif (defined(NOS_CODI) || defined(NOS_WIN32))

#if !defined(INT32)
#define  INT32 INT32
typedef signed long int INT32;
#endif

#if !defined(UINT32)
#define  UINT32 UINT32
typedef unsigned long int UINT32;
#endif

#if !defined(PUINT32)
#define  PUINT32 PUINT32
typedef unsigned long int* PUINT32;
#endif

typedef UINT32 PORT;
typedef UINT32 DATA_RATE;

#endif

#if !defined(NOS_LINUX) 

#if !defined( NOS_CODI )
#define MIN(x,y)    ((x < y) ? x:y)
#endif

#if !defined(INT16)
#define  INT16 INT16
typedef signed short INT16;
#endif

#if !defined(UINT8)
#define  INT8 INT8
typedef signed char INT8;
#endif

#if !defined(UINT16)
#define  UINT16 UINT16
typedef unsigned short UINT16;
#endif

#if !defined(UINT8)
#define  UINT8 UINT8
typedef unsigned char UINT8;
#endif

#if !defined(PUINT16)
#define  PUINT16 PUINT16
typedef unsigned short* PUINT16;
#endif

#if !defined(PUINT8)
#define  PUINT8 PUINT8
typedef unsigned char* PUINT8;
#endif

#if !defined(VOID)
#define VOID VOID
typedef void VOID;
#endif

#if !defined(PVOID)
#define PVOID PVOID
typedef void* PVOID;
#endif

#if defined(NOS_CODI)
#if !defined(PCHAR)
#define PCHAR PCHAR
typedef char* PCHAR;
#endif

#if !defined(PUCHAR)
#define PUCHAR PUCHAR
typedef unsigned char* PUCHAR;
#endif

#if !defined(UCHAR)
#define UCHAR UCHAR
typedef unsigned char UCHAR;
#endif
#endif

#if !defined(BOOLEAN)
#define BOOLEAN BOOLEAN
typedef UINT8 BOOLEAN, *PBOOLEAN;
#endif

#else

typedef UINT32 PORT;
typedef UINT32 DATA_RATE;

#endif

typedef PVOID NOS_HANDLE;


// DAL functions return status codes when appropriate. The list of possible
// return codes is as follows:
typedef enum _DAL_STATUS {
   DAL_STATUS_SUCCESS,
   DAL_STATUS_FAILURE,
   DAL_STATUS_RESOURCES,
   DAL_STATUS_PENDING,
   DAL_STATUS_SWRESET_FAILED,
   DAL_STATUS_DEVICE_NOT_FOUND,
   DAL_STATUS_NOT_SUPPORTED,     
   DAL_STATUS_DIAGS_NOT_BUILT,
   DAL_STATUS_INVALID_ADAPTER,
   DAL_STATUS_INVALID_PARAMETER, 
   DAL_STATUS_MISSING_PARAMETER,
   DAL_STATUS_INVALID_COMMAND,
   DAL_STATUS_BUFFER_TOO_SMALL,
   DAL_STATUS_NO_DATA,           
   DAL_STATUS_FILE_IO_FAILED,    
   DAL_STATUS_INVALID_STATE,     
   DAL_STATUS_IOCTL_FAILED,
   DAL_STATUS_TIMEOUT
} DAL_STATUS, *PDAL_STATUS;



// Will need to be changed per compiler
#if !defined(NOS_LINUX)
	#if defined(DAL_INLINE)
		#define INLINE                  __inline
	#else
		#define INLINE
  	#endif
#else
	#define INLINE
#endif

typedef PVOID PDEV_RX_OBJECT_LIST;
typedef PVOID PNOS_RX_OBJECT_LIST;

typedef PVOID PDEV_RX_OBJECT;
typedef PVOID PNOS_RX_OBJECT;
typedef PVOID PRX_OBJECT;

typedef PVOID PTX_OBJECT_LIST;

typedef PVOID PTX_OBJECT;

#define DAL_NETWORK_ADDRESS_SIZE 6
typedef UINT8 DAL_NETWORK_ADDRESS[DAL_NETWORK_ADDRESS_SIZE];
typedef DAL_NETWORK_ADDRESS* PDAL_NETWORK_ADDRESS;

#define MINIMUM_FRAME_SIZE      60      // Assumes CRC handled by device
#define MAXIMUM_FRAME_SIZE      1514    // Assumes CRC handled by device
#define JUMBO_FRAME_SIZE        9014    // Assumes CRC handled by device

// Will need to be defined per BUS Type, maybe per NOS
typedef UINT32 PDEV_BUS_IDENTIFIER;

typedef PVOID DEV_HANDLE, *PDEV_HANDLE;

typedef PVOID DBG_HANDLE, *PDBG_HANDLE;

typedef PVOID TRACE_HANDLE, *PTRACE_HANDLE;

typedef union
{
   PUINT8 pBuffer;
   struct {
      UINT32 LowPart;
      UINT32 HighPart;
   } QuadWord;
} DAL_BUFFER, *PDAL_BUFFER;

#define DEFAULT_PAGE_SIZE 0x1000

//****************************************************************************
//
//  Queue Management Structures
//
//****************************************************************************

#if !defined(HAVE_QUEUE)
#define HAVE_QUEUE
typedef struct element_str
{
   struct element_str* Next;
   PVOID pPayload;
    // nos specific data items can go here
} ELEMENT, *PELEMENT;

typedef struct
{
   PELEMENT Head;
   PELEMENT Tail;
   UINT16 Depth;
} QUEUE, *PQUEUE;
#endif


//****************************************************************************
//
// Timer Types
//
//****************************************************************************

#define DAL_PERIODIC_TIMER       0x0
#define DAL_SINGLE_SHOT_TIMER    0x1

typedef VOID ( *PTIMER_FUNC ) ( PVOID FunctionContext);

typedef VOID ( *PTHREAD_FUNC ) (PVOID ThreadContext);

#define STAT_ID_TX_OK               0
#define STAT_ID_SINGLE_COL          1
#define STAT_ID_MULTI_COL           2
#define STAT_ID_RX_OK               3
#define STAT_ID_CRC_ERROR           4
#define STAT_ID_ALIGN_ERROR         5
#define STAT_ID_DROPPED             6
#define STAT_ID_RX_ERROR            7
#define STAT_ID_TX_ERROR            8
#define STAT_ID_LATE_COL            9
#define STAT_ID_RUNT                10
#define STAT_ID_TOO_LONG            11
#define STAT_ID_VLAN_OK             12
#define STAT_ID_VLAN_DISCARD        13
#define STAT_ID_IP_CKSUM_ERR        14
#define STAT_ID_UDP_CKSUM_ERR       15
#define STAT_ID_PKT_LENGTH_ERR      16
#define STAT_ID_TCP_CKSUM_ERR       17
#define STAT_ID_IP_NOT_V4           18
#define STAT_ID_EXCESS_COL          19
#define STAT_ID_UNICAST_OK          20
#define STAT_ID_MULTICAST_OK        21
#define STAT_ID_BROADCAST_OK        22
#define STAT_ID_PAUSE_RX            23
#define STAT_ID_PAUSE_TX            24
#define STAT_ID_CONTROL_RX          25
#define STAT_ID_DEFERED             26
#define STAT_ID_EXCESS_DEFERED      27
#define STAT_ID_CARRIER_SENSE       28

#define MAX_STAT_IDS                29
#define STAT_ID_INTERRUPTS         255 

// Receive status codes
#define DAL_RX_STATUS_OVERFLOW_ERROR   0x08000000
#define DAL_RX_STATUS_CRC_ERROR        0x10000000
#define DAL_RX_STATUS_RUNT             0x20000000
#define DAL_RX_STATUS_ALIGN            0x40000000
#define DAL_RX_STATUS_LENGTH_ERROR     0x00400000
#define DAL_RX_STATUS_LONG_FRAME       0x04000000
#define DAL_RX_STATUS_IP_CKSUM_ERROR   0x00000100
#define DAL_RX_STATUS_TCP_CKSUM_ERROR  0x00000200
#define DAL_RX_STATUS_UDP_CKSUM_ERROR  0x00000400
#define DAL_RX_STATUS_IP_HDR_PRESENT   0x00000800
#define DAL_RX_STATUS_TCP_HDR_PRESENT  0x00001000
#define DAL_RX_STATUS_UDP_HDR_PRESENT  0x00002000
#define DAL_RX_STATUS_ERROR_SEEN       0x80000000
#define DAL_RX_STATUS_VLAN_FRAME       0x00000010
#define DAL_RX_STATUS_VLAN_INDEX_MASK  0x0000000f

// IP Acceleration status codes
#define DAL_IP_ACCLERATION_TX_IP_CHECKSUM    0x00000200
#define DAL_IP_ACCLERATION_TX_TCP_CHECKSUM   0x00000400
#define DAL_IP_ACCLERATION_TX_UDP_CHECKSUM   0x00000800
#define DAL_IP_ACCLERATION_RX_IP_CHECKSUM    0x00001000
#define DAL_IP_ACCLERATION_RX_TCP_CHECKSUM   0x00002000
#define DAL_IP_ACCLERATION_RX_UDP_CHECKSUM   0x00004000

//****************************************************************************
//
// Base offsets for trace IDs.
//
//****************************************************************************

#define NOS_BASE_TRACE_ID  0x0000
#define DEV_BASE_TRACE_ID  0x4000
#define DBG_BASE_TRACE_ID  0x8000
#define EMU_BASE_TRACE_ID  0xC000

//****************************************************************************
//
// VLAN Constants and Structures
//
//****************************************************************************

#define  VLAN_TABLE_ENTRIES               16
#define  VLAN_ENTRY_IN_USE                0x80000000
#define  VLAN_ID_MASK                     0x00000fff
#define  VLAN_PRIORITY_MASK               0x0000e000
#define  VLAN_PRIORITY_SHIFT              13

#define  VLAN_FILTER_ENABLE               0x00000004
#define  VLAN_STRIP                       0x00000008
#define  VLAN_INSERT                      0x00000010

typedef struct
{
   UINT32   VLANFlags;
   UINT32   VLANTable[VLAN_TABLE_ENTRIES];
   UINT8    VLANTableCount;   
} VLAN_INFORMATION, *PVLAN_INFORMATION;

#define DAL_MAX_DEVICES  4

#endif
