/*
 * The JGenerator Software License, Version 1.0
 *
 * Copyright (c) 2000 Dmitry Skavish (skavish@usa.net). All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *    "This product includes software developed by Dmitry Skavish
 *     (skavish@usa.net, http://www.flashgap.com/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The name "The JGenerator" must not be used to endorse or promote
 *    products derived from this software without prior written permission.
 *    For written permission, please contact skavish@usa.net.
 *
 * 5. Products derived from this software may not be called "The JGenerator"
 *    nor may "The JGenerator" appear in their names without prior written
 *    permission of Dmitry Skavish.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL DMITRY SKAVISH OR THE OTHER
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <stdio.h>
#include "swflib.hxx"

int getMax( int arr[], int size ) {
    int max = -2000000000;
    int i;
    for( i=0; i<size; i++ ) {
        if( arr[i] > max ) max = arr[i];
    }
    return max;
}

int getMax( int a, int b ) {
    if( a < 0 ) a = -a;
    if( b < 0 ) b = -b;
    if( a >= b ) return a;
    return b;
}

int getMax( int a, int b, int c ) {
    if( a < 0 ) a = -a;
    if( b < 0 ) b = -b;
    if( c < 0 ) c = -c;
    if( a >= b && a >= c ) return a;
    if( b >= a && b >= c ) return b;
    return c;
}

int getMax( int a, int b, int c, int d ) {
    if( a < 0 ) a = -a;
    if( b < 0 ) b = -b;
    if( c < 0 ) c = -c;
    if( d < 0 ) d = -d;

    if( a > b ) {
        if( a > c ) {
            if( a > d ) {
                return a;
            } else {
                return d;
            }
        } else {
            if( c > d ) {
                return c;
            } else {
                return d;
            }
        }
    } else {
        if( b > c ) {
            if( b > d ) {
                return b;
            } else {
                return d;
            }
        } else {
            if( c > d ) {
                return c;
            } else {
                return d;
            }
        }
    }
}

int getMinBitsS( int v ) {
    if( v < 0 ) v = -v;
    return getMinBitsU( v )+1;
}

static int BITS_LENGTH[] = {
//  0, 1, 2, 3, 4, 5, 6, 7, 8, 9, A, B, C, D, E, F
    0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4
};

int getMinBitsU( unsigned int v ) {
    int n = 0;
    if( (v & ~0xffff) != 0 ) {
        n+=16; v >>= 16;
    }
    if( (v & ~0x00ff) != 0 ) {
        n+= 8; v >>=  8;
    }
    if( (v & ~0x000f) != 0 ) {
        n+= 4; v >>=  4;
    }
    n += BITS_LENGTH[v];
    return n;
}

void FlashBuffer::writeStringZ( char s[] ) {
    int len = strlen(s);
    ensureCapacity( pos+len+1 );
    for( int i=0; i<len; i++ ) {
        char ch = s[i];
        buf[pos++] = (byte) ch;
    }
    buf[pos] = 0;
    incPos();
}

void FlashBuffer::writeStringL( char s[] ) {
    int len = strlen(s);
    ensureCapacity( pos+len+1 );
    buf[pos++] = (byte) len;
    for( int i=0; i<len; i++ ) {
        char ch = s[i];
        buf[pos++] = (byte) ch;
    }
    setPos( pos );  // to update size
}

void FlashBuffer::writeBits( int v, int len ) {
    ensureCapacity( pos+4 );
    for(;;) {
        v = v & ((1<<len)-1);
        int l = 8-bitPos;
        int s = l-len;
        if( s >= 0 ) {
            bitBuf = (bitBuf<<len) | v;
            bitPos += len;
            return;
        } else {
            s = -s;
            int bb = (bitBuf<<l) | (v>>s);
            buf[pos] = (byte)bb;
            incPos();
            len = s;
            bitBuf = 0;
            bitPos = 0;
        }
    }
}

void FlashBuffer::write( AffineTransform& m ) {
    initBits();

    double m00 = m.getScaleX();
    double m10 = m.getShearY();
    double m01 = m.getShearX();
    double m11 = m.getScaleY();
    double m02 = m.getTranslateX();
    double m12 = m.getTranslateY();

    if( m00 != 1.0 || m11 != 1.0 ) {
        writeBit(1);
        int i_scaleX = double2fixed(m00);
        int i_scaleY = double2fixed(m11);
        int nBits = getMinBitsS( getMax(i_scaleX,i_scaleY) );
        writeBits(nBits, 5);
        writeBits(i_scaleX, nBits);
        writeBits(i_scaleY, nBits);
    } else {
        writeBit(0);
    }

    if( m10 != 0.0 || m01 != 0.0 ) {
        writeBit(1);
        int i_rotateSkew0 = double2fixed(m10);
        int i_rotateSkew1 = double2fixed(m01);
        int nBits = getMinBitsS( getMax(i_rotateSkew0,i_rotateSkew1) );
        writeBits(nBits, 5);
        writeBits(i_rotateSkew0, nBits);
        writeBits(i_rotateSkew1, nBits);
    } else {
        writeBit(0);
    }

    int i_translateX = (int) m02;
    int i_translateY = (int) m12;
    int nBits = getMinBitsS( getMax(i_translateX,i_translateY) );
    writeBits(nBits, 5);
    writeBits(i_translateX, nBits);
    writeBits(i_translateY, nBits);
    flushBits();
}

void FlashBuffer::write( Rectangle2D& r ) {
    initBits();

    int xmin = (int) r.getMinX();
    int xmax = (int) r.getMaxX();
    int ymin = (int) r.getMinY();
    int ymax = (int) r.getMaxY();

    int nBits = getMinBitsS( getMax(xmin,xmax,ymin,ymax) );
    writeBits( nBits, 5 );
    writeBits( xmin, nBits );
    writeBits( xmax, nBits );
    writeBits( ymin, nBits );
    writeBits( ymax, nBits );
    flushBits();
}

void FlashBuffer::ensureCapacity( int cap ) {
    if( cap >= capacity ) {
        int max = capacity*2;
        if( cap > max ) max = cap+10;
        if( max < 4096 ) max = 4096;
        byte* newBuf = new byte[max];
        memcpy(newBuf, buf, capacity);
        capacity = max;
        delete [] buf;
        buf = newBuf;
    }
}

FlashBuffer* FlashBuffer::getCopy() {
    byte* myBuf = new byte[capacity];
    memcpy(myBuf, buf, capacity);
    return new FlashBuffer( myBuf, capacity, pos, size );
}

void writeFlashFile( char * fft_file, FlashBuffer* font_fob )
{

    FlashBuffer* fob = new FlashBuffer(100000);
    fob->writeByte( 'F' );                          // write signature
    fob->writeByte( 'W' );
    fob->writeByte( 'S' );
    fob->writeByte( 4 );                            // write version
    fob->skip(4);                                   // skip file size
    fob->write( new Rectangle2D(0,0,550*20,450*20) );     // write file rect
    fob->writeWord( 12<<8 );                        // write frame rate
    fob->writeWord( 0 );                            // write frame number

    // write font here
    // ....
    fob->writeFOB(font_fob);

    fob->writeWord( 0 );                            // write end tag

    // write file size
    fob->writeDWordAt( fob->getSize(), 4 );

    // write fob to file
    FILE* file = fopen(fft_file, "wb" );
    int size = fwrite(fob->getBuf(), 1, fob->getSize(), file);
    if( size != fob->getSize() ) {
        fprintf(stderr, "\nError writing file\n" );
    } else {
        fclose(file);
    }
}
