#!/usr/local/bin/ruby
# $Id: test.rb,v 1.8 2004/01/22 05:47:57 tommy Exp $
#
# Copyright (C) 2003 TOMITA Masahiro
# tommy@tmtm.org
#

$ruby = "/usr/local/bin/ruby"
$mlname = "testml"
$conf = "./test.conf"

File::open($conf, "w") do |f|
  f.puts <<EOS
$var_dir = "./tml-test-#{$$}"
$etc_dir = "./tml-test-#{$$}/etc"
$ml_dir = "./tml-test-#{$$}/ml"
$deleted_dir = "./tml-test-#{$$}/deleted"
$log_file = "./tml-test-#{$$}/log"
$domain = "example.com"
$newaliases = nil
$logging = true
EOS
end

Dir::mkdir "./tml-test-#{$$}"
Dir::mkdir "./tml-test-#{$$}/ml"
Dir::mkdir "./tml-test-#{$$}/etc"
File::open("./tml-test-#{$$}/etc/lock", "w").close
File::open("./tml-test-#{$$}/etc/aliases", "w").close
Dir::mkdir "./tml-test-#{$$}/deleted"

Dir::glob("t/[0-9]*.sh").sort.each do |f|
  f2 = File::basename f
  print f2 + "."*(20-f2.length)
  $stdout.flush
  script_lang = f.split(/./)[-1] == "rb" ? $ruby : "sh"
  unless system "#{script_lang} #{f} #{$ruby} #{$conf} #{$mlname}" then
    puts "NG"
    puts "check: ./test.conf and ./tml-test-#{$$}/"
    exit 1
  end
  puts "OK"
end

system "rm -rf ./tml-test-#{$$}"
File::unlink $conf
