#!/usr/local/bin/ruby
# $Id: setup.rb,v 1.6 2004/01/14 11:14:29 tommy Exp $

$files = ["tml", "tmladmin", "tmlctl", "test.rb"]

$stdout.sync = true

loop do
  $ruby_path = nil
  ENV["PATH"].split(/:/).each do |p|
    if File.executable? "#{p}/ruby" then
      $ruby_path = "#{p}/ruby"
      break
    end
  end

  print "Ruby path [#{$ruby_path}]: "
  ans = gets.chomp.strip
  if ans != "" then
    $ruby_path = ans
  end

  unless File.executable? $ruby_path then
    puts "#{$ruby_path}: not executable"
    redo
  end
  break
end

begin
  $tml_dir = "/usr/local/tml"
  print "tml directory [#{$tml_dir}]: "
  ans = gets.chomp.strip
  if ans != "" then
    $tml_dir = ans
  end
  unless File.directory? $tml_dir then
    print "#{$tml_dir} not found. create? (y/n) "
    if gets.strip.downcase[0] == ?y then
	Dir.mkdir $tml_dir
    end
  end
rescue
  puts $!.to_s
  retry
end

load "#{$tml_dir}/tml.conf" if File.exist? "#{$tml_dir}/tml.conf"

begin
  $var_dir = "/var/spool/tml" unless $var_dir
  print "tml var directory [#{$var_dir}]: "
  ans = gets.chomp.strip
  if ans != "" then
    $var_dir = ans
  end
  unless File.directory? $var_dir then
    print "#{$var_dir} not found. create? (y/n) "
    if gets.strip.downcase[0] == ?y then
	Dir.mkdir $var_dir
    end
  end
rescue
  puts $!.to_s
  retry
end

loop do
  $domain = "" unless $domain
  print "Your domain (ex. example.com) [#{$domain}]: "
  ans = gets.chomp.strip
  if ans == "" and $domain == "" then
    redo
  end
  if ans != "" then
    if ans !~ /^[a-z0-9-]+(\.[a-z0-9-]+)+/i then
      puts "#{ans}: invalid domain"
      redo
    end
    $domain = ans
  end
  break
end

$files.each do |f|
  File.rename f, "#{f}-" unless File.exist? "#{f}-"
  File.open(f, "w") do |w|
    IO.foreach("#{f}-") do |l|
      w.puts l.gsub(%r|/usr/local/bin/ruby|, $ruby_path)
    end
  end
end

File.open("tml.conf", "w") do |f|
  f.puts <<EOS
$tml_dir = "#{$tml_dir}"
$var_dir = "#{$var_dir}"
$domain = "#{$domain}"
EOS
  if File.exist? "#{$tml_dir}/tml.conf" then
    IO.foreach("#{$tml_dir}/tml.conf") do |l|
      f.puts l if l !~ /^\$(tml_dir|var_dir|domain)\s/
    end
  end
end
