# $Id: mail.rb,v 1.4 2003/12/31 14:20:57 tommy Exp $

require "nkf"

def get_from(header)
  h = header.gsub(/\n\s+/, " ").split(/\n/)
  h.each do |hl|
    next unless hl =~ /^From:/i
    f = hl.split(/:/, 2)[1].strip
    if f =~ /<(.*)>/ then
      from = $1.strip
      return from
    end
    if f =~ /\(.*\)/ then
      f = f.gsub(/\(.*\)/, "").strip
    end
    return f
  end
  nil
end

def b64_hdecode(str)
  str.unpack('m')[0]
end

def qp_hdecode(str)
  str.gsub('_', ' ').gsub(/=([0-9A-F][0-9A-F])/o) do $1.hex.chr end
end

def mdecode_token(s)
  nkf_flag = {'iso-2022-jp' => 'J', 'euc-jp' => 'E', 'shift_jis' => 'S', 'us-ascii' => ''}
  if s !~ /\A=\?([a-z0-9_-]+)\?(Q|B)\?([^?]+)\?=\Z/io then
    s
  else
    charset, encoding, text = $1, $2, $3
    c = nkf_flag[charset.downcase]
    if c == nil then return s end
    if encoding.downcase == 'q' then s = qp_hdecode(text)
    else s = b64_hdecode(text)
    end
    NKF::nkf("-e#{c}m0", s)
  end
end

def get_subject(header)
  h = header.gsub(/\n\s+/, " ").split(/\n/)
  h.each do |hl|
    next unless hl =~ /^Subject:/i
    s = hl.split(/:/, 2)[1].strip
    return mime_header_decode(s)
  end
  nil
end

def mime_header_decode(str)
  return str.gsub(/\s+/, " ").gsub(/\?=\s+=\?/, "?==?").gsub(/=\?[a-z0-9_-]+\?(Q|B)\?[^?]+\?=/i){mdecode_token $&}
end

def mime_header_encode(str)
  if str.length <= 64 and str !~ /[\x80-\xff]/ then
    return str
  end
  w = [""]
  len = 0
  kflag = false
  str.split(//e).each do |c|
    w[-1] << c
    if c.length == 1 then	# ASCII
      len += 3 if kflag		# KANJI-OUT
      len += 1
      kflag = false
    else			# KANJI
      len += 3 unless kflag	# KANJI-IN
      len += c.length
      kflag = true
    end
    if len > 30 then
      len += 3 if kflag		# KANJI-OUT
      len = 0
      w << ""
    end
  end
  w.delete ""

  w2 = []
  w.each do |t|
    w2 << "=?iso-2022-jp?b?"+[NKF::nkf("-Ej", t)].pack("m").chomp+"?="
  end
  w2.join("\n ")
end
