#!/usr/local/bin/ruby
# $Id: install.rb,v 1.10 2004/01/15 10:07:43 tommy Exp $

$binfiles = ["tml", "tmladmin", "tmlctl"]
$libfiles = ["tml.rb", "tml.conf", "mail.rb"]
$templates = ["confirm", "welcome", "unsubscribe", "memberlist", "admin", "archive", "summary"]

load "./tml.conf"

$binfiles.each do |f|
  File::open("#{$tml_dir}/#{f}", "w") do |w|
    IO::foreach(f) do |l|
      w.puts l
    end
    w.chmod 0755
  end
end

$libfiles.each do |f|
  File::open("#{$tml_dir}/#{f}", "w") do |w|
    IO::foreach(f) do |l|
      w.puts l
    end
    w.chmod 0644
  end
end

Dir::mkdir "#{$tml_dir}/templates" unless File::directory? "#{$tml_dir}/templates"
$templates.each do |f|
  File::open("#{$tml_dir}/templates/#{f}", "w") do |w|
    IO::foreach("templates/#{f}") do |l|
      w.puts l
    end
    w.chmod 0644
  end
end

Dir::mkdir $var_dir unless File::directory? $var_dir
Dir::mkdir "#{$var_dir}/ml" unless File::directory? "#{$var_dir}/ml"
unless File::directory? "#{$var_dir}/etc"
  Dir::mkdir "#{$var_dir}/etc" 
  File::open("#{$var_dir}/etc/lock", "w").close
  File::open("#{$var_dir}/etc/aliases", "w").close
end
Dir::mkdir "#{$var_dir}/deleted" unless File::directory? "#{$var_dir}/deleted"
