<?php
/*  
 * Analysis Console for Intrusion Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000, 2001 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose: generates timing information   
 *
 */

class EventTiming
{
  var $start_time;
  var $num_events;
  var $event_log;
  var $verbose;

  function EventTiming($verbose)
  {
    $this->num_events = 0;
    $this->verbose = $verbose;
    $this->start_time = time();
    $this->Mark("Page Load");
  }


  function Mark($desc)
  {
    $this->event_log[$this->num_events++] = array ( time(), $desc );
  }

  function PrintTiming()
  {
    if ( $this->verbose > 0 )
    {
       echo "\n\n<!-- Timing Information -->\n".
            "<H3>[Loaded in ".(time()- ($this->start_time) )." seconds]</H3>\n";
    }

    if ( $this->verbose > 1 )
    {
       for ( $i = 1; $i < $this->num_events; $i++ )
          echo "<LI>".$this->event_log[$i][1]." [".
               ($this->event_log[$i][0] - ($this->event_log[$i-1][0])).
               " seconds]\n";
    } 
  }
}

?>