=begin

  rbbr/ui/gtk/windowutils.rb 

  $Author: mutoh $
  $Date: 2003/12/16 17:00:28 $

  Copyright (C) 2002 Ruby-GNOME2 Project

  Copyright (C) 2000-2002 Hiroshi Igarashi <iga@ruby-lang.org>

  This program is free software.
  You can distribute/modify this program under
  the terms of the Ruby Distribute License.

=end

module RBBR
module UI
module GTK
  module WindowUtils
    module_function

    def show_error_message(title, error)
      show_message(title, error, Gtk::MessageDialog::ERROR)
    end

    def show_warn_message(title, error)
      show_message(title, error, Gtk::MessageDialog::WARNING)
    end

    def show_message(title, error, dialog_type)
      ary = error.to_s.split(/\n/)
      if ary.size > 15
        message = ary[0...15].join("\n")
      else
        message = ary.join("\n")
      end

      dialog = Gtk::MessageDialog.new(self, 
                                      Gtk::Dialog::DESTROY_WITH_PARENT,
                                      dialog_type,
                                      Gtk::MessageDialog::BUTTONS_CLOSE,
                                      message)
      dialog.show_all
      dialog.run
      dialog.destroy
    end
  end
end;end;end
