/*
 * NETMAJ - network mahjongg -  Copyright Notice
 *     Copyright (C) 1994, 1995, 1996 Koji Suzuki (suz@kt.rim.or.jp)
 *
 *  You can redistribute it and/or modify this software under the terms 
 * of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 *  This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the author be held liable for any damages
 * arising from the use of this software.
 * See the gpl.text for more details.
 *
 *  If you would like to do something with NETMAJ that this copyright
 * prohibits (such as distributing it with a commercial product,
 * using portions of the source in some other program, etc.), please
 * contact the author (preferably via email).  Arrangements can
 * probably be worked out.
 *
 *  Koji Suzuki   : suz@kt.rim.or.jp
 */
#include "pai.h"
#include "global.h"
#include "ruledef.h"

int tonpu = 1;
int RL_NOPINTUMO = 0;
int RL_NOAKADORA = 0;
int RL_NONAKITAN = 0;
int RL_NOKANURA = 0;
int RL_NOFLY = 0;
int RL_UNDER = 0;
int RL_ATAMAHANE = 0;
int RL_77MANGAN = 0;
int RL_NOKUIKAE = 0;
int RL_NOSANCYAHO = 0;
int RL_PAO = 0;
int RLC_NONAKIAKA = 0;
int RLC_NOALLSTARS = 0;
int RLC_IPPATU = 1;
int RLC_URADORA = 1;
int RLC_AKADORA = 1;
int RLC_YAKUMAN = 2;
int RL_STARTPOINT = 25000;
uma_t uma={20, 10,-10,-20, 20,10,-10,-20, 20,10,-10,-20};

static int expand4[16] = {0,1,2,3,4,5,6,7,-8,-7,-6,-5,-4,-3,-2,-1};

static uma_set(a,b) uma_t a,b; {
	int i;
	for (i=0; i<12; i++) {
		a[i] = b[i];
	}
}

static uma_cmp(a,b) uma_t a,b; {
	int i;
	for (i=0; i<12; i++) {
		if (a[i] != b[i]) return 1;
	}
	return 0;
}

expand_rule(r1) int *r1; {
	RL_NOPINTUMO	= (*r1 & 0x00000001)?1:0;
	RL_NOAKADORA	= (*r1 & 0x00000002)?1:0;
	RL_NONAKITAN	= (*r1 & 0x00000004)?1:0;
	RL_NOKANURA	= (*r1 & 0x00000008)?1:0;
	RL_NOFLY	= (*r1 & 0x00000010)?1:0;
	RL_UNDER	= (*r1 & 0x00000020)?1:0;

	RLC_NONAKIAKA	= (*r1 & 0x00000040)?1:0;
	RLC_NOALLSTARS	= (*r1 & 0x00000080)?1:0;

	RLC_IPPATU	= (*r1 & 0x00000100)?0:1;
	RLC_URADORA	= (*r1 & 0x00000200)?0:1;
	RLC_AKADORA	= (*r1 & 0x00000400)?0:1;
	tonpu		= (*r1 & 0x00000800)?0:1;
	RLC_YAKUMAN	= expand4[(*r1 & 0x0000f000)>>12] + 2;
	RL_STARTPOINT	= (expand4[(*r1 & 0x000f0000)>>16] + 25)*1000;
	switch ((*r1 & 0x00f00000)>>20) {
	case  0: uma_set(uma,RLU_10_20); 	break;
	case  1: uma_set(uma,RLU_10_30); 	break;
	case  2: uma_set(uma,RLU_5_10); 	break;
	case  3: uma_set(uma,RLU_7_5_3); 	break;
	case  4: uma_set(uma,RLU_UNDER); 	break;
	case  5: uma_set(uma,RLU_NONE); 	break;
	}
	RL_ATAMAHANE	= (*r1 & 0x01000000)?1:0;
	RL_77MANGAN	= (*r1 & 0x02000000)?1:0;
	RL_NOKUIKAE	= (*r1 & 0x04000000)?1:0;
	RL_PAO	        = (*r1 & 0x08000000)?1:0;
	RL_NOSANCYAHO   = (*r1 & 0x10000000)?1:0;
}

pack_rule(r1) int *r1; {
	*r1 = 0;
	if (RL_NOPINTUMO)	*r1 |=  0x00000001;
	if (RL_NOAKADORA)	*r1 |=  0x00000002;
	if (RL_NONAKITAN)	*r1 |=  0x00000004;
	if (RL_NOKANURA)	*r1 |=  0x00000008;
	if (RL_NOFLY)		*r1 |=  0x00000010;
	if (RL_UNDER)		*r1 |=  0x00000020;
	if (RLC_NONAKIAKA)	*r1 |=  0x00000040;
	if (RLC_NOALLSTARS)	*r1 |=  0x00000080;
	if (!RLC_IPPATU)	*r1 |=  0x00000100;
	if (!RLC_URADORA)	*r1 |=  0x00000200;
	if (!RLC_AKADORA)	*r1 |=  0x00000400;
	if (!tonpu)		*r1 |=  0x00000800;
	*r1 |= (RLC_YAKUMAN - 2 & 0xf) << 12;
	*r1 |= ((RL_STARTPOINT/1000 - 25) & 0xf) << 16;
	if (!uma_cmp(uma,RLU_10_30)) *r1 |= 0x00100000;
	if (!uma_cmp(uma,RLU_5_10))  *r1 |= 0x00200000;
	if (!uma_cmp(uma,RLU_7_5_3)) *r1 |= 0x00300000;
	if (!uma_cmp(uma,RLU_UNDER)) *r1 |= 0x00400000;
	if (!uma_cmp(uma,RLU_NONE))  *r1 |= 0x00500000;
	if (RL_ATAMAHANE)	*r1 |=  0x01000000;
	if (RL_77MANGAN)	*r1 |=  0x02000000;
	if (RL_NOKUIKAE)	*r1 |=  0x04000000;
	if (RL_PAO)		*r1 |=  0x08000000;
	if (RL_NOSANCYAHO)	*r1 |=  0x10000000;
}

rule_init(gp) global_t *gp; {
	char buf[20];

	buf[0] = 0;
	pf_param(gp,"tonpu",&tonpu);
	pf_param(gp,"nopintumo",&RL_NOPINTUMO);
	pf_param(gp,"noakadora",&RL_NOAKADORA);
	pf_param(gp,"nonakitan",&RL_NONAKITAN);
	pf_param(gp,"nokanura",&RL_NOKANURA);
	pf_param(gp,"nofly",&RL_NOFLY);
	pf_param(gp,"under",&RL_UNDER);
	pf_param(gp,"startpoint",&RL_STARTPOINT);
	pf_param(gp,"yakuman-chip",&RLC_YAKUMAN);
	pf_param(gp,"ippatu-chip",&RLC_IPPATU);
	pf_param(gp,"uradora-chip",&RLC_URADORA);
	pf_param(gp,"akadora-chip",&RLC_AKADORA);
	pf_param(gp,"nonakiaka",&RLC_NONAKIAKA);
	pf_param(gp,"noallstars",&RLC_NOALLSTARS);
	pf_param_strn(gp,"uma",buf,20);
	if (!strcmp(buf,"none"))
		uma_set(uma,RLU_NONE);
	else if (!strcmp(buf,"5-10"))
		uma_set(uma,RLU_5_10);
	else if (!strcmp(buf,"10-20"))
		uma_set(uma,RLU_10_20);
	else if (!strcmp(buf,"10-30"))
		uma_set(uma,RLU_10_30);
	else if (!strcmp(buf,"7-5-3"))
		uma_set(uma,RLU_7_5_3);
	else if (!strcmp(buf,"under"))
		uma_set(uma,RLU_UNDER);
	pf_param(gp,"atamahane",&RL_ATAMAHANE);
	pf_param(gp,"77mangan",&RL_77MANGAN);
	pf_param(gp,"nokuikae",&RL_NOKUIKAE);
	pf_param(gp,"pao",&RL_PAO);
	pf_param(gp,"nosancyaho",&RL_NOSANCYAHO);
}

char *rule_message() {
	static char buf[1024];
	sprintf(buf,"\n\
%s ޤ%s\n\
%d  / 30000 ֤\n\
ʤ%s ֥ɥ%s ԥť%s 󥦥%s\n\
Ȥ%s Ȣ׻%s Ƭϥ%s %s\n\
Ҥ7700/Ƥ11600Ӱ%s\n\
ؤ%s ʥѥ %s\n\
˵ %d 祪 (Ĥ %d )\n\
ȯ˵%s ɥ˵%s ֥ɥ˵%s\n\
֥ɥ˵%s\n\
륹(֥ɥ飳)%s\n",
	tonpu?"":"",
	(uma_cmp(uma,RLU_NONE)==0)?"ʤ"
	:(uma_cmp(uma,RLU_5_10)==0)?"åȡ"
	:(uma_cmp(uma,RLU_10_20)==0)?"ġ"
	:(uma_cmp(uma,RLU_10_30)==0)?"󥹥꡼"
	:(uma_cmp(uma,RLU_7_5_3)==0)?""
	:(uma_cmp(uma,RLU_UNDER)==0)?"ߥ":"?",
	RL_STARTPOINT,
	RL_NONAKITAN?"ʤ":"",
	RL_NOAKADORA?"ʤ":"",
	RL_NOPINTUMO?"ʤ":"",
	RL_NOKANURA?"ʤ":"",
	RL_NOFLY?"ʤ":"",
	RL_UNDER?"":"ʤ",
	RL_ATAMAHANE?"":"ʤ",
	RL_NOSANCYAHO?RL_ATAMAHANE?"¤ʤ":"ȥ󤢤":"¤",
	RL_77MANGAN?"":"ʤ",
	RL_NOKUIKAE?"ʤ":"",
	RL_PAO?"":"ʤ",
	RLC_YAKUMAN,RLC_YAKUMAN*3/2,
	RLC_IPPATU?"":"ʤ",
	RLC_URADORA?"":"ʤ",
	RLC_AKADORA?"":"ʤ",
	RLC_NONAKIAKA?"Τ":"ʤƤդ",
	RLC_NOALLSTARS?"ʤ":"(åף)");
	return buf;
}
