-*- Indented-Text -*-

------------------------------------------------------------------------
                     LES RISQUES LIS  NESSUS
------------------------------------------------------------------------


0. Copyright

Ce document a t rdig par Michel Arboi <arboi@alussinan.org>
Je permets  quiconque de le reproduire, transmettre, imprimer,
calligraphier  la plume d'oie sur parchemin, graver dans le marbre,
transfrer sur un tee shirt, etc. pourvu qu'il ne soit pas modifi --
et a fortiori, que ce copyright soit toujours prsent.


1. Pourquoi ce document ?

On peut avoir de dsagrables expriences en lanant un test Nessus 
contre une machine fragile ou en laissant un tel outil  la porte de
n'importe qui. 
Certains n'ont pas vraiment compris le mode de fonctionnement de
Nessus, ni mme les risques lis  n'importe quel test dit "de
scurit". 


2. Considrations lgales

N'tant pas juriste, je ne m'tendrai pas sur ce sujet.
Nessus est distribu selon la GPL. Mlanie Clment-Fontaine a tudi
cette licence http://crao.net/gpl/ mais  ma connaissance, il n'existe
aucune jurisprudence.
Nessus est distribu SANS AUCUNE GARANTIE, tout comme n'importe quel
logiciel d'ailleurs. Ne venez pas vous plaindre si vous cassez une
machine en production ; de toute faon, vous n'tes pas plus couverts
avec un scanner commercial.
Mais au moins, nous vous aurons prvenus des dangers potentiels.


3. Comment fonctionne Nessus

 3.1. Squence des oprations

a) Nessus dtermine les ports ouverts 
   - en appelant le scanner externe nmap,
   - en appelant snmpwalk (contre une machine trs mal configure),
   - en utilisant un plugin interne, calqu sur un des modes de
     fonctionnement de nmap,
   - ou en utilisant un fichier externe, vu comme un rsultat de nmap,
     obtenu par un moyen quelconque, par exemple en convertissant la
     sortie de la commande netstat.
b) Ensuite le plugin "find_service" tente d'identifier ce qui tourne
   derrire chaque port  
   - tout d'abord en tentant des connexions SSL (TLSv1, SSLv3, SSLv2),
     puis standard, 
   - ensuite en envoyant diverses squences au service et en regardant
     les rponses
   find_service stocke ses dcouvertes sous forme de "cls" dans la
   "base de connaissance" (KB).
c) Sur chacun des ports ouverts, Nessus tente alors diverses
   attaques.
   Par exemple, si un script vise les serveurs web, il sera lanc
   contre tous les ports o tourne un serveur HTTP _ou_ HTTPS.

 3.2. Types et fonctionnements de plugins

Les plugins de Nessus sont classs par famille. Ceci permet de les 
regrouper dans l'interface graphique, mais n'a aucune influence sur le
fonctionnement du scanner. Il existe une famille "dni de service",
mais elle ne regroupe pas tous les scripts dangereux, seuls ceux dont
le but premier est de tuer le systme.

Chaque plugin a une "catgorie" :
- ACT_INIT
  Le script sert simplement  configurer des options et ne fait aucun
  test.
- ACT_SCANNER
  Le script est un scanner de ports ou apparent (e.g. ping).
- ACT_SETTINGS
  Mme fonction qu'ACT_INIT, mais passe aprs les scanners, quand on
  est sur que la machine rpond.
- ACT_GATHER_INFO
  Le script rcupre des informations sur le systme, par exemple
  identifie des services ou vrifie la prsence d'un logiciel 
  particulier.
- ACT_ATTACK
  Le script tente de percer certaines dfenses, en thorie sans effet
  pervers contre la disponibilit du systme.
- ACT_MIXED_ATTACK
  Le script est susceptible d'avoir des effets secondaires dsastreux,
  bien que ce ne soit pas son but.
- ACT_DESTRUCTIVE_ATTACK
  Le script tente de perturber un service ou dtruire des donnes.
- ACT_DENIAL
  Le script tente un dni de service contre un logiciel particulier.
- ACT_KILL_HOST
  Le script tente un dni de service contre la machine / le systme
  d'exploitation. 
- ACT_END
  le script se contente de compiler des information une fois que tout
  le reste est pass.

La frontire entre toutes ces catgorie est floue, et il est
impossible de prdire a priori si un script qui vise un logiciel donn
n'aura pas des effets dangereux contre un autre. 
Nessus excute en premier les scripts ACT_INIT, puis les plugins
ACT_SCANNER, puis ACT_SETTINGS, ACT_GATHER_INFO, etc.

Notes:
- ACT_INIT, ACT_END et ACT_KILL_HOST ont t introduits en version 1.3.0
  Avant (1.2.6), les ventuels scripts ACT_INIT taient dclars comme
  ACT_SETTINGS et ACT_KILL_HOST tait fusionn avec ACT_DENIAL
- avant la version 1.2.6, ACT_SETTINGS passait en tte, mais ceci
  faisait perdre du temps lorsqu'on scannait une plage d'adresses o
  peu de machines tait vivantes. En mettant ACT_SCANNER en premier,
  on filtre avec ping.nasl

Enfin, chaque script dclare des "dpendances"
- en terme de scripts qui ont d tourner avant.
  Par exemple, la plupart des scripts dpendent de "find_service".
- en terme de ports /services ouverts
  Par exemple, les scripts qui testent des vulnrabilits HTTP
  dclareront dpendre du port 80 et de la cl "Services/www".

Par principe, Nessus ne considre rien comme acquis. Contrairement 
certains scanners de scurit qui basent leurs vrifications sur les
bannires prsentes, Nessus attaque rellement les services, sauf
dans quelques rares cas mentionns dans le rapport, ou bien si
l'option "safe checks" est active (voir ci-dessous).
En consquence :
- Nessus est capable de dtecter si une faille _cense_ tre corrige
  dans la version N+1 d'un logiciel est toujours l.
- Nessus peut dcouvrir qu'une faille dirige contre le produit X
  fonctionne aussi contre le produit Y.
- Nessus a la mauvaise habitude de dmolir les services cods "avec
  les pieds" sans aucune piti.

 3.3. Slection des scripts

L'interface graphique permet de 
- tout slectionner en un clic,
- slectionner "tout sauf les plugins dangereux".
  Ce choix limine les plugins de catgorie ACT_DENIAL, ACT_KILL_HOST ou
  ACT_DESTRUCTIVE_ATTACK. Il fait double emploi avec l'option "safe
  checks" et devrait disparatre  terme. 
- slectionner ou non chaque plugin individuellement.
- slectionner une famille entire.
  Gardez  l'esprit que les scripts dangereux ne sont pas tous dans la
  famille "dni de service" !

 3.4. Options importantes

Trois options dans l'interface influencent la rsolution des dpendances :
- Enable dependencies at run time
- Optimize the test
- Consider unscanned ports as closed
Et une quatrime modifie le comportement des scripts agressifs :
- Safe checks

   3.4.1. Enable dependencies at run time

Par dfaut, Nessus ne lance pas un script si ceux dont il dpend n'ont
pas t activs. Cette option rsout automatiquement les dpendances
ncessaires. 

   3.4.2. Optimize the test

Par dfaut, Nessus lance mme les tests qui n'ont aucune chance de
russir, parce que le service n'a pas t identifi (il attaquera le
port par dfaut). Cette option acclre le test, au risque de rater
quelques vulnrabilits.

   3.4.3. Consider unscanned ports as closed

Par dfaut, Nessus considre les ports non scanns comme
"ouverts". Cette option inverse le comportement et acclre le test. 
Elle n'a d'effet que combine avec "optimize the test".

   3.4.4. Safe checks

Cette option dsactive les tests dangereux susceptibles de tuer le
systme ou un service. Nessus s'appuie si possible sur les numros de
version renvoys par les bannires, par exemple.
Si aucun indice n'est disponible, le test est tout simplement abandonn.

Cette option est moins inoffensive qu'elle parat :
- Elle peut donner un faux sentiment de scurit. Qu'une faille ne
  soit pas mentionne dans le rapport ne signifie pas qu'elle soit
  absente du systme. 
- Si le script est mal crit et ne vrifie pas la valeur de l'option
  avec la fonction safe_checks(), l'attaque sera quand mme lanc.
  A priori, les scripts livrs avec Nessus sont srs, mais un script
  "non officiel" ou exprimental pourrait tre dangereux.

NB : les scripts ACT_DENIAL, ACT_KILL_HOST et ACT_DESTRUCTIVE_ATTACK
ne sont jamais lancs quand cette option est active.


4. Comment un test de scurit peut tuer votre systme

 4.1. Politique

Avant d'accabler Nessus de sordides qualificatifs, sachez que toucher
une machine sensible en production est suicidaire. Les consultants
scurit sont rarement apprcis : ils sont vus soit comme des
pirates, soit comme des cyberflics. Si la machine part en vrille au
moment o vous commencez votre test pour une raison externe, on sera
trop heureux de vous rendre responsable des dommages causs.
Que vous soyez convaincu de n'avoir rien fait de mal est une chose,
que vous sachiez convaincre le juge qui doit valuer les
responsabilits et le montant du prjudice subi en est une autre.
Les arguments contractuels simplistes ne tiennent pas devant un
tribunal, en France du moins. N'oubliez pas que le droit n'est pas une
science exacte (en fait, ce n'est pas une science du tout :-)

 4.2. Les dangers du scan de ports

- En TCP, le scanner ouvre une connexion puis la referme immdiatement
  sans envoyer de donnes. 
  Certains logiciels meurent ou partent en boucle s'ils n'arrivent pas
   lire de donnes. Contrairement  ce que certains pourraient 
  penser, les scans furtifs "nul scan" ou "Christmas tree" prsentent 
  moins de risques car ils ne remontent pas jusqu'aux logiciels 
  applicatifs potentiellement bugus. Ils ne marchent pas contre tous 
  les systmes d'exploitation, hlas.
- En UDP, il envoie un paquet sans donnes.
  Ceci est suffisant pour tuer certaines piles IP dfectueuses ou un
  logiciel mal cod.
- dans quelques cas rares maintenant, les scans furtifs ou
  l'identification du systme par "fingerprinting" peuvent tuer la
  pile IP. On rencontre encore des logiciels embarqus vulnrables 
  ce genre de dni de service.
- snmpwalk peut lui aussi tre dangereux !

On peut rcuprer la liste des ports ouverts par la commande netstat
puis la convertir avec la commande netstat2nmap.pl en un pseudo
fichier nmap, lisible par Nessus. Ainsi, on n'a pas  lancer le
scanner. Toutefois, l'intrt de cette opration tait plutt
d'acclrer le test que d'en limiter les risques.

 4.3. Entreprise de dmolition Nessus & Cie

Certains scripts gnriques sont particulirement mchants :
- Dbordements mmoire contre divers champs / requtes des protocoles
  HTTP, FTP, POP3...
- Requtes mal formes (HTTP, FTP...)
- Tests par saturation, inondant un service inconnu de myriades
  d'octets.

Par ailleurs, outre les effets secondaires du scanner de port,
certains logiciels n'apprcient pas l'interrogatoire que leur fait subir
find_service,  commencer par les multiples tentatives de connexion
SSL. 

check_ports, un plugin qui teste d'ventuels dnis de service
provoqus par un scanner de ports ou find_service, fait l'quivalent
d'un "nmap -sT" sur les ports supposs ouverts. Avec les risques
(faibles) que cela comporte...

Mme un simple plugin de type ACT_GATHER_INFO peut tuer un service mal
conu. Le risque zro n'existe pas !

Notez qu'il existe un test qui pourrait rellement tenter d'effacer
des donnes : http_methods.nasl. Toutefois, la partie de code
dangereuse est dsactive en mode "safe checks".


5. Limitation des risques

Vous tenez  tester votre application sensible et en cas de problme,
vous ne vous en prendrez qu' vous mme. En clair, vous voulez
affirmer haut et fort votre condition d'homme libre en vous tirant
dans le pied. Vous aimeriez bien que a ne fasse pas trop mal...

[Dans la suite, la machine cible s'appelle guinea-pig]

 5.1. Supprimez le port scan

- Connectez-vous sur guinea-pig, lancez "netstat -a -n --inet" ou tout
  autre commande ncessaire sur votre systme pour rcuprer les ports
  IP ouverts (--inet) sous forme numrique (-n).
- crivez le rsultat dans un fichier nomm "guinea-pig" (il est 
  important que ce fichier porte le nom de la machine "scanne")
- Convertissez-le en fichier nmap par :
  netstat2nmap guinea-pig > gp.nmap  
- ne slectionnez _que_ le scanner "nmap" et jetez lui gp.nmap en
  pture. La plage de ports "scanne" devrait tre 1-65535

 5.2. Limez les dents de Nessus

- Activez l'option "safe checks"
- Activez "optimize the test".
- Dsactivez "enable dependencies at run time".
- Supprimez les plugins que vous pensez inutiles ou dangereux.
- Si aucun service ne s'appuie sur SSL, dsactivez "test SSL services"
  (une des "prfrences" du plugin find_service)
- dsactivez check_ports.nasl

 5.3. Risques rsiduels

- find_service est susceptible de faire plus de dgats que le scanner
  de ports, mme sans les essais de connexions SSL.
- des plugins ACT_GATHER_INFO peuvent avoir le mme effet, mais
  "optimize the test" rduit les risques.


9. Nessus entre de mauvaises mains

Nessus est un redoutable outil de test, capable aussi bien d'indiquer 
aux "chapeaux blancs" les correctifs qu'ils doivent appliquer pour
durcir leur systme ou aux "chapeaux noirs" les "exploits" qu'ils
doivent utiliser pour percer les dfenses de la machine.

 9.1. Une arme en vente libre ?

Je n'ai pas envie de relancer le troll^W dbat "pour ou contre le full
disclosure".
Comme beaucoup d'outils, ce n'est pas Nessus lui mme mais son
utilisation qui peut tre bonne ou mauvaise.

Nessus est destin aux "chapeaux blancs". Ses principes de conception
ne facilitent pas la vie des pirates : il est terriblement bruyant.
Les pirates cherchant gnralement  tre discrets, c'est rat.

Il est possible de torturer Nessus pour le faire passer par l'un des
nombreux proxys ouverts qui tranent sur Internet. Pour des raisons
que vous comprendrez, j'espre, je n'ai pas envie de documenter la
procdure :-]

Quelques traces (petit extrait) :
Dec 15 16:43:32 casserole login(pam_unix)[5888]: authentication failure; logname= uid=0 euid=0 tty=pts/17 ruser= rhost=localhost  user=root
Dec 15 16:43:32 casserole login(pam_unix)[5886]: check pass; user unknown
Dec 15 16:43:32 casserole login(pam_unix)[5886]: authentication failure; logname= uid=0 euid=0 tty=pts/16 ruser= rhost=localhost 
Dec 15 16:43:34 casserole login[5880]: FAILED LOGIN 1 FROM localhost FOR backdoor, Authentication failure
Dec 15 16:43:56 casserole fam[1354]: fd 109 message length 1312236900 bytes exceeds max of 4135.
Dec 15 16:44:11 casserole SERVER[5930]: Dispatch_input: bad request line '< NTP/1.0 >^M'
127.0.0.1 - - [15/Dec/2001:16:44:39 +0100] "GET http://www.nessus.org HTTP/1.0" 200 2890 "-" "-"
127.0.0.1 - - [15/Dec/2001:17:25:44 +0100] ".`" 501 - "-" "-"
127.0.0.1 - - [15/Dec/2001:17:25:45 +0100] "GET /cgi-bin/nessus_is_probing_this_host_2033195663 HTTP/1.1" 404 335 "-" "Mozilla/4.75 [en] (X11, U; Nessus)"
127.0.0.1 - - [15/Dec/2001:17:29:58 +0100] "are you dead ?" 400 339 "-" "-"

 9.2. Fonctions anti NIDS

La version 1.1.13 a introduit des fonctions "d'vasion", au niveau TCP
et HTTP, qui s'appuient sur divers travaux disponibles publiquement.
http://www.wiretrip.net/rfp/pages/whitepapers/whiskerids.html
http://www.securityfocus.com/data/library/ids.ps
http://rr.sans.org/intrusion/anti-ids.php

Le but de ces fonctions n'est pas de permettre aux "black hats"
d'attaquer plus facilement les systmes ouverts sur Internet, mais aux
"white hats" de tester les mesures de protection mises en place.

L'outil freeware Snort n'est tromp par aucune de ces options, et en
fait Nessus est peru comme plus bruyant quand elles sont actives.

 9.3. Contrle d'accs  Nessus

Nettement plus grave, un pirate pourrait prendre le contrle d'un
serveur Nessus dirig contre vos machines ou celles de vos
clients. Nul n'est  l'abri d'un bug, mais certaines prcautions
devraient ramener le risque  un niveau acceptable :

- Si le client et le serveur tournent sur la mme machine, configurez
  Nessus pour utiliser les sockets Unix. Vrifiez que le port 1241 est
  ferm. 
- Configurez Nessus avec les TCP wrappers et limitez l'accs aux rares
  postes qui en ont besoin, par exemple localhost.
- Activez l'authentification par certificats client X.509. Gnrez vos
  propres certificats, n'utilisez surtout pas ceux de la "kabale
  Nessus" !
  Le mieux est de protger vos cls prives (serveur et client) par un
  mot de passe solide, ce que le script nessus-mkcert ne fait
  pas. Vous devrez mettre en place votre propre "usine  certificats".
- teignez la machine qui hberge le serveur Nessus quand elle n'est
  pas utilise.

Note: actuellement, l'authentification par certificats est
incompatible avec les sockets Unix. 
