package TestModperl::io_nested_with_closed_stds;

# test that we can successfully override STD(IN|OUT) for
# 'perl-script', even if they are closed. Here we use
# internal_redirect(), which causes a nested override of already
# overriden STD streams

use strict;
use warnings FATAL => 'all';

use Apache::RequestRec ();
use Apache::RequestIO ();
use Apache::SubRequest ();

use Apache::Test;

use Apache::Const -compile => 'OK';

sub handler {
    my $r = shift;

    my $args = $r->args || '';
    if ($args eq 'redirect') {
        # sub-req
        $r->content_type('text/plain');
        # do not use plan() here, since it messes up with STDOUT,
        # which affects this test.
        print "1..1\nok 1\n";
    }
    else {
        # main-req
        my $redirect_uri = $r->uri . "?redirect";

        # we must close STDIN as well, due to a perl bug (5.8.0 - 5.8.3
        # w/useperlio), which emits a warning if dup is called with
        # one of the STD streams is closed.
        # but we must restore the STD streams so not to affect other
        # tests.
        open my $oldin,  "<&STDIN"  or die "Can't dup STDIN: $!";
        open my $oldout, ">&STDOUT" or die "Can't dup STDOUT: $!";
        close STDIN;
        close STDOUT;

        $r->internal_redirect($redirect_uri);

        open STDIN,  "<&", $oldin  or die "Can't dup \$oldin: $!";
        open STDOUT, ">&", $oldout or die "Can't dup \$oldout: $!";
        close $oldin;
        close $oldout;
    }

    Apache::OK;
}

1;
__DATA__
SetHandler perl-script

