/* 
 * Ming/Ruby
 * $Id: swfbutton.c,v 1.3 2002/06/06 18:11:49 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ming.h>
#include "ruby.h"
#include "ming_ruby.h"

VALUE rb_cSWFButton;

void rb_SWFButton_mark(button)
     struct RSWFButton *button;
{
  mark_references(button->table);
  return;
}

static VALUE
rb_SWFButton_s_new(self)
	 VALUE self;
{
  struct RSWFButton *b = ALLOC(struct RSWFButton);
  VALUE obj;

  b->this = newSWFButton();
  b->table = ALLOC(struct References);
  init_references(b->table);
  
  obj = Data_Wrap_Struct(rb_cSWFButton, rb_SWFButton_mark,
			 rb_SWFButton_free, b);

  return obj;
}

void
rb_SWFButton_free(p)
     struct RSWFButton *p;
{
  // destroySWFButton(p->this);
  return;
}

static VALUE
rb_SWFButton_add_shape(self, character, f)
     VALUE self, character, f;
{
  struct RSWFButton *b;
  struct RSWFCharacter *c;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(character, struct RSWFCharacter, c);

  regist_references(b->table, character);
  SWFButton_addShape(b->this, c->this, NUM2CHR(f));
  
  return self;
}

static VALUE
rb_SWFButton_set_up(self, character)
	 VALUE self, character;
{
  struct RSWFButton *b;
  struct RSWFCharacter *c;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(character, struct RSWFCharacter, c);

  regist_references(b->table, character);
  SWFButton_addShape(b->this, c->this, SWFBUTTON_UP);
  
  return self;
}

static VALUE
rb_SWFButton_set_down(self, character)
	 VALUE self, character;
{
  struct RSWFButton *b;
  struct RSWFCharacter *c;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(character, struct RSWFCharacter, c);

  regist_references(b->table, character);
  SWFButton_addShape(b->this, c->this, SWFBUTTON_DOWN);
  
  return self;
}

static VALUE
rb_SWFButton_set_over(self, character)
	 VALUE self, character;
{
  struct RSWFButton *b;
  struct RSWFCharacter *c;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(character, struct RSWFCharacter, c);

  regist_references(b->table, character);
  SWFButton_addShape(b->this, c->this, SWFBUTTON_OVER);
  
  return self;
}

static VALUE
rb_SWFButton_set_hit(self, character)
	 VALUE self, character;
{
  struct RSWFButton *b;
  struct RSWFCharacter *c;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(character, struct RSWFCharacter, c);

  regist_references(b->table, character);
  SWFButton_addShape(b->this, c->this, SWFBUTTON_HIT);
  
  return self;
}

static VALUE
rb_SWFButton_add_action(self, action, f)
	 VALUE self, action, f;
{
  struct RSWFButton *b;
  struct RSWFAction *a;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(action, struct RSWFAction, a);

  regist_references(b->table, action);
  SWFButton_addAction(b->this, a->this, NUM2INT(f));
  
  return self;
}

static VALUE
rb_SWFButton_set_action(self, action)
	 VALUE self, action;
{
  struct RSWFButton *b;
  struct RSWFAction *a;

  Data_Get_Struct(self, struct RSWFButton, b);
  Data_Get_Struct(action, struct RSWFAction, a);

  regist_references(b->table, action);
  SWFButton_addAction(b->this, a->this, SWFBUTTON_MOUSEUP);
  
  return self;
}

void
Init_swfbutton()
{
  rb_cSWFButton = rb_define_class_under(rb_mMing, "SWFButton", rb_cObject);

  rb_define_singleton_method(rb_cSWFButton, "new",
			     rb_SWFButton_s_new, 0);

  rb_define_method(rb_cSWFButton, "add_shape",
		   rb_SWFButton_add_shape, 2);
  rb_define_method(rb_cSWFButton, "set_up",
		   rb_SWFButton_set_up, 1);
  rb_define_method(rb_cSWFButton, "set_down",
		   rb_SWFButton_set_down, 1);
  rb_define_method(rb_cSWFButton, "set_over",
		   rb_SWFButton_set_over, 1);
  rb_define_method(rb_cSWFButton, "set_hit",
		   rb_SWFButton_set_hit, 1);
  rb_define_method(rb_cSWFButton, "add_action",
		   rb_SWFButton_add_action, 2);
  rb_define_method(rb_cSWFButton, "set_action",
		   rb_SWFButton_set_action, 1);
  
  return;
}
