/* 
 * Ming/Ruby
 * $Id: ming_ruby.h,v 1.6 2002/06/27 13:28:06 daisu-ik Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _MING_RUBY_H
#define _MING_RUBY_H

#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif

struct References {
  unsigned long size;
  VALUE *item;
};

#define DECLARE_SWF_STRUCT(name) \
  struct R ## name \
  { \
    name this; \
    struct References *table; \
    void *option; \
  };

DECLARE_SWF_STRUCT(SWFAction);
DECLARE_SWF_STRUCT(SWFBitmap);
DECLARE_SWF_STRUCT(SWFBlock);
DECLARE_SWF_STRUCT(SWFButton);
DECLARE_SWF_STRUCT(SWFCharacter);
DECLARE_SWF_STRUCT(SWFDisplayItem);
DECLARE_SWF_STRUCT(SWFFill);
DECLARE_SWF_STRUCT(SWFFont);
DECLARE_SWF_STRUCT(SWFGradient);
DECLARE_SWF_STRUCT(SWFMorph);
DECLARE_SWF_STRUCT(SWFMovie);
DECLARE_SWF_STRUCT(SWFMovieClip);
DECLARE_SWF_STRUCT(SWFShape);
DECLARE_SWF_STRUCT(SWFText);
DECLARE_SWF_STRUCT(SWFTextField);

/* initialize */
void Init_ming();
void Init_swfmovie();
void Init_swfshape();
void Init_swfdisplayitem();
void Init_swfgradient();
void Init_swfbitmap();
void Init_swffill();
void Init_swfmorph();
void Init_swftext();
void Init_swffont();
void Init_swftextfield();
void Init_swfmovieclip();
void Init_swfbutton();
void Init_swfaction();

/* free */
void rb_SWFMovie_free(struct RSWFMovie *p);
void rb_SWFShape_free(struct RSWFShape *p);
void rb_SWFDisplayItem_free(struct RSWFDisplayItem *p);
void rb_SWFGradient_free(struct RSWFGradient *p);
void rb_SWFBitmap_free(struct RSWFBitmap *p);
void rb_SWFFill_free(struct RSWFFill *p);
void rb_SWFMorph_free(struct RSWFMorph *p);
void rb_SWFText_free(struct RSWFText *p);
void rb_SWFFont_free(struct RSWFFont *p);
void rb_SWFTextField_free(struct RSWFTextField *p);
void rb_SWFMovieClip_free(struct RSWFMovieClip *p);
void rb_SWFButton_free(struct RSWFButton *p);
void rb_SWFAction_free(struct RSWFAction *p);

/* modules and classes */
extern VALUE rb_mMing;
extern VALUE rb_cSWFMovie;
extern VALUE rb_cSWFShape;
extern VALUE rb_cSWFDisplayItem;
extern VALUE rb_cSWFGradient;
extern VALUE rb_cSWFBitmap;
extern VALUE rb_cSWFFill;
extern VALUE rb_cSWFMorph;
extern VALUE rb_cSWFText;
extern VALUE rb_cSWFFont;
extern VALUE rb_cSWFTextField;
extern VALUE rb_cSWFMovieClip;
extern VALUE rb_cSWFButton;
extern VALUE rb_cSWFAction;

/* Exceptions */
extern VALUE rb_eMingError;
void rb_Ming_raise(char *msg, ...);
void setSWFWarnFunction(void (*warnfunc)(char *msg, ...));
void setSWFErrorFunction(void (*warnfunc)(char *msg, ...));

/* utilities */
int strncmp_ignore_case(const char *s1, const char *s2, size_t n);
FILE *search_file(VALUE path, char *name, char *mode);

/* reference table */
int init_references(struct References *t);
int regist_references(struct References *t, VALUE s);
int mark_references(struct References *t);

#endif
