 /*
 MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

 $Id: viterbi.h,v 1.12 2003/01/24 17:13:55 taku-ku Exp $;

 Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _MECAB_VITERBI_H
#define _MECAB_VITERBI_H

#include "mecab.h"
#include "tokenizer.h"
#include "freelist.h"
#include "param.h"
#include <vector>
#include <iostream>

namespace MeCab {
   
  class Viterbi 
  {
  protected:
    Tokenizer* tokenizer;
    Node*      eosNode;
    Node*      bosNode;
    char*      begin;
    char*      end;  
    bool       detail;
    unsigned int alloc_size;
    std::string _what;
    Node** endNodeList;
    Node** lookupCache;
    Node  *lookup  (unsigned int);
    FreeList<Path> *pathFreeList;
    void connectNormal        (unsigned int, Node*);     
    void connectWithAllPath   (unsigned int, Node*);
    void (Viterbi::*_connect) (unsigned int, Node*);
    inline void connect (unsigned int p, Node* n) { (this->*_connect) (p,n); }
    
  public:
    void clear ();
    Node *analyze (const char*, unsigned int);
    Node *getEndSibling   (unsigned int n)  { return endNodeList[n]; };
    Node *getBeginSibling (unsigned int n)  { return lookupCache[n]; };
    unsigned int getLength () { return (unsigned int)(end - begin); }
    void setTokenizer (Tokenizer *t) { tokenizer = t; }
    const char *what () { return _what.c_str(); }
    Viterbi (Param&, Tokenizer*);
    ~Viterbi ();
  }; 
}
#endif
