/*
 MeCab -- Yet Another Part-of-Speech and Morphological Analyzer

 $Id: freelist.h,v 1.4 2002/09/07 10:05:51 taku-ku Exp $;

 Copyright (C) 2001-2002  Taku Kudo <taku-ku@is.aist-nara.ac.jp>
 All rights reserved.

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Library General Public
 License as published by the Free Software Foundation; either
 version 2 of the License, or (at your option) any later verjsion.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Library General Public License for more details.

 You should have received a copy of the GNU Library General Public
 License along with this library; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
*/
#ifndef _MECAB_FREELIST_H
#define _MECAB_FREELIST_H

#include <vector>
#include <stdexcept>

namespace MeCab {

  template <class T> 
  class FreeList
  {
  private:
    std::vector <T *> freeList;
    unsigned int pi;
    unsigned int li;
    unsigned int size;

  public:
    void free () { li = pi = 0; }

    T* alloc ()
    {
      try {
	if (pi == size) { li++; pi = 0; }
	if (li == freeList.size()) freeList.push_back(new T [size]);
	return freeList[li] + (pi++);
      }

      catch (std::exception &e) {
	std::cerr << "FreeList::alloc (): " << e.what () << std::endl;
	exit (EXIT_FAILURE);
	return 0; 
      }
    }

    FreeList (unsigned int _size): pi(0), li(0), size (_size) {}

    ~FreeList ()
    {
      for (li = 0; li < freeList.size(); li++) delete [] freeList[li];
    }
  };
}
#endif
