/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    inline SwigValueWrapper() : tt(0) { }
    inline ~SwigValueWrapper() { if (tt) delete tt; } 
    inline SwigValueWrapper& operator=(const T& t) { tt = new T(t); return *this; }
    inline operator T&() const { return *tt; }
    inline T *operator&() { return tt; }
};                                                    
#endif

/* ruby.swg */
/* Implementation : RUBY */
#define SWIGRUBY 1

#include "ruby.h"

#define NUM2USHRT(n) (\
    (0 <= NUM2UINT(n) && NUM2UINT(n) <= USHRT_MAX)\
    ? (unsigned short) NUM2UINT(n) \
    : (rb_raise(rb_eArgError, "integer %d out of range of `unsigned short'",\
               NUM2UINT(n)), (short)0)\
)

#define NUM2SHRT(n) (\
    (SHRT_MIN <= NUM2INT(n) && NUM2INT(n) <= SHRT_MAX)\
    ? (short)NUM2INT(n)\
    : (rb_raise(rb_eArgError, "integer %d out of range of `short'",\
               NUM2INT(n)), (short)0)\
)

/* Ruby 1.7 defines NUM2LL(), LL2NUM() and ULL2NUM() macros */
#ifndef NUM2LL
#define NUM2LL(x) NUM2LONG((x))
#endif
#ifndef LL2NUM
#define LL2NUM(x) INT2NUM((long) (x))
#endif
#ifndef ULL2NUM
#define ULL2NUM(x) UINT2NUM((unsigned long) (x))
#endif

/* Ruby 1.7 doesn't (yet) define NUM2ULL() */
#ifndef NUM2ULL
#ifdef HAVE_LONG_LONG
#define NUM2ULL(x) rb_num2ull((x))
#else
#define NUM2ULL(x) NUM2ULONG(x)
#endif
#endif

/*
 * Need to be very careful about how these macros are defined, especially
 * when compiling C++ code or C code with an ANSI C compiler.
 *
 * VALUEFUNC(f) is a macro used to typecast a C function that implements
 * a Ruby method so that it can be passed as an argument to API functions
 * like rb_define_method() and rb_define_singleton_method().
 *
 * VOIDFUNC(f) is a macro used to typecast a C function that implements
 * either the "mark" or "free" stuff for a Ruby Data object, so that it
 * can be passed as an argument to API functions like Data_Wrap_Struct()
 * and Data_Make_Struct().
 */
 
#ifdef __cplusplus
#  ifndef RUBY_METHOD_FUNC /* These definitions should work for Ruby 1.4.6 */
#    define VALUEFUNC(f) ((VALUE (*)()) f)
#    define VOIDFUNC(f)  ((void (*)()) f)
#  else
#    ifndef ANYARGS /* These definitions should work for Ruby 1.6 */
#      define VALUEFUNC(f) ((VALUE (*)()) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    else /* These definitions should work for Ruby 1.7 */
#      define VALUEFUNC(f) ((VALUE (*)(ANYARGS)) f)
#      define VOIDFUNC(f)  ((RUBY_DATA_FUNC) f)
#    endif
#  endif
#else
#  define VALUEFUNC(f) (f)
#  define VOIDFUNC(f) (f)
#endif

typedef struct {
  VALUE  klass;
  void  (*mark)(void *);
  void  (*destroy)(void *);
} swig_class;

/***********************************************************************
 * common.swg
 *
 *     This file contains generic SWIG runtime support for pointer
 *     type checking as well as a few commonly used macros to control
 *     external linkage.
 *
 * Author : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (c) 1999-2000, The University of Chicago
 * 
 * This file may be freely redistributed without license or fee provided
 * this copyright message remains intact.
 ************************************************************************/

#include <string.h>

#if defined(_WIN32) || defined(__WIN32__)
#       if defined(_MSC_VER)
#               if defined(STATIC_LINKED)
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) extern a
#               else
#                       define SWIGEXPORT(a) __declspec(dllexport) a
#                       define SWIGIMPORT(a) extern a
#               endif
#       else
#               if defined(__BORLANDC__)
#                       define SWIGEXPORT(a) a _export
#                       define SWIGIMPORT(a) a _export
#               else
#                       define SWIGEXPORT(a) a
#                       define SWIGIMPORT(a) a
#               endif
#       endif
#else
#       define SWIGEXPORT(a) a
#       define SWIGIMPORT(a) a
#endif

#ifdef SWIG_GLOBAL
#define SWIGRUNTIME(a) SWIGEXPORT(a)
#else
#define SWIGRUNTIME(a) static a
#endif

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

typedef struct swig_type_info {
  const char             *name;                 
  swig_converter_func     converter;
  const char             *str;
  void                   *clientdata;	
  swig_dycast_func        dcast;
  struct swig_type_info  *next;
  struct swig_type_info  *prev;
} swig_type_info;

#ifdef SWIG_NOINCLUDE

SWIGIMPORT(swig_type_info *) SWIG_TypeRegister(swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeCheck(char *c, swig_type_info *);
SWIGIMPORT(void *)           SWIG_TypeCast(swig_type_info *, void *);
SWIGIMPORT(swig_type_info *) SWIG_TypeDynamicCast(swig_type_info *, void **);
SWIGIMPORT(const char *)     SWIG_TypeName(const swig_type_info *);
SWIGIMPORT(swig_type_info *) SWIG_TypeQuery(const char *);
SWIGIMPORT(void)             SWIG_TypeClientData(swig_type_info *, void *);

#else

static swig_type_info *swig_type_list = 0;

/* Register a type mapping with the type-checking */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeRegister(swig_type_info *ti)
{
  swig_type_info *tc, *head, *ret, *next;
  /* Check to see if this type has already been registered */
  tc = swig_type_list;
  while (tc) {
    if (strcmp(tc->name, ti->name) == 0) {
      /* Already exists in the table.  Just add additional types to the list */
      if (tc->clientdata) ti->clientdata = tc->clientdata;	
      head = tc;
      next = tc->next;
      goto l1;
    }
    tc = tc->prev;
  }
  head = ti;
  next = 0;

  /* Place in list */
  ti->prev = swig_type_list;
  swig_type_list = ti;

  /* Build linked lists */
 l1:
  ret = head;
  tc = ti + 1;
  /* Patch up the rest of the links */
  while (tc->name) {
    head->next = tc;
    tc->prev = head;
    head = tc;
    tc++;
  }
  if (next) next->prev = head;  /**/
  head->next = next;
  return ret;
}

/* Check the typename */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeCheck(char *c, swig_type_info *ty)
{
  swig_type_info *s;
  if (!ty) return 0;        /* Void pointer */
  s = ty->next;             /* First element always just a name */
  do {
    if (strcmp(s->name,c) == 0) {
      if (s == ty->next) return s;
      /* Move s to the top of the linked list */
      s->prev->next = s->next;
      if (s->next) {
	s->next->prev = s->prev;
      }
      /* Insert s as second element in the list */
      s->next = ty->next;
      if (ty->next) ty->next->prev = s;
      ty->next = s;
      s->prev = ty;  /**/
      return s;
    }
    s = s->next;
  } while (s && (s != ty->next));
  return 0;
}

/* Cast a pointer up an inheritance hierarchy */
SWIGRUNTIME(void *) 
SWIG_TypeCast(swig_type_info *ty, void *ptr) 
{
  if ((!ty) || (!ty->converter)) return ptr;
  return (*ty->converter)(ptr);
}

/* Dynamic pointer casting. Down an inheritance hierarchy */
SWIGRUNTIME(swig_type_info *) 
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) 
{
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
     ty = (*ty->dcast)(ptr);
     if (ty) lastty = ty;
  }
  return lastty;
}

/* Return the name associated with this type */
SWIGRUNTIME(const char *)
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/* Search for a swig_type_info structure */
SWIGRUNTIME(swig_type_info *)
SWIG_TypeQuery(const char *name) {
  swig_type_info *ty = swig_type_list;
  while (ty) {
    if (ty->str && (strcmp(name,ty->str) == 0)) return ty;
    if (ty->name && (strcmp(name,ty->name) == 0)) return ty;
    ty = ty->prev;
  }
  return 0;
}

/* Set the clientdata field for a type */
SWIGRUNTIME(void)
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_type_info *tc, *equiv;
  if (ti->clientdata == clientdata) return;
  ti->clientdata = clientdata;
  equiv = ti->next;
  while (equiv) {
    if (!equiv->converter) {
      tc = swig_type_list;
      while (tc) {
	if ((strcmp(tc->name, equiv->name) == 0))
	  SWIG_TypeClientData(tc,clientdata);
	tc = tc->prev;
      }
    }
    equiv = equiv->next;
  }
}
#endif

#ifdef __cplusplus
}

#endif

/* rubydef.swg */
#ifdef __cplusplus
extern "C" {
#endif

static VALUE _mSWIG = Qnil;
static VALUE _cSWIG_Pointer = Qnil;

/* Initialize Ruby runtime support */
SWIGRUNTIME(void)
SWIG_InitRuntime(void)
{
    if (_mSWIG == Qnil) {
        _mSWIG = rb_define_module("SWIG");
    }
}

/* Define Ruby class for C type */
SWIGRUNTIME(void)
SWIG_define_class(swig_type_info *type)
{
    VALUE klass;
    char *klass_name = (char *) malloc(4 + strlen(type->name) + 1);
    sprintf(klass_name, "TYPE%s", type->name);
    if (NIL_P(_cSWIG_Pointer)) {
	_cSWIG_Pointer = rb_define_class_under(_mSWIG, "Pointer", rb_cObject);
	rb_undef_method(CLASS_OF(_cSWIG_Pointer), "new");
    }
    klass = rb_define_class_under(_mSWIG, klass_name, _cSWIG_Pointer);
    free((void *) klass_name);
}

/* Create a new pointer object */
SWIGRUNTIME(VALUE)
SWIG_NewPointerObj(void *ptr, swig_type_info *type, int own)
{
    char *klass_name;
    swig_class *sklass;
    VALUE klass;
    VALUE obj;
    
    if (!ptr)
	return Qnil;
    
    if (type->clientdata) {
      sklass = (swig_class *) type->clientdata;
      obj = Data_Wrap_Struct(sklass->klass, VOIDFUNC(sklass->mark), (own ? VOIDFUNC(sklass->destroy) : 0), ptr);
    } else {
      klass_name = (char *) malloc(4 + strlen(type->name) + 1);
      sprintf(klass_name, "TYPE%s", type->name);
      klass = rb_const_get(_mSWIG, rb_intern(klass_name));
      free((void *) klass_name);
      obj = Data_Wrap_Struct(klass, 0, 0, ptr);
    }
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Create a new class instance (always owned) */
SWIGRUNTIME(VALUE)
SWIG_NewClassInstance(VALUE klass, swig_type_info *type)
{
    VALUE obj;
    swig_class *sklass = (swig_class *) type->clientdata;
    obj = Data_Wrap_Struct(klass, VOIDFUNC(sklass->mark), VOIDFUNC(sklass->destroy), 0);
    rb_iv_set(obj, "__swigtype__", rb_str_new2(type->name));
    return obj;
}

/* Get type mangle from class name */
SWIGRUNTIME(char *)
SWIG_MangleStr(VALUE obj)
{
  VALUE stype = rb_iv_get(obj, "__swigtype__");
  return STR2CSTR(stype);
}

/* Convert a pointer value */
SWIGRUNTIME(int)
SWIG_ConvertPtr(VALUE obj, void **ptr, swig_type_info *ty, int flags)
{
  char *c;
  swig_type_info *tc;

  /* Grab the pointer */
  if (NIL_P(obj)) {
    *ptr = 0;
    return 0;
  } else
    Data_Get_Struct(obj, void, *ptr);
  
  /* Do type-checking if type info was provided */
  if (ty) {
    if (ty->clientdata) {
        if (!rb_obj_is_kind_of(obj, ((swig_class *) (ty->clientdata))->klass)) {
          if (flags)
	    rb_raise(rb_eTypeError, "wrong argument type (expected %s)", ty->str);
	  else
	    return -1;
	}
        if (*ptr == 0)
	  rb_raise(rb_eRuntimeError, "This %s already released", ty->str);
    } else {
      if ((c = SWIG_MangleStr(obj)) == NULL) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      tc = SWIG_TypeCheck(c, ty);
      if (!tc) {
        if (flags)
	  rb_raise(rb_eTypeError, "Expected %s", ty->str);
	else
	  return -1;
      }
      *ptr = SWIG_TypeCast(tc, *ptr);
    }
  }
  return 0;
}

/* Check convert */
SWIGRUNTIME(int)
SWIG_CheckConvert(VALUE obj, swig_type_info *ty)
{
  char *c = SWIG_MangleStr(obj);
  if (!c)
    return 0;
  return SWIG_TypeCheck(c,ty) != 0;
}

/* Pack binary data into a string */
SWIGRUNTIME(char *)
SWIG_PackData(char *c, void *ptr, int sz) {
  static char hex[17] = "0123456789abcdef";
  int i;
  unsigned char *u = (unsigned char *) ptr;
  register unsigned char uu;
  for (i = 0; i < sz; i++,u++) {
    uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* Unpack binary data from a string */
SWIGRUNTIME(char *)
SWIG_UnpackData(char *c, void *ptr, int sz) {
  register unsigned char uu = 0;
  register int d;
  unsigned char *u = (unsigned char *) ptr;
  int i;
  for (i = 0; i < sz; i++, u++) {
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    *u = uu;
  }
  return c;
}

SWIGRUNTIME(VALUE)
SWIG_NewPackedObj(void *ptr, int sz, swig_type_info *type) {
  char result[1024];
  char *r = result;
  if ((2*sz + 1 + strlen(type->name)) > 1000) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r, ptr, sz);
  strcpy(r, type->name);
  return rb_str_new2(result);
}

/* Convert a packed value value */
SWIGRUNTIME(void)
SWIG_ConvertPacked(VALUE obj, void *ptr, int sz, swig_type_info *ty, int flags) {
  swig_type_info *tc;
  char  *c;

  if (TYPE(obj) != T_STRING) goto type_error;
  c = STR2CSTR(obj);
  /* Pointer values must start with leading underscore */
  if (*c != '_') goto type_error;
  c++;
  c = SWIG_UnpackData(c, ptr, sz);
  if (ty) {
    tc = SWIG_TypeCheck(c, ty);
    if (!tc) goto type_error;
  }
  return;

type_error:

  if (flags) {
    if (ty) {
      rb_raise(rb_eTypeError, "Type error. Expected %s", ty->name);
    } else {
      rb_raise(rb_eTypeError, "Expected a pointer");
    }
  }
}

#ifdef __cplusplus
}
#endif



/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_SWIG_MeCab__Path swig_types[0] 
#define  SWIGTYPE_p_SWIG_MeCab__Tagger swig_types[1] 
#define  SWIGTYPE_p_p_char swig_types[2] 
#define  SWIGTYPE_p_SWIG_MeCab__Node swig_types[3] 
static swig_type_info *swig_types[5];

/* -------- TYPES TABLE (END) -------- */

#define SWIG_init    Init_MeCab
#define SWIG_name    "MeCab"

static VALUE mMeCab;

#define  SWIG_MemoryError    rb_eFatal
#define  SWIG_IOError        rb_eIOError
#define  SWIG_RuntimeError   rb_eRuntimeError
#define  SWIG_IndexError     rb_eIndexError
#define  SWIG_TypeError      rb_eTypeError
#define  SWIG_DivisionByZero rb_eZeroDivError
#define  SWIG_OverflowError  rb_eRuntimeException
#define  SWIG_SyntaxError    rb_eSyntaxError
#define  SWIG_ValueError     rb_eArgError
#define  SWIG_SystemError    rb_eSystemError
#define  SWIG_UnknownError   rb_eRuntimeError

#define SWIG_exception(a,b) rb_raise(a,b)



#ifdef __cplusplus
extern "C" {
#endif
#ifdef HAVE_SYS_TIME_H
# include <sys/time.h>
struct timeval rb_time_timeval(VALUE);
#endif
#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif
#include "rubyio.h"
#ifdef __cplusplus
}
#endif


#undef do_open
#undef do_close
#include "mecab.h"

#define _PATH_ERROR "Path::check(): access violation"
#define _NODE_ERROR "Node::check(): access violation"

  namespace SWIG_MeCab {
    
    class Node;

    class Path {
    private:	
      mecab_path_t *path;
      char *str;
      char **ptr;
      inline void check () { if (!path || *ptr != str) throw _PATH_ERROR; }
    public:
      Path (mecab_path_t *_path, char *_str, char **_ptr): path (_path), str (_str), ptr (_ptr) {};
      Path (): path (0), str(0), ptr(0) {};
      ~Path() {};
      inline bool hasPath () 
      {
	if (*ptr != str) throw _PATH_ERROR;
	return path ? true : false;
      }
      Node getNode (); 
      inline unsigned int getCost () { check(); return path->cost; }
      inline Path next ()            { check(); Path p (path->next, str, ptr); return p; }
    };

    class Node {

    private:
      mecab_node_t *node;
      char *str;
      char **ptr; // pointer to str;
      inline void check () { if (!node || *ptr != str) throw _NODE_ERROR; }
    public:
      Node (mecab_node_t *_node, char *_str, char **_ptr): node(_node), str(_str), ptr(_ptr) {}
      Node (): node(0), str(0) {}
      ~Node() {};
      inline bool hasNode () 
      {
	if (*ptr != str) throw _NODE_ERROR;
	return node ?  true : false; 
      } 
      inline bool isBest () { check(); return (node->next || node->length == 0)  ? true : false; }
      inline Node prev   () { check(); Node n (node->prev,  str, ptr); return n; }
      inline Node next   () { check(); Node n (node->next,  str, ptr); return n; }

      inline char* toString ()
      {
         check ();
	 unsigned int flen = strlen (node->feature);
	 char *s = new char [node->length + flen + 2];
	 memcpy (s, node->surface, node->length);
	 s[node->length] = '\t';
	 memcpy (s + node->length + 1, node->feature, flen);
	 s[node->length + flen + 1] = '\0';
	 return s;
      }
      
      inline char* getSurface () 
      {
	check();
	char *s = new char [node->length + 1];
	memcpy (s, node->surface, node->length);
	s[node->length] = '\0';
   	return s;
      };

      inline Path getPath ()                   { check(); Path p (node->path, str, ptr); return p; }
      inline char* getFeature ()               { check(); return node->feature; };
      inline unsigned int getLength ()         { check(); return node->length; }
      inline unsigned int getBegin ()          { check(); return node->surface - str; }
      inline unsigned int getEnd ()            { check(); return node->surface - str + node->end; }
      inline unsigned int getID ()             { check(); return node->id; }
      inline unsigned int getRcAttr2 ()        { check(); return node->token->rcAttr2; }
      inline unsigned int getRcAttr1 ()        { check(); return node->token->rcAttr1; }
      inline unsigned int getLcAttr ()         { check(); return node->token->lcAttr;  }
      inline unsigned int getPOSID ()          { check(); return node->token->posid;   }
      inline unsigned int getTotalCost ()      { check(); return node->cost; }
      inline unsigned int getConnectionCost () { check(); return node->cost -node->prev->cost - node->token->cost; }
      inline unsigned int getWordCost ()       { check(); return node->token-> cost; }
      inline unsigned int getNodeCost ()       { check(); return node->cost - node->prev->cost; }
    };

    Node Path::getNode () { check(); Node n (path->node, str, ptr); return n; };

    class Tagger {

    private:
      mecab_t* m;
      char *str;
      
    public:
      Tagger (int argc, char *argv[]): m(0), str(0)
      { 
	if (! (m = mecab_new (argc, argv))) throw mecab_strerror (m); 
      }

      ~Tagger ()
      { 
	delete [] str; str = 0;
	mecab_destroy (m); m = 0;
      }

      Node parseToNode (char *p)
      {
	delete [] str;
	str = new char [strlen(p)+1] ;
	strcpy (str, p);
	Node node (mecab_sparse_tonode (m, str), str, &str);
	return node; 
      }

      inline char* parseToString (char *p) 
      { 
	char *r = mecab_sparse_tostr (m, p);
	if (!r) throw mecab_strerror (m);
	return r;
      }

      inline char* parse (char *p) { return parseToString (p); } // alias
      inline int   lock   ()       { return mecab_lock (m); }
      inline int   unlock ()       { return mecab_unlock (m); }
    };
  }


swig_class cNode;
static void free_SWIG_MeCab_Node(SWIG_MeCab::Node *);

swig_class cPath;
static void free_SWIG_MeCab_Path(SWIG_MeCab::Path *);

swig_class cTagger;
static void free_SWIG_MeCab_Tagger(SWIG_MeCab::Tagger *);
static VALUE
_wrap_Node_hasNode(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (int)(arg1)->hasNode();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_isBest(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (int)(arg1)->isBest();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_prev(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Node result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (arg1)->prev();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Node * resultptr;
        resultptr = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    }
    return vresult;
}


static VALUE
_wrap_Node_next(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Node result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (arg1)->next();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Node * resultptr;
        resultptr = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    }
    return vresult;
}


static VALUE
_wrap_Node_toString(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (char *)(arg1)->toString();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = rb_str_new2(result);
    delete [] result;
    return vresult;
}


static VALUE
_wrap_Node_getSurface(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (char *)(arg1)->getSurface();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = rb_str_new2(result);
    delete [] result;
    return vresult;
}


static VALUE
_wrap_Node_getFeature(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (char *)(arg1)->getFeature();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Node_getPath(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Path result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (arg1)->getPath();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Path * resultptr;
        resultptr = new SWIG_MeCab::Path((SWIG_MeCab::Path &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    }
    return vresult;
}


static VALUE
_wrap_Node_getLength(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getLength();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getBegin(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getBegin();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getEnd(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getEnd();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getID(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getID();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getRcAttr2(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getRcAttr2();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getRcAttr1(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getRcAttr1();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getLcAttr(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getLcAttr();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getPOSID(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getPOSID();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getTotalCost(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getTotalCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getConnectionCost(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getConnectionCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getWordCost(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getWordCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_getNodeCost(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    {
        try {
            result = (unsigned int)(arg1)->getNodeCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Node_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SWIG_MeCab__Node);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_Node(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Node *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (SWIG_MeCab::Node *)new SWIG_MeCab::Node();
            DATA_PTR(self) = result; 
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    return self;
}


static void
free_SWIG_MeCab_Node(SWIG_MeCab::Node *arg1) {
    delete arg1;
}
static VALUE
_wrap_Path_hasPath(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    bool result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    {
        try {
            result = (bool)(arg1)->hasPath();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = result ? Qtrue : Qfalse;
    return vresult;
}


static VALUE
_wrap_Path_getNode(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    SWIG_MeCab::Node result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    {
        try {
            result = (arg1)->getNode();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Node * resultptr;
        resultptr = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    }
    return vresult;
}


static VALUE
_wrap_Path_getCost(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    unsigned int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    {
        try {
            result = (unsigned int)(arg1)->getCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = UINT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Path_next(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    SWIG_MeCab::Path result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    {
        try {
            result = (arg1)->next();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Path * resultptr;
        resultptr = new SWIG_MeCab::Path((SWIG_MeCab::Path &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Path, 1);
    }
    return vresult;
}


static VALUE
_wrap_Path_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SWIG_MeCab__Path);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_Path(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Path *result;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    {
        try {
            result = (SWIG_MeCab::Path *)new SWIG_MeCab::Path();
            DATA_PTR(self) = result; 
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    return self;
}


static void
free_SWIG_MeCab_Path(SWIG_MeCab::Path *arg1) {
    delete arg1;
}
static VALUE
_wrap_Tagger_allocate(int argc, VALUE *argv, VALUE self) {
    VALUE vresult = SWIG_NewClassInstance(self, SWIGTYPE_p_SWIG_MeCab__Tagger);
    rb_obj_call_init(vresult, argc, argv);
    return vresult;
}


static VALUE
_wrap_new_Tagger(int argc, VALUE *argv, VALUE self) {
    int arg1 ;
    char **arg2 ;
    SWIG_MeCab::Tagger *result;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    {
        int i;
        
        if (TYPE(argv[0]) != T_ARRAY) {
            SWIG_exception(SWIG_ValueError, "Expected an array");
        }
        arg1 = RARRAY(argv[0])->len;
        if (arg1 == 0) {
            SWIG_exception(SWIG_ValueError, "List must contain at least 1 element");
        }
        arg2 = new char * [arg1+1];
        for (i = 0; i < arg1; i++) {
            VALUE   s = rb_ary_entry(argv[0],i);
            if (TYPE(s) != T_STRING) {
                delete [] arg2;
                SWIG_exception(SWIG_ValueError, "List items must be strings");
            }
            arg2[i] = STR2CSTR(s);
        }
        arg2[i] = 0;
    }
    {
        try {
            result = (SWIG_MeCab::Tagger *)new SWIG_MeCab::Tagger(arg1,arg2);
            DATA_PTR(self) = result; 
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    
    {
        delete [] arg2;
    }
    return self;
}


static void
free_SWIG_MeCab_Tagger(SWIG_MeCab::Tagger *arg1) {
    delete arg1;
}
static VALUE
_wrap_Tagger_parse(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Tagger, 1);
    arg2 = STR2CSTR(argv[0]);
    {
        try {
            result = (char *)(arg1)->parse(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Tagger_parseToString(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    char *result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Tagger, 1);
    arg2 = STR2CSTR(argv[0]);
    {
        try {
            result = (char *)(arg1)->parseToString(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = rb_str_new2(result);
    return vresult;
}


static VALUE
_wrap_Tagger_parseToNode(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    SWIG_MeCab::Node result;
    VALUE vresult = Qnil;
    
    if ((argc < 1) || (argc > 1))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 1)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Tagger, 1);
    arg2 = STR2CSTR(argv[0]);
    {
        try {
            result = (arg1)->parseToNode(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        SWIG_MeCab::Node * resultptr;
        resultptr = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result);
        vresult = SWIG_NewPointerObj((void *) resultptr, SWIGTYPE_p_SWIG_MeCab__Node, 1);
    }
    return vresult;
}


static VALUE
_wrap_Tagger_lock(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Tagger, 1);
    {
        try {
            result = (int)(arg1)->lock();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}


static VALUE
_wrap_Tagger_unlock(int argc, VALUE *argv, VALUE self) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    int result;
    VALUE vresult = Qnil;
    
    if ((argc < 0) || (argc > 0))
    rb_raise(rb_eArgError, "wrong # of arguments(%d for 0)",argc);
    SWIG_ConvertPtr(self, (void **) &arg1, SWIGTYPE_p_SWIG_MeCab__Tagger, 1);
    {
        try {
            result = (int)(arg1)->unlock();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    vresult = INT2NUM(result);
    return vresult;
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_SWIG_MeCab__Path[] = {{"_p_SWIG_MeCab__Path", 0, "SWIG_MeCab::Path *", 0},{"_p_SWIG_MeCab__Path"},{0}};
static swig_type_info _swigt__p_SWIG_MeCab__Tagger[] = {{"_p_SWIG_MeCab__Tagger", 0, "SWIG_MeCab::Tagger *", 0},{"_p_SWIG_MeCab__Tagger"},{0}};
static swig_type_info _swigt__p_p_char[] = {{"_p_p_char", 0, "char **", 0},{"_p_p_char"},{0}};
static swig_type_info _swigt__p_SWIG_MeCab__Node[] = {{"_p_SWIG_MeCab__Node", 0, "SWIG_MeCab::Node *", 0},{"_p_SWIG_MeCab__Node"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_SWIG_MeCab__Path, 
_swigt__p_SWIG_MeCab__Tagger, 
_swigt__p_p_char, 
_swigt__p_SWIG_MeCab__Node, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */


#ifdef __cplusplus
extern "C"
#endif
SWIGEXPORT(void) Init_MeCab(void) {
    int i;
    
    SWIG_InitRuntime();
    mMeCab = rb_define_module("MeCab");
    
    for (i = 0; swig_types_initial[i]; i++) {
        swig_types[i] = SWIG_TypeRegister(swig_types_initial[i]);
        SWIG_define_class(swig_types[i]);
    }
    
    
    cNode.klass = rb_define_class_under(mMeCab, "Node", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_SWIG_MeCab__Node, (void *) &cNode);
    rb_define_singleton_method(cNode.klass, "new", VALUEFUNC(_wrap_Node_allocate), -1);
    rb_define_method(cNode.klass, "initialize", VALUEFUNC(_wrap_new_Node), -1);
    rb_define_method(cNode.klass, "hasNode", VALUEFUNC(_wrap_Node_hasNode), -1);
    rb_define_method(cNode.klass, "isBest", VALUEFUNC(_wrap_Node_isBest), -1);
    rb_define_method(cNode.klass, "prev", VALUEFUNC(_wrap_Node_prev), -1);
    rb_define_method(cNode.klass, "next", VALUEFUNC(_wrap_Node_next), -1);
    rb_define_method(cNode.klass, "toString", VALUEFUNC(_wrap_Node_toString), -1);
    rb_define_method(cNode.klass, "getSurface", VALUEFUNC(_wrap_Node_getSurface), -1);
    rb_define_method(cNode.klass, "getFeature", VALUEFUNC(_wrap_Node_getFeature), -1);
    rb_define_method(cNode.klass, "getPath", VALUEFUNC(_wrap_Node_getPath), -1);
    rb_define_method(cNode.klass, "getLength", VALUEFUNC(_wrap_Node_getLength), -1);
    rb_define_method(cNode.klass, "getBegin", VALUEFUNC(_wrap_Node_getBegin), -1);
    rb_define_method(cNode.klass, "getEnd", VALUEFUNC(_wrap_Node_getEnd), -1);
    rb_define_method(cNode.klass, "getID", VALUEFUNC(_wrap_Node_getID), -1);
    rb_define_method(cNode.klass, "getRcAttr2", VALUEFUNC(_wrap_Node_getRcAttr2), -1);
    rb_define_method(cNode.klass, "getRcAttr1", VALUEFUNC(_wrap_Node_getRcAttr1), -1);
    rb_define_method(cNode.klass, "getLcAttr", VALUEFUNC(_wrap_Node_getLcAttr), -1);
    rb_define_method(cNode.klass, "getPOSID", VALUEFUNC(_wrap_Node_getPOSID), -1);
    rb_define_method(cNode.klass, "getTotalCost", VALUEFUNC(_wrap_Node_getTotalCost), -1);
    rb_define_method(cNode.klass, "getConnectionCost", VALUEFUNC(_wrap_Node_getConnectionCost), -1);
    rb_define_method(cNode.klass, "getWordCost", VALUEFUNC(_wrap_Node_getWordCost), -1);
    rb_define_method(cNode.klass, "getNodeCost", VALUEFUNC(_wrap_Node_getNodeCost), -1);
    cNode.mark = 0;
    cNode.destroy = (void (*)(void *)) free_SWIG_MeCab_Node;
    
    cPath.klass = rb_define_class_under(mMeCab, "Path", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_SWIG_MeCab__Path, (void *) &cPath);
    rb_define_singleton_method(cPath.klass, "new", VALUEFUNC(_wrap_Path_allocate), -1);
    rb_define_method(cPath.klass, "initialize", VALUEFUNC(_wrap_new_Path), -1);
    rb_define_method(cPath.klass, "hasPath", VALUEFUNC(_wrap_Path_hasPath), -1);
    rb_define_method(cPath.klass, "getNode", VALUEFUNC(_wrap_Path_getNode), -1);
    rb_define_method(cPath.klass, "getCost", VALUEFUNC(_wrap_Path_getCost), -1);
    rb_define_method(cPath.klass, "next", VALUEFUNC(_wrap_Path_next), -1);
    cPath.mark = 0;
    cPath.destroy = (void (*)(void *)) free_SWIG_MeCab_Path;
    
    cTagger.klass = rb_define_class_under(mMeCab, "Tagger", rb_cObject);
    SWIG_TypeClientData(SWIGTYPE_p_SWIG_MeCab__Tagger, (void *) &cTagger);
    rb_define_singleton_method(cTagger.klass, "new", VALUEFUNC(_wrap_Tagger_allocate), -1);
    rb_define_method(cTagger.klass, "initialize", VALUEFUNC(_wrap_new_Tagger), -1);
    rb_define_method(cTagger.klass, "parse", VALUEFUNC(_wrap_Tagger_parse), -1);
    rb_define_method(cTagger.klass, "parseToString", VALUEFUNC(_wrap_Tagger_parseToString), -1);
    rb_define_method(cTagger.klass, "parseToNode", VALUEFUNC(_wrap_Tagger_parseToNode), -1);
    rb_define_method(cTagger.klass, "lock", VALUEFUNC(_wrap_Tagger_lock), -1);
    rb_define_method(cTagger.klass, "unlock", VALUEFUNC(_wrap_Tagger_unlock), -1);
    cTagger.mark = 0;
    cTagger.destroy = (void (*)(void *)) free_SWIG_MeCab_Tagger;
}

