/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.19
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<class T> class SwigValueWrapper {
    T *tt;
public:
    inline SwigValueWrapper() : tt(0) { }
    inline ~SwigValueWrapper() { if (tt) delete tt; } 
    inline SwigValueWrapper& operator=(const T& t) { tt = new T(t); return *this; }
    inline operator T&() const { return *tt; }
    inline T *operator&() { return tt; }
};                                                    
#endif


#if defined(__GNUC__)
    typedef long long __int64; /*For gcc on Windows */
#endif
#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;

#if defined(SWIG_NOINCLUDE)
void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg);
#else


void SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" } };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  jenv->ExceptionClear();
  excep = jenv->FindClass(except_ptr->java_exception);
  if (excep)
    jenv->ThrowNew(excep, msg);
}


#endif


#define  SWIG_MemoryError    1
#define  SWIG_IOError        2
#define  SWIG_RuntimeError   3
#define  SWIG_IndexError     4
#define  SWIG_TypeError      5
#define  SWIG_DivisionByZero 6
#define  SWIG_OverflowError  7
#define  SWIG_SyntaxError    8
#define  SWIG_ValueError     9
#define  SWIG_SystemError   10
#define  SWIG_UnknownError  99


static void SWIG_JavaException(JNIEnv *jenv, int code, const char *msg) {
  SWIG_JavaExceptionCodes exception_code = SWIG_JavaUnknownError;
  switch(code) {
  case SWIG_MemoryError:
    exception_code = SWIG_JavaOutOfMemoryError;
    break;
  case SWIG_IOError:
    exception_code = SWIG_JavaIOException;
    break;
  case SWIG_SystemError:
  case SWIG_RuntimeError:
    exception_code = SWIG_JavaRuntimeException;
    break;
  case SWIG_OverflowError:
  case SWIG_IndexError:
    exception_code = SWIG_JavaIndexOutOfBoundsException;
    break;
  case SWIG_DivisionByZero:
    exception_code = SWIG_JavaArithmeticException;
    break;
  case SWIG_SyntaxError:
  case SWIG_ValueError:
  case SWIG_TypeError:
    exception_code = SWIG_JavaIllegalArgumentException;
    break;
  case SWIG_UnknownError:
  default:
    exception_code = SWIG_JavaUnknownError;
    break;
  }
  SWIG_JavaThrowException(jenv, exception_code, msg);
}
#define SWIG_exception(code, msg) { SWIG_JavaException(jenv, code, msg); }


#undef do_open
#undef do_close
#include "mecab.h"

#define _PATH_ERROR "Path::check(): access violation"
#define _NODE_ERROR "Node::check(): access violation"

  namespace SWIG_MeCab {
    
    class Node;

    class Path {
    private:	
      mecab_path_t *path;
      char *str;
      char **ptr;
      inline void check () { if (!path || *ptr != str) throw _PATH_ERROR; }
    public:
      Path (mecab_path_t *_path, char *_str, char **_ptr): path (_path), str (_str), ptr (_ptr) {};
      Path (): path (0), str(0), ptr(0) {};
      ~Path() {};
      inline bool hasPath () 
      {
	if (*ptr != str) throw _PATH_ERROR;
	return path ? true : false;
      }
      Node getNode (); 
      inline unsigned int getCost () { check(); return path->cost; }
      inline Path next ()            { check(); Path p (path->next, str, ptr); return p; }
    };

    class Node {

    private:
      mecab_node_t *node;
      char *str;
      char **ptr; // pointer to str;
      inline void check () { if (!node || *ptr != str) throw _NODE_ERROR; }
    public:
      Node (mecab_node_t *_node, char *_str, char **_ptr): node(_node), str(_str), ptr(_ptr) {}
      Node (): node(0), str(0) {}
      ~Node() {};
      inline bool hasNode () 
      {
	if (*ptr != str) throw _NODE_ERROR;
	return node ?  true : false; 
      } 
      inline bool isBest () { check(); return (node->next || node->length == 0)  ? true : false; }
      inline Node prev   () { check(); Node n (node->prev,  str, ptr); return n; }
      inline Node next   () { check(); Node n (node->next,  str, ptr); return n; }

      inline char* toString ()
      {
         check ();
	 unsigned int flen = strlen (node->feature);
	 char *s = new char [node->length + flen + 2];
	 memcpy (s, node->surface, node->length);
	 s[node->length] = '\t';
	 memcpy (s + node->length + 1, node->feature, flen);
	 s[node->length + flen + 1] = '\0';
	 return s;
      }
      
      inline char* getSurface () 
      {
	check();
	char *s = new char [node->length + 1];
	memcpy (s, node->surface, node->length);
	s[node->length] = '\0';
   	return s;
      };

      inline Path getPath ()                   { check(); Path p (node->path, str, ptr); return p; }
      inline char* getFeature ()               { check(); return node->feature; };
      inline unsigned int getLength ()         { check(); return node->length; }
      inline unsigned int getBegin ()          { check(); return node->surface - str; }
      inline unsigned int getEnd ()            { check(); return node->surface - str + node->end; }
      inline unsigned int getID ()             { check(); return node->id; }
      inline unsigned int getRcAttr2 ()        { check(); return node->token->rcAttr2; }
      inline unsigned int getRcAttr1 ()        { check(); return node->token->rcAttr1; }
      inline unsigned int getLcAttr ()         { check(); return node->token->lcAttr;  }
      inline unsigned int getPOSID ()          { check(); return node->token->posid;   }
      inline unsigned int getTotalCost ()      { check(); return node->cost; }
      inline unsigned int getConnectionCost () { check(); return node->cost -node->prev->cost - node->token->cost; }
      inline unsigned int getWordCost ()       { check(); return node->token-> cost; }
      inline unsigned int getNodeCost ()       { check(); return node->cost - node->prev->cost; }
    };

    Node Path::getNode () { check(); Node n (path->node, str, ptr); return n; };

    class Tagger {

    private:
      mecab_t* m;
      char *str;
      
    public:
      Tagger (int argc, char *argv[]): m(0), str(0)
      { 
	if (! (m = mecab_new (argc, argv))) throw mecab_strerror (m); 
      }

      ~Tagger ()
      { 
	delete [] str; str = 0;
	mecab_destroy (m); m = 0;
      }

      Node parseToNode (char *p)
      {
	delete [] str;
	str = new char [strlen(p)+1] ;
	strcpy (str, p);
	Node node (mecab_sparse_tonode (m, str), str, &str);
	return node; 
      }

      inline char* parseToString (char *p) 
      { 
	char *r = mecab_sparse_tostr (m, p);
	if (!r) throw mecab_strerror (m);
	return r;
      }

      inline char* parse (char *p) { return parseToString (p); } // alias
      inline int   lock   ()       { return mecab_lock (m); }
      inline int   unlock ()       { return mecab_unlock (m); }
    };
  }

#ifdef __cplusplus
extern "C" {
#endif

JNIEXPORT jint JNICALL Java_MeCabJNI_Node_1hasNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (int)(arg1)->hasNode();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_MeCabJNI_Node_1isBest(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (int)(arg1)->isBest();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1prev(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Node result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (arg1)->prev();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Node **)&jresult = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Node result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (arg1)->next();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Node **)&jresult = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result); 
    return jresult;
}


JNIEXPORT jstring JNICALL Java_MeCabJNI_Node_1toString(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (char *)(arg1)->toString();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    delete [] result;
    return jresult;
}


JNIEXPORT jstring JNICALL Java_MeCabJNI_Node_1getSurface(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (char *)(arg1)->getSurface();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    delete [] result;
    return jresult;
}


JNIEXPORT jstring JNICALL Java_MeCabJNI_Node_1getFeature(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jstring jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (char *)(arg1)->getFeature();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getPath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    SWIG_MeCab::Path result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (arg1)->getPath();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Path **)&jresult = new SWIG_MeCab::Path((SWIG_MeCab::Path &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getLength(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getLength();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getBegin(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getBegin();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getEnd(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getEnd();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getID();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getRcAttr2(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getRcAttr2();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getRcAttr1(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getRcAttr1();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getLcAttr(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getLcAttr();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getPOSID(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getPOSID();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getTotalCost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getTotalCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getConnectionCost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getConnectionCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getWordCost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getWordCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Node_1getNodeCost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getNodeCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_new_1Node(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    SWIG_MeCab::Node *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (SWIG_MeCab::Node *)new SWIG_MeCab::Node();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Node **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_MeCabJNI_delete_1Node(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SWIG_MeCab::Node *arg1 = (SWIG_MeCab::Node *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Node **)&jarg1; 
    {
        try {
            delete arg1;
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
}


JNIEXPORT jboolean JNICALL Java_MeCabJNI_Path_1hasPath(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jboolean jresult = 0 ;
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    bool result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Path **)&jarg1; 
    {
        try {
            result = (bool)(arg1)->hasPath();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jboolean)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Path_1getNode(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    SWIG_MeCab::Node result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Path **)&jarg1; 
    {
        try {
            result = (arg1)->getNode();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Node **)&jresult = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Path_1getCost(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    unsigned int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Path **)&jarg1; 
    {
        try {
            result = (unsigned int)(arg1)->getCost();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jlong)result; 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Path_1next(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jlong jresult = 0 ;
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    SWIG_MeCab::Path result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Path **)&jarg1; 
    {
        try {
            result = (arg1)->next();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Path **)&jresult = new SWIG_MeCab::Path((SWIG_MeCab::Path &)result); 
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_new_1Path(JNIEnv *jenv, jclass jcls) {
    jlong jresult = 0 ;
    SWIG_MeCab::Path *result;
    
    (void)jenv;
    (void)jcls;
    {
        try {
            result = (SWIG_MeCab::Path *)new SWIG_MeCab::Path();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Path **)&jresult = result; 
    return jresult;
}


JNIEXPORT void JNICALL Java_MeCabJNI_delete_1Path(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SWIG_MeCab::Path *arg1 = (SWIG_MeCab::Path *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Path **)&jarg1; 
    {
        try {
            delete arg1;
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_new_1Tagger(JNIEnv *jenv, jclass jcls, jobjectArray jarg1) {
    jlong jresult = 0 ;
    int arg1 ;
    char **arg2 ;
    SWIG_MeCab::Tagger *result;
    jstring *jsarray1 ;
    
    (void)jenv;
    (void)jcls;
    {
        int i;
        
        arg1 = jenv->GetArrayLength(jarg1);
        if (arg1 == 0) {
            SWIG_JavaThrowException(jenv, SWIG_JavaIndexOutOfBoundsException, "Array must contain at least 1 element");
            return 0;
        }
        arg2 = new char * [arg1+1];
        jsarray1 = new jstring [arg1+1];
        for (i = 0; i < arg1; i++) {
            jsarray1[i] = (jstring) jenv->GetObjectArrayElement(jarg1, i);
            arg2[i] = (char *)       jenv->GetStringUTFChars(jsarray1[i], 0);
        }
        arg2[i] = 0;
    }
    {
        try {
            result = (SWIG_MeCab::Tagger *)new SWIG_MeCab::Tagger(arg1,arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Tagger **)&jresult = result; 
    
    {
        int i;
        for (i = 0; i < arg1; i++) {
            jenv->ReleaseStringUTFChars(jsarray1[i], arg2[i]);
        }
        delete [] arg2;
    }
    return jresult;
}


JNIEXPORT void JNICALL Java_MeCabJNI_delete_1Tagger(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        try {
            delete arg1;
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
}


JNIEXPORT jstring JNICALL Java_MeCabJNI_Tagger_1parse(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        try {
            result = (char *)(arg1)->parse(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jstring JNICALL Java_MeCabJNI_Tagger_1parseToString(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jstring jresult = 0 ;
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    char *result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        try {
            result = (char *)(arg1)->parseToString(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    {
        if(result) jresult = jenv->NewStringUTF(result); 
    }
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jlong JNICALL Java_MeCabJNI_Tagger_1parseToNode(JNIEnv *jenv, jclass jcls, jlong jarg1, jstring jarg2) {
    jlong jresult = 0 ;
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    char *arg2 ;
    SWIG_MeCab::Node result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        arg2 = 0;
        if (jarg2) {
            arg2 = (char *)jenv->GetStringUTFChars(jarg2, 0);
            if (!arg2) return 0;
        }
    }
    {
        try {
            result = (arg1)->parseToNode(arg2);
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    *(SWIG_MeCab::Node **)&jresult = new SWIG_MeCab::Node((SWIG_MeCab::Node &)result); 
    {
        if (arg2) jenv->ReleaseStringUTFChars(jarg2, arg2); 
    }
    return jresult;
}


JNIEXPORT jint JNICALL Java_MeCabJNI_Tagger_1lock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        try {
            result = (int)(arg1)->lock();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jint)result; 
    return jresult;
}


JNIEXPORT jint JNICALL Java_MeCabJNI_Tagger_1unlock(JNIEnv *jenv, jclass jcls, jlong jarg1) {
    jint jresult = 0 ;
    SWIG_MeCab::Tagger *arg1 = (SWIG_MeCab::Tagger *) 0 ;
    int result;
    
    (void)jenv;
    (void)jcls;
    arg1 = *(SWIG_MeCab::Tagger **)&jarg1; 
    {
        try {
            result = (int)(arg1)->unlock();
        }
        catch (char *e) {
            SWIG_exception (SWIG_RuntimeError, e); 
        }
        catch (const char *e) {
            SWIG_exception (SWIG_RuntimeError, (char*)e); 
        }
    }
    jresult = (jint)result; 
    return jresult;
}


#ifdef __cplusplus
}
#endif

