#include <mecab.h>
#include <iostream>
#include <stdexcept>

// $Id: example2.cpp,v 1.3 2003/01/24 17:13:51 taku-ku Exp $;
// c++ -I/usr/local/include -L/usr/local/lib -o example2 example2.cpp -lmecab

int main (int argc, char **argv)
{
   using namespace std;

   try {
      const char p[] = "ϺϼϺäƤܤֻҤϤ";
      
      MeCab::Tagger t (argc, argv);
      std::cout << "INPUT:" << std::endl << p << std::endl;
      
      const char *r = t.parse (p);
      std::cout << "OUTPUT:" << std::endl << (void *) r;
      const char *r2 = t.parse (p);
      std::cout << "OUTPUT:" << std::endl << (void *) r2;

      cout << t.lock () << endl;
      MeCab::Node *n = t.parseToNode(p);
      for (; n; n = n->next) {
	 std::cout.write (n->surface, n->length);
	 std::cout << "\t" << n->feature << std::endl;
      }
      std::cout << "EOS\n";
      t.unlock ();

      return 0;
   } 
   
   catch (exception &e) {
      cerr << "FATAL: " << e.what () << endl;
      return -1;
   }
}
